/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.data.Value;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.LineEmitter;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.TestRow;
import de.neemann.digital.testing.parser.ValueAppender;
import java.util.ArrayList;

public class LineEmitterSimple
implements LineEmitter {
    private final ArrayList<ValueAppender> appender;
    private final int valuesCount;
    private final int line;

    public LineEmitterSimple(int valuesCount, int line) {
        this.valuesCount = valuesCount;
        this.line = line;
        this.appender = new ArrayList();
    }

    public void add(ValueAppender app) {
        this.appender.add(app);
    }

    @Override
    public void emitLines(LineListener listener, Context context) throws ParserException {
        ArrayList<Value> vals = new ArrayList<Value>(this.valuesCount);
        for (ValueAppender ve : this.appender) {
            ve.appendValues(vals, context);
        }
        if (vals.size() != this.valuesCount) {
            throw new ParserException(Lang.get("err_testDataExpected_N0_found_N1_numbersInLine_N2", this.valuesCount, vals.size(), this.line));
        }
        String description = "L" + this.line;
        String conString = context.toString();
        if (!conString.isEmpty()) {
            description = String.valueOf(description) + ";" + conString;
        }
        listener.add(new TestRow(vals.toArray(new Value[vals.size()]), description));
    }
}

