/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.testing.parser.OperatorPrecedence;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class Tokenizer {
    private static final HashMap<String, Token> STATEMENT_MAP = new HashMap();
    private final Reader in;
    private final StringBuilder builder;
    private Token token;
    private boolean isToken;
    private boolean isUnreadChar = false;
    private int unreadChar;
    private int line = 1;

    static {
        STATEMENT_MAP.put("end", Token.END);
        STATEMENT_MAP.put("loop", Token.LOOP);
        STATEMENT_MAP.put("repeat", Token.REPEAT);
        STATEMENT_MAP.put("bits", Token.BITS);
        STATEMENT_MAP.put("let", Token.LET);
        STATEMENT_MAP.put("resetRandom", Token.RESETRANDOM);
        STATEMENT_MAP.put("while", Token.WHILE);
        STATEMENT_MAP.put("declare", Token.DECLARE);
        STATEMENT_MAP.put("program", Token.PROGRAM);
        STATEMENT_MAP.put("init", Token.INIT);
        STATEMENT_MAP.put("memory", Token.MEMORY);
    }

    public Tokenizer(Reader in) {
        this.in = in;
        this.token = Token.UNKNOWN;
        this.isToken = false;
        this.builder = new StringBuilder();
    }

    public Token next() throws IOException {
        Token token = this.peek();
        this.consume();
        return token;
    }

    public void consume() {
        this.isToken = false;
    }

    public Token peek() throws IOException {
        int c;
        if (this.isToken) {
            return this.token;
        }
        while (this.isWhiteSpace(c = this.readChar())) {
        }
        switch (c) {
            case -1: {
                this.token = Token.EOF;
                break;
            }
            case 10: 
            case 13: {
                return Token.EOL;
            }
            case 40: {
                this.token = Token.OPEN;
                break;
            }
            case 41: {
                this.token = Token.CLOSE;
                break;
            }
            case 59: {
                this.token = Token.SEMICOLON;
                break;
            }
            case 38: {
                this.token = Token.AND;
                break;
            }
            case 124: {
                this.token = Token.OR;
                break;
            }
            case 94: {
                this.token = Token.XOR;
                break;
            }
            case 43: {
                this.token = Token.ADD;
                break;
            }
            case 45: {
                this.token = Token.SUB;
                break;
            }
            case 42: {
                this.token = Token.MUL;
                break;
            }
            case 37: {
                this.token = Token.MOD;
                break;
            }
            case 47: {
                this.token = Token.DIV;
                break;
            }
            case 60: {
                if (this.isNextChar('<')) {
                    this.token = Token.SHIFT_LEFT;
                    break;
                }
                if (this.isNextChar('=')) {
                    this.token = Token.SMALLER_EQUAL;
                    break;
                }
                this.token = Token.SMALLER;
                break;
            }
            case 62: {
                if (this.isNextChar('>')) {
                    this.token = Token.SHIFT_RIGHT;
                    break;
                }
                if (this.isNextChar('=')) {
                    this.token = Token.GREATER_EQUAL;
                    break;
                }
                this.token = Token.GREATER;
                break;
            }
            case 126: {
                this.token = Token.BIN_NOT;
                break;
            }
            case 33: {
                if (this.isNextChar('=')) {
                    this.token = Token.NOT_EQUAL;
                    break;
                }
                this.token = Token.LOG_NOT;
                break;
            }
            case 44: {
                this.token = Token.COMMA;
                break;
            }
            case 61: {
                this.token = Token.EQUAL;
                break;
            }
            default: {
                if (this.isIdentChar(c)) {
                    this.token = Token.IDENT;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                    boolean wasChar = true;
                    do {
                        if (this.isIdentChar(c = this.readChar()) || this.isNumberChar(c)) {
                            this.builder.append((char)c);
                            continue;
                        }
                        this.unreadChar(c);
                        wasChar = false;
                    } while (wasChar);
                    this.token = STATEMENT_MAP.get(this.builder.toString());
                    if (this.token != null) break;
                    this.token = Token.IDENT;
                    break;
                }
                if (this.isNumberChar(c)) {
                    this.token = Token.NUMBER;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                    boolean wasChar = true;
                    do {
                        if (this.isNumberChar(c = this.readChar()) || this.isHexChar(c) || c == 120 || c == 88 || c == 58 || c == 46) {
                            this.builder.append((char)c);
                            continue;
                        }
                        this.unreadChar(c);
                        wasChar = false;
                    } while (wasChar);
                    break;
                }
                this.token = Token.UNKNOWN;
                this.builder.setLength(0);
                this.builder.append((char)c);
            }
        }
        this.isToken = true;
        return this.token;
    }

    private boolean isNextChar(char should) throws IOException {
        int c = this.readChar();
        if (c == should) {
            return true;
        }
        this.unreadChar(c);
        return false;
    }

    public String getIdent() {
        return this.builder.toString();
    }

    private int readIntChar() throws IOException {
        if (this.isUnreadChar) {
            this.isUnreadChar = false;
            return this.unreadChar;
        }
        int c = this.in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private int readChar() throws IOException {
        int c = this.readIntChar();
        if (c == 35) {
            while ((c = this.readIntChar()) != 10 && c >= 0) {
            }
        }
        return c;
    }

    private void unreadChar(int c) {
        this.unreadChar = c;
        this.isUnreadChar = true;
    }

    private boolean isIdentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private boolean isHexChar(int c) {
        return c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private boolean isNumberChar(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 9;
    }

    public String toString() {
        if (this.token == Token.IDENT || this.token == Token.UNKNOWN) {
            return this.getIdent();
        }
        return this.token.name();
    }

    public int getLine() {
        return this.line;
    }

    public void skipEmptyLines() throws IOException {
        int c;
        while ((c = this.readChar()) == 10 || c == 13 || c == 32) {
        }
        this.unreadChar(c);
    }

    public Token simpleIdent() throws IOException {
        this.builder.setLength(0);
        block5: while (true) {
            int c = this.readChar();
            switch (c) {
                case -1: {
                    return Token.EOF;
                }
                case 10: 
                case 13: {
                    if (this.builder.length() > 0) {
                        this.unreadChar(c);
                        return Token.IDENT;
                    }
                    return Token.EOL;
                }
                case 9: 
                case 32: {
                    if (this.builder.length() <= 0) continue block5;
                    return Token.IDENT;
                }
            }
            this.builder.append((char)c);
        }
    }

    static interface Binary {
        public long op(long var1, long var3);
    }

    static enum Token {
        UNKNOWN,
        IDENT,
        BIN_NOT,
        LOG_NOT,
        OPEN,
        CLOSE,
        NUMBER,
        EOL,
        EOF,
        COMMA,
        AND(OperatorPrecedence.AND, (a, b) -> a & b),
        OR(OperatorPrecedence.OR, (a, b) -> a | b),
        XOR(OperatorPrecedence.XOR, (a, b) -> a ^ b),
        SHIFT_LEFT(OperatorPrecedence.SHIFT, (a, b) -> a << (int)b),
        SHIFT_RIGHT(OperatorPrecedence.SHIFT, (a, b) -> a >> (int)b),
        EQUAL(OperatorPrecedence.EQUAL, (a, b) -> a == b ? 1 : 0),
        NOT_EQUAL(OperatorPrecedence.EQUAL, (a, b) -> a != b ? 1 : 0),
        ADD(OperatorPrecedence.ADD, (a, b) -> a + b),
        SUB(OperatorPrecedence.ADD, (a, b) -> a - b),
        MUL(OperatorPrecedence.MUL, (a, b) -> a * b),
        DIV(OperatorPrecedence.MUL, (a, b) -> a / b),
        MOD(OperatorPrecedence.MUL, (a, b) -> a % b),
        GREATER(OperatorPrecedence.COMPARE, (a, b) -> a > b ? 1 : 0),
        GREATER_EQUAL(OperatorPrecedence.COMPARE, (a, b) -> a >= b ? 1 : 0),
        SMALLER(OperatorPrecedence.COMPARE, (a, b) -> a < b ? 1 : 0),
        SMALLER_EQUAL(OperatorPrecedence.COMPARE, (a, b) -> a <= b ? 1 : 0),
        END,
        LOOP,
        REPEAT,
        BITS,
        SEMICOLON,
        LET,
        DECLARE,
        PROGRAM,
        INIT,
        MEMORY,
        WHILE,
        RESETRANDOM;

        private final OperatorPrecedence precedence;
        private final Binary function;

        private Token() {
            this(null, null);
        }

        private Token(OperatorPrecedence precedence, Binary function) {
            this.precedence = precedence;
            this.function = function;
        }

        public OperatorPrecedence getPrecedence() {
            return this.precedence;
        }

        public Binary getFunction() {
            return this.function;
        }
    }
}

