/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.data.Value;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.Expression;
import de.neemann.digital.testing.parser.ParserException;
import de.neemann.digital.testing.parser.ValueAppender;
import java.util.ArrayList;

public class ValueAppenderBits
implements ValueAppender {
    private final Expression expression;
    private final int bitCount;

    public ValueAppenderBits(int bitCount, Expression expression) {
        this.bitCount = bitCount;
        this.expression = expression;
    }

    @Override
    public void appendValues(ArrayList<Value> values, Context context) throws ParserException {
        long value = this.expression.value(context);
        long mask = 1L << this.bitCount - 1;
        int i = 0;
        while (i < this.bitCount) {
            boolean v = (value & mask) != 0L;
            values.add(new Value(v ? 1 : 0));
            mask >>>= 1;
            ++i;
        }
    }
}

