/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Observer;
import de.neemann.digital.testing.parser.Context;
import de.neemann.digital.testing.parser.Expression;
import de.neemann.digital.testing.parser.ParserException;

public class VirtualSignal {
    private final String sigName;
    private final Expression sigExpression;

    public VirtualSignal(String sigName, Expression sigExpression) {
        this.sigName = sigName;
        this.sigExpression = sigExpression;
    }

    public String getName() {
        return this.sigName;
    }

    public ObservableValue getValue(final Context context) {
        return new ObservableValue(this.sigName, 64){

            @Override
            public long getValue() {
                try {
                    return VirtualSignal.this.sigExpression.value(context);
                }
                catch (ParserException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Observer addObserver(Observer observer) {
                throw new RuntimeException("not supported");
            }
        };
    }
}

