/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.toolchain;

import de.neemann.digital.toolchain.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCache.class);
    private final File initialFile;
    private final HashMap<String, Configuration> cache;

    ConfigCache(File initialFile) {
        this.initialFile = initialFile;
        this.cache = new HashMap();
    }

    Configuration getConfig(String filename) throws IOException {
        if (this.initialFile == null) {
            throw new IOException("No initial config file given!");
        }
        Configuration c = this.cache.get(filename);
        if (c == null) {
            File file = new File(this.initialFile.getParentFile(), filename);
            LOGGER.info("load config " + file);
            c = Configuration.load(file);
            this.cache.put(filename, c);
        }
        return c;
    }
}

