/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.toolchain;

import com.thoughtworks.xstream.XStream;
import de.neemann.digital.XStreamValid;
import de.neemann.digital.builder.tt2.OSExecute;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.StatusInterface;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSArray;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.clock.ClockIntegratorGeneric;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.verilog2.VerilogGenerator;
import de.neemann.digital.hdl.vhdl2.VHDLGenerator;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.toolchain.Command;
import de.neemann.digital.toolchain.ConfigCache;
import de.neemann.digital.toolchain.FileToCreate;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.language.Resources;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    static final String LOOK_AT_ALIAS = "lookAt";
    static final String REF_ALIAS = "ref";
    private String name;
    private int frequency;
    private String clockGenerator;
    private ArrayList<Command> commands;
    private ArrayList<FileToCreate> files = new ArrayList();
    private Map<String, String> params;
    private transient FilenameProvider filenameProvider;
    private transient CircuitProvider circuitProvider;
    private transient LibraryProvider libraryProvider;
    private transient IOInterface ioInterface;
    private transient File origin;

    public static Configuration load(File file) throws IOException {
        Configuration configuration = Configuration.load(new FileInputStream(file));
        configuration.origin = file;
        return configuration;
    }

    public static Configuration load(InputStream in) throws IOException {
        try {
            XStream xStream = Configuration.getxStream();
            return (Configuration)xStream.fromXML(in);
        }
        catch (RuntimeException e) {
            throw new IOException("error reading XML", e);
        }
    }

    private static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("toolchain", Configuration.class);
        xStream.aliasAttribute(Configuration.class, "name", "name");
        xStream.aliasAttribute(Configuration.class, "frequency", "frequency");
        xStream.aliasAttribute(Configuration.class, "clockGenerator", "clockGenerator");
        xStream.aliasAttribute(Configuration.class, "params", "params");
        xStream.registerConverter(new Resources.MapEntryConverter("param"));
        xStream.alias("command", Command.class);
        xStream.aliasAttribute(Command.class, "name", "name");
        xStream.aliasAttribute(Command.class, "requires", "requires");
        xStream.aliasAttribute(Command.class, "filter", "filter");
        xStream.aliasAttribute(Command.class, "timeout", "timeout");
        xStream.addImplicitCollection(Command.class, "args", "arg", String.class);
        xStream.alias("file", FileToCreate.class);
        xStream.aliasAttribute(FileToCreate.class, "name", "name");
        xStream.aliasAttribute(FileToCreate.class, "overwrite", "overwrite");
        xStream.aliasAttribute(FileToCreate.class, "filter", "filter");
        xStream.aliasAttribute(FileToCreate.class, "id", "id");
        xStream.aliasAttribute(FileToCreate.class, "referenceFilename", LOOK_AT_ALIAS);
        xStream.aliasAttribute(FileToCreate.class, "referenceId", REF_ALIAS);
        return xStream;
    }

    private Configuration() {
        this.commands = new ArrayList();
    }

    public Configuration setFilenameProvider(FilenameProvider filenameProvider) {
        this.filenameProvider = filenameProvider;
        return this;
    }

    public Configuration setCircuitProvider(CircuitProvider circuitProvider) {
        this.circuitProvider = circuitProvider;
        return this;
    }

    public Configuration setLibraryProvider(LibraryProvider libraryProvider) {
        this.libraryProvider = libraryProvider;
        return this;
    }

    Configuration setIoInterface(IOInterface ioInterface) {
        this.ioInterface = ioInterface;
        return this;
    }

    public JMenu createMenu(StatusInterface statusInterface) {
        JMenu menu = new JMenu(this.name);
        for (Command c : this.commands) {
            menu.add(new JMenuItem(new ExecuteAction(c, statusInterface)));
        }
        return menu;
    }

    private Context createContext(File fileToExecute, HDLModel hdlModel, Command command) throws HGSEvalException {
        Context context = new Context(hdlModel == null ? null : hdlModel.getRoot()).declareVar("path", fileToExecute.getPath()).declareVar("dir", fileToExecute.getParentFile()).declareVar("name", fileToExecute.getName()).declareVar("shortname", this.createShortname(fileToExecute.getName()));
        if (this.params != null) {
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                context.declareVar(e.getKey(), this.toHGLValue(e.getValue()));
            }
        }
        if (command.needsHDL()) {
            context.declareVar("hdl", command.getHDL());
            if (command.getHDL().equals("vhdl")) {
                context.declareVar("extension", ".vhdl");
            } else {
                context.declareVar("extension", ".v");
            }
        }
        if (this.clockGenerator != null) {
            context.declareVar("clockGenerator", this.clockGenerator);
        }
        if (hdlModel != null) {
            context.declareVar("model", new ModelAccess(hdlModel.getMain()));
        }
        return context;
    }

    private Object toHGLValue(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                return value;
            }
        }
    }

    private IOInterface getIoInterface() {
        if (this.ioInterface == null) {
            this.ioInterface = new DefaultIOInterface();
        }
        return this.ioInterface;
    }

    private String createShortname(String name) {
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return name.substring(0, p);
        }
        return name;
    }

    private HDLModel writeHDL(String hdl, File digFile) throws IOException, HGSEvalException, ElementNotFoundException, PinException, NodeException {
        new ModelCreator(this.circuitProvider.getCurrentCircuit(), this.libraryProvider.getCurrentLibrary()).createModel(false).close();
        int modelDefinedFrequency = this.getFrequency();
        boolean modelHasClock = modelDefinedFrequency > 0;
        switch (hdl) {
            case "verilog": {
                File verilogFile = SaveAsHelper.checkSuffix(digFile, "v");
                CodePrinter verilogPrinter = new CodePrinter(this.getIoInterface().getOutputStream(verilogFile));
                Throwable throwable = null;
                Object var9_11 = null;
                try (VerilogGenerator vlog = new VerilogGenerator(this.libraryProvider.getCurrentLibrary(), verilogPrinter);){
                    if (modelHasClock && (this.frequency > 1 || this.clockGenerator != null) && modelDefinedFrequency < Integer.MAX_VALUE) {
                        vlog.setClockIntegrator(this.createClockIntegrator());
                    }
                    vlog.export(this.circuitProvider.getCurrentCircuit());
                    return vlog.getModel();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            case "vhdl": {
                File vhdlFile = SaveAsHelper.checkSuffix(digFile, "vhdl");
                CodePrinter vhdlPrinter = new CodePrinter(this.getIoInterface().getOutputStream(vhdlFile));
                Throwable throwable = null;
                Object var11_17 = null;
                try (VHDLGenerator vlog = new VHDLGenerator(this.libraryProvider.getCurrentLibrary(), vhdlPrinter);){
                    if (modelHasClock && (this.frequency > 1 || this.clockGenerator != null) && modelDefinedFrequency < Integer.MAX_VALUE) {
                        vlog.setClockIntegrator(this.createClockIntegrator());
                    }
                    vlog.export(this.circuitProvider.getCurrentCircuit());
                    return vlog.getModel();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        throw new IOException(Lang.get("err_hdlNotKnown_N", hdl));
    }

    private ClockIntegratorGeneric createClockIntegrator() {
        return new ClockIntegratorGeneric(this.frequency == 0 ? 0.0 : 1.0E9 / (double)this.frequency).setClockGenerator(this.clockGenerator);
    }

    Thread executeCommand(Command command, Action action, StatusInterface statusInterface) {
        block5: {
            File digFile = this.filenameProvider.getCurrentFilename();
            if (digFile != null) {
                try {
                    if (statusInterface != null) {
                        statusInterface.setStatus(Lang.get("msg_commandStarted_N", String.valueOf(this.name) + " - " + command.getName()));
                    }
                    HDLModel hdlModel = command.needsHDL() ? this.writeHDL(command.getHDL(), digFile) : null;
                    if (action != null) {
                        action.setEnabled(false);
                    }
                    Thread t = new Thread(() -> {
                        block14: {
                            try {
                                try {
                                    this.checkFilesToCreate(digFile, hdlModel, command);
                                    String[] args = command.getArgs();
                                    if (args != null) {
                                        if (command.isFilter()) {
                                            int argCount = command.getArgs().length;
                                            Context context = this.createContext(digFile, hdlModel, command);
                                            int i = 0;
                                            while (i < argCount) {
                                                context.clearOutput();
                                                new Parser(args[i]).parse().execute(context);
                                                args[i] = context.toString();
                                                ++i;
                                            }
                                        }
                                        this.getIoInterface().startProcess(command, digFile.getParentFile(), args);
                                    }
                                }
                                catch (Exception e) {
                                    SwingUtilities.invokeLater(() -> this.getIoInterface().showError(command, e));
                                    if (action != null) {
                                        SwingUtilities.invokeLater(() -> action.setEnabled(true));
                                    }
                                    if (statusInterface != null) {
                                        statusInterface.setStatus(Lang.get("msg_commandEnded_N", String.valueOf(this.name) + " - " + command.getName()));
                                    }
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                if (action != null) {
                                    SwingUtilities.invokeLater(() -> action.setEnabled(true));
                                }
                                if (statusInterface != null) {
                                    statusInterface.setStatus(Lang.get("msg_commandEnded_N", String.valueOf(this.name) + " - " + command.getName()));
                                }
                                throw throwable;
                            }
                            if (action != null) {
                                SwingUtilities.invokeLater(() -> action.setEnabled(true));
                            }
                            if (statusInterface != null) {
                                statusInterface.setStatus(Lang.get("msg_commandEnded_N", String.valueOf(this.name) + " - " + command.getName()));
                            }
                        }
                    });
                    t.setDaemon(true);
                    t.start();
                    return t;
                }
                catch (Exception e) {
                    this.getIoInterface().showError(command, e);
                    if (statusInterface == null) break block5;
                    statusInterface.setStatus(Lang.get("msg_commandEnded_N", String.valueOf(this.name) + " - " + command.getName()));
                }
            }
        }
        return null;
    }

    private void checkFilesToCreate(File fileToExecute, HDLModel hdlModel, Command command) throws HGSEvalException, IOException, ParserException {
        boolean modelHasClock;
        Context context = this.createContext(fileToExecute, hdlModel, command);
        boolean bl = modelHasClock = this.getFrequency() > 0;
        if (this.files != null) {
            ConfigCache configCache = new ConfigCache(this.origin);
            for (FileToCreate f : this.files) {
                boolean skip;
                context.clearOutput();
                String name = f.getName();
                if (name == null) {
                    throw new IOException("no file name given!");
                }
                Parser p = new Parser(name);
                p.parse().execute(context);
                File filename = new File(fileToExecute.getParent(), context.toString());
                boolean bl2 = skip = !modelHasClock && this.clockGenerator != null && this.removeSuffix(filename.getName()).equals(this.clockGenerator);
                if (skip || !f.isOverwrite() && filename.exists()) continue;
                this.createFile(filename, this.resolveFileContent(f, configCache), context);
            }
        }
    }

    private String removeSuffix(String name) {
        int p = name.lastIndexOf(46);
        if (p < 0) {
            return name;
        }
        return name.substring(0, p);
    }

    private void createFile(File filename, FileToCreate f, Context context) throws IOException, HGSEvalException, ParserException {
        LOGGER.info("create file " + filename);
        String content = f.getContent();
        if (f.isFilter()) {
            context.clearOutput();
            Parser p = new Parser(content);
            p.parse().execute(context);
            content = context.toString();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream out = this.getIoInterface().getOutputStream(filename);){
            out.write(content.getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FileToCreate resolveFileContent(FileToCreate f, ConfigCache configCache) throws IOException {
        if (f.hasContent()) {
            return f;
        }
        Configuration c = configCache.getConfig(f.getReferenceFilename());
        return c.getFileById(f.getReferenceId(), configCache);
    }

    FileToCreate getFileById(String referenceId, ConfigCache configCache) throws IOException {
        for (FileToCreate f : this.files) {
            if (!referenceId.equals(f.getId())) continue;
            return this.resolveFileContent(f, configCache);
        }
        throw new IOException("no file with id " + referenceId + " given");
    }

    ArrayList<Command> getCommands() {
        return this.commands;
    }

    private int getFrequency() throws HGSEvalException {
        List<VisualElement> l = this.circuitProvider.getCurrentCircuit().getElements(v -> v.equalsDescription(Clock.DESCRIPTION));
        if (l.isEmpty()) {
            return 0;
        }
        if (l.size() > 1) {
            throw new HGSEvalException(Lang.get("err_moreThanOneClockFound", new Object[0]));
        }
        return l.get(0).getElementAttributes().get(Keys.FREQUENCY);
    }

    public static interface CircuitProvider {
        public Circuit getCurrentCircuit();
    }

    private static final class DefaultIOInterface
    implements IOInterface {
        private DefaultIOInterface() {
        }

        @Override
        public OutputStream getOutputStream(File filename) throws IOException {
            File parentFile = filename.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("could not create folder " + parentFile);
            }
            return new FileOutputStream(filename);
        }

        @Override
        public void startProcess(Command command, File dir, String[] args) throws IOException {
            String consoleOut = new OSExecute(args).setTimeOutSec(command.getTimeout()).setWorkingDir(dir).startAndWait();
            LOGGER.info("process '" + command.getName() + "' says:\n" + consoleOut);
        }

        @Override
        public void showError(Command command, Exception e) {
            new ErrorMessage(Lang.get("msg_errorStartCommand_N", command.getName())).addCause(e).show();
        }
    }

    private final class ExecuteAction
    extends AbstractAction {
        private final Command command;
        private final StatusInterface statusInterface;

        private ExecuteAction(Command command, StatusInterface statusInterface) {
            super(command.getName());
            this.command = command;
            this.statusInterface = statusInterface;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Configuration.this.executeCommand(this.command, this, this.statusInterface);
        }
    }

    public static interface FilenameProvider {
        public File getCurrentFilename();
    }

    public static interface IOInterface {
        public OutputStream getOutputStream(File var1) throws IOException;

        public void startProcess(Command var1, File var2, String[] var3) throws IOException;

        public void showError(Command var1, Exception var2);
    }

    public static interface LibraryProvider {
        public ElementLibrary getCurrentLibrary();
    }

    private final class ModelAccess
    implements HGSMap {
        private final HDLCircuit hdlCircuit;

        private ModelAccess(HDLCircuit hdlCircuit) {
            this.hdlCircuit = hdlCircuit;
        }

        @Override
        public Object hgsMapGet(String key) throws HGSEvalException {
            switch (key) {
                case "ports": {
                    return new PortsArray(this.hdlCircuit.getPorts());
                }
                case "frequency": {
                    return Configuration.this.getFrequency();
                }
            }
            throw new HGSEvalException("field " + key + " not found!");
        }
    }

    private static final class Port
    implements HGSMap {
        private final HDLPort hdlPort;

        private Port(HDLPort hdlPort) {
            this.hdlPort = hdlPort;
        }

        @Override
        public Object hgsMapGet(String key) throws HGSEvalException {
            switch (key) {
                case "dir": {
                    return this.hdlPort.getDirection().name();
                }
                case "name": {
                    return this.hdlPort.getName();
                }
                case "bits": {
                    return this.hdlPort.getBits();
                }
                case "pin": {
                    return this.hdlPort.getPinNumber();
                }
                case "clock": {
                    return this.hdlPort.isClock();
                }
            }
            throw new HGSEvalException("field " + key + " not found!");
        }
    }

    private static final class PortsArray
    implements HGSArray {
        private final ArrayList<HDLPort> ports;

        private PortsArray(ArrayList<HDLPort> ports) {
            this.ports = ports;
        }

        @Override
        public int hgsArraySize() {
            return this.ports.size();
        }

        @Override
        public Object hgsArrayGet(int i) {
            return new Port(this.ports.get(i));
        }
    }
}

