/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.undo;

import de.neemann.digital.undo.Copyable;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.ModifyException;
import java.util.ArrayList;

public final class Modifications<A extends Copyable<A>>
implements Modification<A> {
    private final ArrayList<Modification<A>> modifications;
    private final String name;

    private Modifications(ArrayList<Modification<A>> modifications, String name) {
        this.modifications = modifications;
        this.name = name;
    }

    @Override
    public void modify(A a) throws ModifyException {
        for (Modification<A> m : this.modifications) {
            m.modify(a);
        }
    }

    public ArrayList<Modification<A>> getModifications() {
        return this.modifications;
    }

    public String toString() {
        return this.name;
    }

    /* synthetic */ Modifications(ArrayList arrayList, String string, Modifications modifications) {
        this(arrayList, string);
    }

    public static final class Builder<A extends Copyable<A>> {
        private final ArrayList<Modification<A>> list;
        private final String name;

        public Builder(String name) {
            this.name = name;
            this.list = new ArrayList();
        }

        public Builder<A> add(Modification<A> m) {
            if (m != null) {
                this.list.add(m);
            }
            return this;
        }

        public Modification<A> build() {
            if (this.list.isEmpty()) {
                return null;
            }
            if (this.list.size() == 1) {
                return this.list.get(0);
            }
            return new Modifications(this.list, this.name, null);
        }
    }
}

