/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.undo;

import de.neemann.digital.undo.ChangedListener;
import de.neemann.digital.undo.Copyable;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.ModifyException;
import java.util.ArrayList;

public class UndoManager<A extends Copyable<A>> {
    private ArrayList<ChangedListener> listeners = new ArrayList();
    private ArrayList<Modification<A>> modifications;
    private int modificationCounter;
    private int savedCounter;
    private A initial;
    private A actual;

    public UndoManager(A initial) {
        this.setInitial(initial);
    }

    public void setInitial(A initial) {
        this.initial = initial;
        this.actual = null;
        this.modifications = new ArrayList();
        this.modificationCounter = 0;
        this.savedCounter = 0;
        this.fireChangedEvent();
    }

    public void apply(Modification<A> modification) throws ModifyException {
        try {
            if (this.actual == null) {
                this.actual = this.initial.createDeepCopy();
            }
            modification.modify(this.actual);
            while (this.modificationCounter < this.modifications.size()) {
                this.modifications.remove(this.modifications.size() - 1);
            }
            this.modifications.add(modification);
            this.modificationCounter = this.modifications.size();
            this.fireChangedEvent();
        }
        catch (ModifyException e) {
            throw this.createTrace(e, null);
        }
    }

    private void fireChangedEvent() {
        for (ChangedListener l : this.listeners) {
            l.hasChanged();
        }
    }

    public void redo() throws ModifyException {
        if (this.redoAvailable()) {
            try {
                this.modifications.get(this.modificationCounter).modify(this.actual);
                ++this.modificationCounter;
                this.fireChangedEvent();
            }
            catch (ModifyException e) {
                throw this.createTrace(e, null);
            }
        }
    }

    public boolean redoAvailable() {
        return this.modificationCounter < this.modifications.size();
    }

    public void undo() throws ModifyException {
        if (this.undoAvailable()) {
            Modification lastWorkingModification = null;
            try {
                Object newActual = this.initial.createDeepCopy();
                int i = 0;
                while (i < this.modificationCounter - 1) {
                    Modification m = this.modifications.get(i);
                    m.modify(newActual);
                    lastWorkingModification = m;
                    ++i;
                }
                --this.modificationCounter;
                this.actual = newActual;
                this.fireChangedEvent();
            }
            catch (ModifyException e) {
                throw this.createTrace(e, lastWorkingModification);
            }
        }
    }

    private ModifyException createTrace(ModifyException cause, Modification<A> lastWorkingModification) {
        StringBuilder sb = new StringBuilder("Exception during event processing");
        int i = 0;
        while (i < this.modifications.size()) {
            if (i == this.modificationCounter) {
                sb.append("\n>");
            } else {
                sb.append("\n ");
            }
            Modification<A> m = this.modifications.get(i);
            sb.append(m.toString());
            if (m == lastWorkingModification) {
                sb.append("\n -> exception in the following modification!");
            }
            ++i;
        }
        if (this.modificationCounter == this.modifications.size()) {
            sb.append("\n>");
        }
        return new ModifyException(sb.toString(), cause);
    }

    public Modification<A> getUndoModification() {
        if (this.undoAvailable()) {
            return this.modifications.get(this.modificationCounter - 1);
        }
        return null;
    }

    public Modification<A> getRedoModification() {
        if (this.redoAvailable()) {
            return this.modifications.get(this.modificationCounter);
        }
        return null;
    }

    public boolean undoAvailable() {
        return this.modificationCounter > 0;
    }

    public void saved() {
        this.savedCounter = this.modificationCounter;
    }

    public boolean isModified() {
        return this.savedCounter != this.modificationCounter;
    }

    public A getActual() {
        if (this.actual == null) {
            return this.initial;
        }
        return this.actual;
    }

    public ChangedListener addListener(ChangedListener listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void removedListener(ChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void applyWithoutHistory(Modification<A> modification) throws ModifyException {
        if (this.actual != null) {
            modification.modify(this.actual);
        }
        modification.modify(this.initial);
    }
}

