/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.digital.core.ExceptionWithOrigin;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.IconCreator;
import de.neemann.gui.LineBreaker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessage
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorMessage.class);
    private final StringBuilder message;
    private Component component;

    public ErrorMessage() {
        this("");
    }

    public ErrorMessage(String message) {
        this.message = new StringBuilder(message);
        LOGGER.info("error message: " + message);
    }

    public ErrorMessage addCause(Throwable e) {
        LOGGER.info("throwable error cause", e);
        if (this.message.length() > 0) {
            this.message.append('\n');
        }
        this.addExceptionMessage(e);
        String orig = ExceptionWithOrigin.getOriginOf(e);
        if (orig != null) {
            if (this.message.length() > 0) {
                this.message.append('\n');
            }
            this.message.append(Lang.get("msg_errInFile_N", orig));
        }
        return this;
    }

    private void addExceptionMessage(Throwable e) {
        boolean first = true;
        while (e != null) {
            String m = e.getMessage();
            if (m != null && m.length() > 0) {
                if (first) {
                    first = false;
                } else {
                    this.message.append("\n").append(Lang.get("msg_errCausedBy", new Object[0])).append(": ");
                }
                this.message.append(m);
            }
            e = e.getCause();
        }
    }

    public void show() {
        this.show(null);
    }

    public void show(Component parent) {
        ErrorDialog dialog = new ErrorDialog(parent, Lang.get("error", new Object[0]), this.message.toString());
        dialog.setVisible(true);
        dialog.dispose();
    }

    public ErrorMessage setComponent(Component component) {
        this.component = component;
        return this;
    }

    @Override
    public void run() {
        this.show(this.component);
    }

    public static Window getParentWindow(Component parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Window) {
            return (Window)parent;
        }
        return SwingUtilities.getWindowAncestor(parent);
    }

    public static final class ErrorDialog
    extends JDialog {
        private static final Icon ICON = IconCreator.create("dialog-error.png");
        private String errorMessage;

        private ErrorDialog(Component parent, String title, String message) {
            super(ErrorMessage.getParentWindow(parent), title, Dialog.ModalityType.APPLICATION_MODAL);
            int border;
            JComponent ta;
            this.setDefaultCloseOperation(2);
            this.errorMessage = message;
            LineBreaker lineBreaker = new LineBreaker(80).toHTML().preserveContainedLineBreaks();
            message = lineBreaker.breakLines(message);
            int lines = lineBreaker.getLineCount();
            if (lines <= 15) {
                ta = new JLabel(message);
                border = ta.getFont().getSize();
                ta.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
                this.getContentPane().add(ta);
            } else {
                ta = new JEditorPane("text/html", message);
                ta.setBackground(this.getBackground());
                border = ta.getFont().getSize();
                JScrollPane scrollPane = new JScrollPane(ta);
                this.getContentPane().add(scrollPane);
                scrollPane.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
            }
            JPanel buttons = new JPanel(new FlowLayout(2));
            JButton button = new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.dispose();
                }
            });
            buttons.add(button);
            this.getContentPane().add((Component)buttons, "South");
            JLabel l = new JLabel(ICON);
            l.setVerticalAlignment(1);
            l.setBorder(BorderFactory.createEmptyBorder(border, border, border, 0));
            this.getContentPane().add((Component)l, "West");
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setAlwaysOnTop(true);
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

