/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui.language;

import com.thoughtworks.xstream.XStream;
import de.neemann.digital.XStreamValid;
import de.neemann.gui.language.Language;
import de.neemann.gui.language.Resources;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Bundle {
    private final Map<String, String> languages;
    private final String name;
    private final ArrayList<Language> list;

    private static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("languages", Map.class);
        xStream.registerConverter(new Resources.MapEntryConverter("string"));
        return xStream;
    }

    public Bundle(String name) {
        this.name = name;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(name) + ".xml");
        XStreamValid xStream = new XStreamValid();
        xStream.alias("languages", MyLang.class);
        xStream.addImplicitCollection(MyLang.class, "lang");
        xStream.alias("lang", MyLangEntry.class);
        xStream.aliasAttribute(MyLangEntry.class, "name", "name");
        xStream.aliasAttribute(MyLangEntry.class, "filename", "file");
        xStream.aliasAttribute(MyLangEntry.class, "displayName", "display");
        MyLang l = (MyLang)xStream.fromXML(in);
        this.languages = new HashMap<String, String>();
        this.list = new ArrayList();
        for (MyLangEntry e : l.lang) {
            this.languages.put(e.name, e.displayName);
            this.list.add(new Language(e.name, e.displayName, e.filename));
        }
    }

    public Resources getResources(String lang) {
        if (!this.languages.containsKey(lang)) {
            return null;
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(this.name) + "_" + lang + ".xml");
        if (in == null) {
            return null;
        }
        return new Resources(in);
    }

    public List<Language> getSupportedLanguages() {
        return this.list;
    }

    private static class MyLang {
        private ArrayList<MyLangEntry> lang;

        private MyLang() {
        }
    }

    private static class MyLangEntry {
        private String name;
        private String displayName;
        private String filename;

        private MyLangEntry() {
        }
    }
}

