/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui.language;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.XStreamValid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Resources {
    private final Map<String, String> resourceMap;

    private static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("resources", Map.class);
        xStream.registerConverter(new MapEntryConverter("string"));
        return xStream;
    }

    Resources() {
        this(new HashMap<String, String>());
    }

    private Resources(Map<String, String> map) {
        this.resourceMap = map;
    }

    public Resources(InputStream in) {
        this(Resources.loadMap(in));
    }

    public Resources(File file) throws FileNotFoundException {
        this(Resources.loadMap(new FileInputStream(file)));
    }

    private static Map<String, String> loadMap(InputStream in) {
        XStream xStream = Resources.getxStream();
        return (Map)xStream.fromXML(in);
    }

    void save(OutputStream out) throws IOException {
        XStream xStream = Resources.getxStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            w.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(this.resourceMap, new PrettyPrintWriter(w));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void put(String key, String value) {
        this.resourceMap.put(key, value);
    }

    public String get(String key) {
        return this.resourceMap.get(key);
    }

    public Set<String> getKeys() {
        return this.resourceMap.keySet();
    }

    public static class MapEntryConverter
    implements Converter {
        private String keyName;

        public MapEntryConverter(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public boolean canConvert(Class clazz) {
            return Map.class.isAssignableFrom(clazz);
        }

        @Override
        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = (Map)value;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                writer.startNode(this.keyName);
                writer.addAttribute("name", entry.getKey().toString());
                writer.setValue(entry.getValue().toString());
                writer.endNode();
            }
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String key = reader.getAttribute("name");
                String value = reader.getValue().trim();
                map.put(key, value);
                reader.moveUp();
            }
            return map;
        }
    }
}

