/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp.cli;

import com.jsuereth.pgp.PublicKey;
import com.jsuereth.pgp.PublicKey$;
import com.jsuereth.pgp.PublicKeyRing;
import com.jsuereth.pgp.Signature;
import java.io.File;
import java.text.SimpleDateFormat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcC$sp;

public final class Display$ {
    public static Display$ MODULE$;

    static {
        new Display$();
    }

    public String printFileHeader(File f) {
        String path = f.getAbsolutePath();
        String line = ((Stream)package$.MODULE$.Stream().continually((JFunction0$mcC$sp & Serializable)() -> '-').take(path.length())).mkString("");
        return path + "\n" + line + "\n";
    }

    public String printKey(PublicKey k) {
        String hexkey = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("%x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(k.keyID())})))).takeRight(8);
        String strength = k.algorithmName() + "@" + ((Object)BoxesRunTime.boxToInteger(k.bitStrength())).toString();
        String head = PublicKey$.MODULE$.unwrap(k).isMasterKey() ? "pub" : "sub";
        String date = new SimpleDateFormat("yyyy-MM-dd").format(PublicKey$.MODULE$.unwrap(k).getCreationTime());
        String userStrings = k.userIDs().isEmpty() ? "" : ((TraversableOnce)k.userIDs().map((Function1<String, String> & java.io.Serializable & Serializable)x$1 -> "uid\t                \t" + x$1, Traversable$.MODULE$.canBuildFrom())).mkString("", "\n", "\n");
        return head + "\t" + strength + "/" + hexkey + "\t" + date + "\n" + userStrings;
    }

    public String printSignature(Signature s) {
        String hexKey = (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("%x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(s.keyID())})))).takeRight(8);
        String notationsString = s.notations().isEmpty() ? "" : ((TraversableOnce)s.notations().map((Function1<Tuple2, String> & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = "note\t\t\t\t" + l + "=" + r;
            return string;
        }, Traversable$.MODULE$.canBuildFrom())).mkString("\n", "\n", "");
        String header = "sig";
        String user = (String)s.signerUserID().getOrElse((Function0<String> & java.io.Serializable & Serializable)() -> "");
        return new StringOps(Predef$.MODULE$.augmentString("%s\t%s@%s\t%s%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{header, hexKey, s.signatureTypeString(), user, notationsString}));
    }

    public String printSignatures(PublicKey k) {
        return ((TraversableOnce)k.signatures().map((Function1<Signature, String> & java.io.Serializable & Serializable)s -> MODULE$.printSignature((Signature)s), Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String printKeyWithSignatures(PublicKey r) {
        return this.printKey(r) + this.printSignatures(r) + "\n";
    }

    public String printRingWithSignatures(PublicKeyRing r2) {
        return ((TraversableOnce)r2.publicKeys().map((Function1<PublicKey, String> & java.io.Serializable & Serializable)r -> MODULE$.printKeyWithSignatures((PublicKey)r), Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String printRing(PublicKeyRing r) {
        return ((TraversableOnce)r.publicKeys().map((Function1<PublicKey, String> & java.io.Serializable & Serializable)k -> MODULE$.printKey((PublicKey)k), Traversable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private Display$() {
        MODULE$ = this;
    }
}

