/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.seunjeon.elasticsearch;

import java.util.Collections;
import java.util.List;
import org.bitbucket.eunjeon.seunjeon.elasticsearch.TokenizerHelper;

public class TokenizerOptions {
    public static final boolean DECOMPOUND = true;
    public static final boolean DEINFLECT = true;
    public static final boolean INDEX_EOJEOL = true;
    public static final List<String> INDEX_POSES = TokenizerHelper.INDEX_POSES_JAVA();
    public static final boolean POS_TAGGING = true;
    public static final int MAX_UNK_LENGTH = 8;
    private String userDictPath = null;
    private List<String> userWords = Collections.emptyList();
    private boolean deCompound = true;
    private boolean deInflect = true;
    private boolean indexEojeol = true;
    private List<String> indexPoses = INDEX_POSES;
    private String name = null;
    private boolean posTagging = true;
    private int maxUnkLength = 8;

    public static TokenizerOptions create(String string) {
        return new TokenizerOptions(string);
    }

    private TokenizerOptions(String string) {
        this.name = string;
    }

    public TokenizerOptions setPosTagging(boolean bl) {
        this.posTagging = bl;
        return this;
    }

    public TokenizerOptions setMaxUnkLength(int n) {
        this.maxUnkLength = n;
        return this;
    }

    public TokenizerOptions setUserDictPath(String string) {
        this.userDictPath = string;
        return this;
    }

    public TokenizerOptions setUserWords(List<String> list) {
        this.userWords = list;
        return this;
    }

    public TokenizerOptions setDeCompound(boolean bl) {
        this.deCompound = bl;
        return this;
    }

    public TokenizerOptions setDeInflect(boolean bl) {
        this.deInflect = bl;
        return this;
    }

    public TokenizerOptions setIndexEojeol(boolean bl) {
        this.indexEojeol = bl;
        return this;
    }

    public TokenizerOptions setIndexPoses(List<String> list) {
        this.indexPoses = list;
        return this;
    }

    public String getUserDictPath() {
        return this.userDictPath;
    }

    public List<String> getUserWords() {
        return this.userWords;
    }

    public boolean getDeCompound() {
        return this.deCompound;
    }

    public boolean getDeInflect() {
        return this.deInflect;
    }

    public boolean getIndexEojeol() {
        return this.indexEojeol;
    }

    public List<String> getIndexPoses() {
        return this.indexPoses;
    }

    public boolean getPosTagging() {
        return this.posTagging;
    }

    public int getMaxUnkLength() {
        return this.maxUnkLength;
    }

    public String getName() {
        return this.name;
    }
}

