/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class KeyGen$ {
    public static KeyGen$ MODULE$;

    static {
        new KeyGen$();
    }

    public PGPKeyPair makeRsaKeyPair(int bitStrength) {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(bitStrength);
        KeyPair rsa = generator.generateKeyPair();
        return new JcaPGPKeyPair(1, rsa, new Date());
    }

    public int makeRsaKeyPair$default$1() {
        return 2048;
    }

    public PGPKeyPair makeDsaKeyPair(int bitStrength) {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("DSA", "BC");
        generator.initialize(bitStrength);
        KeyPair dsa = generator.generateKeyPair();
        return new JcaPGPKeyPair(17, dsa, new Date());
    }

    public int makeDsaKeyPair$default$1() {
        return 1024;
    }

    public PGPKeyPair makeElGamalKeyPair(Option<ElGamalParameterSpec> params, boolean encryptOnly) {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("ELGAMAL", "BC");
        params.foreach((Function1<AlgorithmParameterSpec, Object> & Serializable & scala.Serializable)x$1 -> {
            generator.initialize(x$1);
            return BoxedUnit.UNIT;
        });
        KeyPair elg = generator.generateKeyPair();
        return encryptOnly ? new JcaPGPKeyPair(16, elg, new Date()) : new JcaPGPKeyPair(20, elg, new Date());
    }

    public Option<ElGamalParameterSpec> makeElGamalKeyPair$default$1() {
        return None$.MODULE$;
    }

    public boolean makeElGamalKeyPair$default$2() {
        return false;
    }

    public PGPKeyRingGenerator makePgpKeyRingGenerator(String identity, char[] passPhrase, PGPKeyPair keyPair, Seq<PGPKeyPair> subKeyPairs) {
        Provider provider = Security.getProvider("BC");
        PBESecretKeyEncryptor keyEncryptor = new JcePBESecretKeyEncryptorBuilder(3).setProvider(provider).setSecureRandom(new SecureRandom()).build(passPhrase);
        JcaPGPContentSignerBuilder keySignerBuilder = new JcaPGPContentSignerBuilder(keyPair.getPublicKey().getAlgorithm(), 2);
        PGPDigestCalculator digestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        int certificationLevel = 19;
        PGPKeyRingGenerator keyRingGen = new PGPKeyRingGenerator(certificationLevel, keyPair, identity, digestCalculator, null, null, keySignerBuilder, keyEncryptor);
        subKeyPairs.foreach((Function1<PGPKeyPair, Object> & Serializable & scala.Serializable)x$1 -> {
            keyRingGen.addSubKey(x$1);
            return BoxedUnit.UNIT;
        });
        return keyRingGen;
    }

    public PGPKeyRingGenerator makeDsaKeyRingGenerator(String identity, char[] passPhrase, int bitStrength) {
        PGPKeyPair[] pGPKeyPairArray = new PGPKeyPair[1];
        boolean x$1 = true;
        Option<ElGamalParameterSpec> x$2 = this.makeElGamalKeyPair$default$1();
        pGPKeyPairArray[0] = this.makeElGamalKeyPair(x$2, x$1);
        return this.makePgpKeyRingGenerator(identity, passPhrase, this.makeDsaKeyPair(bitStrength), Predef$.MODULE$.wrapRefArray((Object[])pGPKeyPairArray));
    }

    public int makeDsaKeyRingGenerator$default$3() {
        return 1024;
    }

    public PGPKeyRingGenerator makeRsaKeyRingGenerator(String identity, char[] passPhrase) {
        return this.makePgpKeyRingGenerator(identity, passPhrase, this.makeRsaKeyPair(this.makeRsaKeyPair$default$1()), Predef$.MODULE$.wrapRefArray((Object[])new PGPKeyPair[0]));
    }

    public PGPKeyRingGenerator makeElGamalKeyRingGenerator(String identity, char[] passPhrase) {
        return this.makePgpKeyRingGenerator(identity, passPhrase, this.makeElGamalKeyPair(this.makeElGamalKeyPair$default$1(), this.makeElGamalKeyPair$default$2()), Predef$.MODULE$.wrapRefArray((Object[])new PGPKeyPair[0]));
    }

    private KeyGen$() {
        MODULE$ = this;
    }
}

