/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.KeyGen$;
import com.jsuereth.pgp.PublicKey;
import com.jsuereth.pgp.PublicKeyRing;
import com.jsuereth.pgp.PublicKeyRing$;
import com.jsuereth.pgp.PublicKeyRingCollection;
import com.jsuereth.pgp.PublicKeyRingCollection$;
import com.jsuereth.pgp.SecretKeyRing;
import com.jsuereth.pgp.SecretKeyRing$;
import com.jsuereth.pgp.SecretKeyRingCollection;
import com.jsuereth.pgp.SecretKeyRingCollection$;
import java.io.File;
import java.io.Serializable;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.sys.package$;

public final class PGP$ {
    public static PGP$ MODULE$;

    static {
        new PGP$();
    }

    public void init() {
    }

    public PublicKeyRing loadPublicKeyRing(File file) {
        return (PublicKeyRing)PublicKeyRing$.MODULE$.loadFromFile(file);
    }

    public SecretKeyRing loadSecretKeyRing(File file) {
        return (SecretKeyRing)SecretKeyRing$.MODULE$.loadFromFile(file);
    }

    public PublicKeyRingCollection loadPublicKeyRingCollection(File file) {
        return (PublicKeyRingCollection)PublicKeyRingCollection$.MODULE$.loadFromFile(file);
    }

    public SecretKeyRingCollection loadSecretKeyRingCollection(File file) {
        return (SecretKeyRingCollection)SecretKeyRingCollection$.MODULE$.loadFromFile(file);
    }

    public Tuple2<PublicKeyRing, SecretKeyRing> makeNewKeyRings(String identity, char[] passPhrase) {
        PGPKeyRingGenerator gen = KeyGen$.MODULE$.makeRsaKeyRingGenerator(identity, passPhrase);
        return new Tuple2<PublicKeyRing, SecretKeyRing>(PublicKeyRing$.MODULE$.apply(gen.generatePublicKeyRing()), SecretKeyRing$.MODULE$.apply(gen.generateSecretKeyRing()));
    }

    public void makeKeys(String identity, char[] passPhrase, File publicKey, File secretKey) {
        Tuple2<PublicKeyRing, SecretKeyRing> tuple2 = this.makeNewKeyRings(identity, passPhrase);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PublicKeyRing pub = tuple2._1();
        SecretKeyRing sec = tuple2._2();
        Tuple2<PublicKeyRing, SecretKeyRing> tuple22 = new Tuple2<PublicKeyRing, SecretKeyRing>(pub, sec);
        Tuple2<PublicKeyRing, SecretKeyRing> tuple23 = tuple22;
        PublicKeyRing pub2 = tuple23._1();
        SecretKeyRing sec2 = tuple23._2();
        pub2.saveToFile(publicKey);
        sec2.saveToFile(secretKey);
    }

    public boolean isPublicKeyMatching(String value, PublicKey k) {
        boolean hasKeyId = RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(k.keyID())).contains(value);
        boolean hasUserId = k.userIDs().exists((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.contains(value)));
        return hasKeyId || hasUserId;
    }

    private PGP$() {
        MODULE$ = this;
        try {
            BouncyCastleProvider newProvider = new BouncyCastleProvider();
            if (Security.getProvider(newProvider.getName()) != null) {
                Security.removeProvider(newProvider.getName());
            }
            Security.addProvider(newProvider);
        }
        catch (Throwable t) {
            throw package$.MODULE$.error("Could not initialize bouncy castle encryption.");
        }
    }
}

