/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.Algorithms$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00117h_JLG\u000f[7DQ\u0016\u001c7.\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\ngNd7m\u001c8gS\u001eT!a\u0002\u0005\u0002\u0011QL\b/Z:bM\u0016T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\u000b\u000e\u00039Q!a\u0004\t\u0002\t\r,'\u000f\u001e\u0006\u0003#I\t\u0001b]3dkJLG/\u001f\u0006\u0002'\u0005!!.\u0019<b\u0013\t)bBA\nQ\u0017&C6)\u001a:u!\u0006$\bn\u00115fG.,'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003!i7\u000eT8hO\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005uQ\"!\u0004'pO\u001e,'OR1di>\u0014\u0018\u0010\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u0003Q\u0019\u0018n\u001a8biV\u0014XmQ8ogR\u0014\u0018-\u001b8ugV\t\u0011\u0005E\u0002#W9r!aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019R\u0011A\u0002\u001fs_>$hHC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u00121aU3u\u0015\tQs\u0005\u0005\u00020a5\t!!\u0003\u00022\u0005\t\u0019\u0012\t\\4pe&$\b.\\\"p]N$(/Y5oi\"A1\u0007\u0001B\u0001B\u0003%\u0011%A\u000btS\u001et\u0017\r^;sK\u000e{gn\u001d;sC&tGo\u001d\u0011\t\u0011U\u0002!Q1A\u0005\u0002\u0001\nab[3z\u0007>t7\u000f\u001e:bS:$8\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u0003\"\u0003=YW-_\"p]N$(/Y5oiN\u0004\u0003\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\u0018\u0001\u0011\u00159\u0002\b1\u0001\u0019\u0011\u0015y\u0002\b1\u0001\"\u0011\u0015)\u0004\b1\u0001\"\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000ba\u0001\\8hO\u0016\u0014X#\u0001\"\u0011\u0005e\u0019\u0015B\u0001#\u001b\u00051qu\u000eR3qg2{wmZ3s\u0011\u00191\u0005\u0001)A\u0005\u0005\u00069An\\4hKJ\u0004\u0003b\u0002%\u0001\u0005\u0004%I!S\u0001\u0018g&<g.\u0019;ve\u0016\u001cuN\\:ue\u0006Lg\u000e^:NCB,\u0012A\u0013\t\u0005E-ke&\u0003\u0002M[\t\u0019Q*\u00199\u0011\u0005\tr\u0015BA(.\u0005\u0019\u0019FO]5oO\"1\u0011\u000b\u0001Q\u0001\n)\u000b\u0001d]5h]\u0006$XO]3D_:\u001cHO]1j]R\u001cX*\u00199!\u0011\u001d\u0019\u0006A1A\u0005\n%\u000b\u0011c[3z\u0007>t7\u000f\u001e:bS:$8/T1q\u0011\u0019)\u0006\u0001)A\u0005\u0015\u0006\u00112.Z=D_:\u001cHO]1j]R\u001cX*\u00199!\u0011\u00159\u0006\u0001\"\u0001Y\u0003iI7OR8so\u0006\u0014Hm\u00115fG.LgnZ*vaB|'\u000f^3e)\u0005I\u0006C\u0001.\\\u001b\u00059\u0013B\u0001/(\u0005\u001d\u0011un\u001c7fC:DQA\u0018\u0001\u0005\u0002}\u000bacZ3u'V\u0004\bo\u001c:uK\u0012,\u0005\u0010^3og&|gn\u001d\u000b\u0002AB\u0019\u0011mY'\u000e\u0003\tT!a\u0007\n\n\u00051\u0012\u0007\"B3\u0001\t\u00031\u0017\u0001B5oSR$\"a\u001a6\u0011\u0005iC\u0017BA5(\u0005\u0011)f.\u001b;\t\u000b-$\u0007\u0019A-\u0002\u000f\u0019|'o^1sI\")Q\u000e\u0001C\u0001]\u00069b-\u001b8e'&<g.\u0019;ve\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e\u000b\u0003_J\u00042A\u00179/\u0013\t\txE\u0001\u0004PaRLwN\u001c\u0005\u0006g2\u0004\r!T\u0001\nC2<wN]5uQ6DQ!\u001e\u0001\u0005\u0002Y\f\u0011CZ5oI.+\u0017pQ8ogR\u0014\u0018-\u001b8u)\tyw\u000fC\u0003ti\u0002\u0007Q\nC\u0003z\u0001\u0011\u0005!0\u0001\rdQ\u0016\u001c7nU5h]\u0006$XO]3BY\u001e|'/\u001b;i[N$\"aZ>\t\u000bqD\b\u0019A?\u0002\u0011a,\u0004'O\"feR\u0004\"!\u0004@\n\u0005}t!a\u0004-6ae\u001aUM\u001d;jM&\u001c\u0017\r^3\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005\u00112\r[3dW.+\u00170\u00117h_JLG\u000f[7t)\r9\u0017q\u0001\u0005\u0007y\u0006\u0005\u0001\u0019A?\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005)1\r[3dWR)q-a\u0004\u0002\u0018!9q\"!\u0003A\u0002\u0005E\u0001cA\u0007\u0002\u0014%\u0019\u0011Q\u0003\b\u0003\u0017\r+'\u000f^5gS\u000e\fG/\u001a\u0005\t\u00033\tI\u00011\u0001\u0002\u001c\u0005\u0011RO\u001c:fg>dg/\u001a3De&$X\t\u001f;t!\u0011\t\u0017QD'\n\u0007\u0005}!M\u0001\u0006D_2dWm\u0019;j_:Dq!a\t\u0001\t\u0003\t)#\u0001\u000ftk:\u001cX\r^*I\u0003F\u001a\u0016n\u001a8biV\u0014X-\u00117h_JLG\u000f[7\u0015\u0007\u001d\f9\u0003\u0003\u0004}\u0003C\u0001\r! \u0005\b\u0003W\u0001A\u0011AA\u0017\u00031IgNZ8P]N+hn]3u)\u00159\u0017qFA\u0019\u0011\u0019a\u0018\u0011\u0006a\u0001{\"A\u00111GA\u0015\u0001\u0004\t)$\u0001\bfqBL'/\u0019;j_:$\u0015\r^3\u0011\u0007\u0005\f9$C\u0002\u0002:\t\u0014\u0011c\u0012:fO>\u0014\u0018.\u00198DC2,g\u000eZ1s\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\tAb^1s]>s7+\u001e8tKR$RaZA!\u0003\u0007Ba\u0001`A\u001e\u0001\u0004i\b\u0002CA\u001a\u0003w\u0001\r!!\u000e\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u0005iq-\u001a;D_6lwN\u001c(b[\u0016$2!TA&\u0011\u0019y\u0011Q\ta\u0001{\u0002")
public class AlgorithmChecker
extends PKIXCertPathChecker {
    private final scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints;
    private final scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints;
    private final NoDepsLogger logger;
    private final Map<String, AlgorithmConstraint> signatureConstraintsMap;
    private final Map<String, AlgorithmConstraint> keyConstraintsMap;

    public scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints() {
        return this.signatureConstraints;
    }

    public scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints() {
        return this.keyConstraints;
    }

    private NoDepsLogger logger() {
        return this.logger;
    }

    private Map<String, AlgorithmConstraint> signatureConstraintsMap() {
        return this.signatureConstraintsMap;
    }

    private Map<String, AlgorithmConstraint> keyConstraintsMap() {
        return this.keyConstraintsMap;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void init(boolean forward) {
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"init: forward = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(forward)})));
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
    }

    public Option<AlgorithmConstraint> findSignatureConstraint(String algorithm) {
        return this.signatureConstraintsMap().get(algorithm);
    }

    public Option<AlgorithmConstraint> findKeyConstraint(String algorithm) {
        return this.keyConstraintsMap().get(algorithm);
    }

    public void checkSignatureAlgorithms(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: sigAlgName = ", ", sigAlgName = ", ", sigAlgorithms = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{sigAlgName, sigAlgName, sigAlgorithms})));
        sigAlgorithms.foreach((Function1<String, Object> & Serializable & scala.Serializable)a -> {
            AlgorithmChecker.$anonfun$checkSignatureAlgorithms$1(this, x509Cert, a);
            return BoxedUnit.UNIT;
        });
    }

    public void checkKeyAlgorithms(X509Certificate x509Cert) {
        PublicKey key = x509Cert.getPublicKey();
        String keyAlgorithmName = key.getAlgorithm();
        int keySize = BoxesRunTime.unboxToInt(Algorithms$.MODULE$.keySize(key).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No keySize found for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
        }));
        scala.collection.immutable.Set<String> keyAlgorithms = Algorithms$.MODULE$.decomposes(keyAlgorithmName);
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: keyAlgorithmName = ", ", keySize = ", ", keyAlgorithms = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{keyAlgorithmName, BoxesRunTime.boxToInteger(keySize), keyAlgorithms})));
        keyAlgorithms.foreach((Function1<String, Object> & Serializable & scala.Serializable)a -> {
            AlgorithmChecker.$anonfun$checkKeyAlgorithms$2(this, x509Cert, keySize, a);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) {
        X509Certificate x509Certificate;
        Certificate certificate = cert;
        if (certificate instanceof X509Certificate) {
            x509Certificate = (X509Certificate)certificate;
            String commonName = this.getCommonName(x509Certificate);
            Collection<List<?>> subAltNames = x509Certificate.getSubjectAlternativeNames();
            String certName = x509Certificate.getSubjectX500Principal().getName();
            if (this.logger().isDebugEnabled()) {
                long expirationDate = x509Certificate.getNotAfter().getTime();
                SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"check: checking certificate commonName = ", ", subjAltName = ", ", certName = ", ", expirationDate = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{commonName, subAltNames, certName, isoFormat.format(BoxesRunTime.boxToLong(expirationDate))})));
            }
        } else {
            throw new UnsupportedOperationException("check only works with x509 certificates!");
        }
        this.sunsetSHA1SignatureAlgorithm(x509Certificate);
        this.checkSignatureAlgorithms(x509Certificate);
        this.checkKeyAlgorithms(x509Certificate);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void sunsetSHA1SignatureAlgorithm(X509Certificate x509Cert) {
        block2: {
            GregorianCalendar january2017;
            String sigAlgName = x509Cert.getSigAlgName();
            scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
            if (!sigAlgorithms.contains("SHA1") && !sigAlgorithms.contains("SHA-1")) break block2;
            GregorianCalendar june2016 = new GregorianCalendar(2016, 6, 1, 0, 0, 0);
            GregorianCalendar december2016 = new GregorianCalendar(2016, 12, 31, 0, 0, 0);
            GregorianCalendar expirationDate = new GregorianCalendar();
            expirationDate.setTime(new Date(x509Cert.getNotAfter().getTime()));
            if (expirationDate.after(june2016) && expirationDate.before(december2016)) {
                this.infoOnSunset(x509Cert, expirationDate);
            }
            if ((january2017 = new GregorianCalendar(2017, 1, 1, 0, 0, 0)).equals(expirationDate) || january2017.before(expirationDate)) {
                this.warnOnSunset(x509Cert, expirationDate);
            }
        }
    }

    public void infoOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.logger().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": this certificate expires soon, but SHA-1 is being sunsetted."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, expirationDate})));
    }

    public void warnOnSunset(X509Certificate x509Cert, GregorianCalendar expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": SHA-1 cannot be considered secure and this certificate should be replaced."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, expirationDate})));
    }

    public String getCommonName(X509Certificate cert) {
        String string;
        try {
            LdapName ldapName = new LdapName(cert.getSubjectX500Principal().getName());
            ObjectRef<Object> cn = ObjectRef.create(null);
            ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ldapName.getRdns()).asScala()).withFilter((Function1<Rdn, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(AlgorithmChecker.$anonfun$getCommonName$1(check$ifrefutable$1))).foreach((Function1<Rdn, Object> & Serializable & scala.Serializable)rdn -> {
                AlgorithmChecker.$anonfun$getCommonName$2(cn, rdn);
                return BoxedUnit.UNIT;
            });
            string = (String)cn.elem;
        }
        catch (InvalidNameException e) {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$checkSignatureAlgorithms$2(AlgorithmChecker $this, X509Certificate x509Cert$1, String a$1, AlgorithmConstraint constraint) {
        if (constraint.matches(a$1)) {
            $this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: x509Cert = ", " failed on constraint ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{x509Cert$1, constraint})));
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: ", " matched constraint ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{a$1, constraint}));
            throw new CertPathValidatorException(msg);
        }
    }

    public static final /* synthetic */ void $anonfun$checkSignatureAlgorithms$1(AlgorithmChecker $this, X509Certificate x509Cert$1, String a) {
        $this.findSignatureConstraint(a).foreach((Function1<AlgorithmConstraint, Object> & Serializable & scala.Serializable)constraint -> {
            AlgorithmChecker.$anonfun$checkSignatureAlgorithms$2($this, x509Cert$1, a, constraint);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkKeyAlgorithms$3(AlgorithmChecker $this, X509Certificate x509Cert$2, int keySize$1, String a$2, AlgorithmConstraint constraint) {
        if (constraint.matches(a$2, keySize$1)) {
            String certName = x509Cert$2.getSubjectX500Principal().getName();
            $this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, constraint, a$2, BoxesRunTime.boxToInteger(keySize$1)})));
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certName, constraint, a$2, BoxesRunTime.boxToInteger(keySize$1)}));
            throw new CertPathValidatorException(msg);
        }
    }

    public static final /* synthetic */ void $anonfun$checkKeyAlgorithms$2(AlgorithmChecker $this, X509Certificate x509Cert$2, int keySize$1, String a) {
        $this.findKeyConstraint(a).foreach((Function1<AlgorithmConstraint, Object> & Serializable & scala.Serializable)constraint -> {
            AlgorithmChecker.$anonfun$checkKeyAlgorithms$3($this, x509Cert$2, keySize$1, a, constraint);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getCommonName$1(Rdn check$ifrefutable$1) {
        Rdn rdn = check$ifrefutable$1;
        boolean bl = rdn != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getCommonName$2(ObjectRef cn$1, Rdn rdn) {
        block0: {
            if (!"CN".equalsIgnoreCase(rdn.getType())) break block0;
            cn$1.elem = rdn.getValue().toString();
        }
    }

    public AlgorithmChecker(LoggerFactory mkLogger, scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints, scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints) {
        this.signatureConstraints = signatureConstraints;
        this.keyConstraints = keyConstraints;
        this.logger = mkLogger.apply(this.getClass());
        this.signatureConstraintsMap = signatureConstraints.iterator().map((Function1<AlgorithmConstraint, Tuple2> & Serializable & scala.Serializable)c -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c.algorithm()), c)).toMap(Predef$.MODULE$.$conforms());
        this.keyConstraintsMap = keyConstraints.iterator().map((Function1<AlgorithmConstraint, Tuple2> & Serializable & scala.Serializable)c -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c.algorithm()), c)).toMap(Predef$.MODULE$.$conforms());
    }
}

