/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.Base64;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sun.security.util.HostnameChecker;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0017\t9B)\u001a4bk2$\bj\\:u]\u0006lWMV3sS\u001aLWM\u001d\u0006\u0003\u0007\u0011\t1a]:m\u0015\t)a!A\u0005tg2\u001cwN\u001c4jO*\u0011q\u0001C\u0001\tif\u0004Xm]1gK*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+mi\u0011A\u0006\u0006\u0003\u0007]Q!\u0001G\r\u0002\u00079,GOC\u0001\u001b\u0003\u0015Q\u0017M^1y\u0013\tabC\u0001\tI_N$h.Y7f-\u0016\u0014\u0018NZ5fe\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\u0005nW2{wmZ3s!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u00055aunZ4fe\u001a\u000b7\r^8ss\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000by)\u0003\u0019A\u0010\t\u000f1\u0002!\u0019!C\u0005[\u00051An\\4hKJ,\u0012A\f\t\u0003A=J!\u0001M\u0011\u0003\u00199{G)\u001a9t\u0019><w-\u001a:\t\rI\u0002\u0001\u0015!\u0003/\u0003\u001dawnZ4fe\u0002BQ\u0001\u000e\u0001\u0005\u0002U\nq\u0002[8ti:\fW.Z\"iK\u000e\\WM]\u000b\u0002mA\u0011q'P\u0007\u0002q)\u0011!%\u000f\u0006\u0003um\n\u0001b]3dkJLG/\u001f\u0006\u0002y\u0005\u00191/\u001e8\n\u0005yB$a\u0004%pgRt\u0017-\\3DQ\u0016\u001c7.\u001a:\t\u000b\u0001\u0003A\u0011A!\u0002\u001b5\fGo\u00195LKJ\u0014WM]8t)\r\u0011\u0005*\u0016\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015Iu\b1\u0001K\u0003!Awn\u001d;oC6,\u0007CA&S\u001d\ta\u0005\u000b\u0005\u0002N\t6\taJ\u0003\u0002P\u0015\u00051AH]8pizJ!!\u0015#\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#\u0012CQAV A\u0002]\u000b\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\u0005aSV\"A-\u000b\u0005i\u0002\u0012BA.Z\u0005%\u0001&/\u001b8dSB\fG\u000eC\u0003^\u0001\u0011\u0005a,\u0001\u0006jg.+'OY3s_N$\"AQ0\t\u000bYc\u0006\u0019A,\t\u000b\u0005\u0004A\u0011\u00012\u0002\rY,'/\u001b4z)\r\u00115\r\u001a\u0005\u0006\u0013\u0002\u0004\rA\u0013\u0005\u0006K\u0002\u0004\rAZ\u0001\bg\u0016\u001c8/[8o!\t)r-\u0003\u0002i-\tQ1k\u0015'TKN\u001c\u0018n\u001c8\t\u000b)\u0004A\u0011A6\u0002#5\fGo\u00195DKJ$\u0018NZ5dCR,7\u000fF\u0002CY6DQ!S5A\u0002)CQA\\5A\u0002=\f\u0001\u0003]3fe\u000e+'\u000f^5gS\u000e\fG/Z:\u0011\u0007\r\u0003(/\u0003\u0002r\t\n)\u0011I\u001d:bsB\u00111O^\u0007\u0002i*\u0011Q/W\u0001\u0005G\u0016\u0014H/\u0003\u0002xi\nY1)\u001a:uS\u001aL7-\u0019;f\u0001")
public class DefaultHostnameVerifier
implements HostnameVerifier {
    private final NoDepsLogger logger;

    private NoDepsLogger logger() {
        return this.logger;
    }

    public HostnameChecker hostnameChecker() {
        return HostnameChecker.getInstance((byte)1);
    }

    public boolean matchKerberos(String hostname, Principal principal) {
        return HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)principal));
    }

    public boolean isKerberos(Principal principal) {
        return principal != null && principal instanceof KerberosPrincipal;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean bl;
        Base64 base64 = Base64.rfc2045();
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: hostname = ", ", sessionId (base64) = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{hostname, base64.encodeToString(session.getId(), false)})));
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            bl = this.matchCertificates(hostname, peerCertificates);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            try {
                Principal principal = session.getPeerPrincipal();
                if (this.isKerberos(principal)) {
                    bl = this.matchKerberos(hostname, principal);
                } else {
                    this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Can't verify principal, not Kerberos"})).s(Nil$.MODULE$));
                    bl = false;
                }
            }
            catch (SSLPeerUnverifiedException e) {
                this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't verify principal, no principal. Cause: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{e})));
                bl = false;
            }
        }
        boolean result2 = bl;
        this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: returning ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(result2)})));
        return result2;
    }

    public boolean matchCertificates(String hostname, Certificate[] peerCertificates) {
        boolean bl;
        Certificate cert;
        HostnameChecker checker = this.hostnameChecker();
        Certificate[] certificateArray = peerCertificates;
        Option option = Array$.MODULE$.unapplySeq(certificateArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) >= 0 && (cert = (Certificate)((SeqLike)option.get()).apply(0)) instanceof X509Certificate) {
            boolean bl2;
            X509Certificate x509Certificate = (X509Certificate)cert;
            try {
                checker.match(hostname, x509Certificate);
                bl2 = true;
            }
            catch (CertificateException e) {
                Collection<List<?>> subjectAltNames = x509Certificate.getSubjectAlternativeNames();
                this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Certificate does not match hostname! subjectAltNames = ", ", hostName = ", " Cause: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{subjectAltNames, hostname, e})));
                bl2 = false;
            }
            bl = bl2;
        } else {
            this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Peer does not have any certificates: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{certificateArray})));
            bl = false;
        }
        return bl;
    }

    public DefaultHostnameVerifier(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }
}

