<?php
/**
 * @package    JEM
 * @copyright  (C) 2013-2026 joomlaeventmanager.net
 * @copyright  (C) 2005-2009 Christoph Lukes
 * @license    https://www.gnu.org/licenses/gpl-3.0 GNU/GPL
 */

defined('JPATH_BASE') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

FormHelper::loadFieldClass('list');

/**
 * CatOptions Field class.
 */
class JFormFieldCatOptions extends ListField
{
    /**
     * The category options field type.
     */
    protected $type = 'CatOptions';


    /**
     * Create Input
     * @see ListField::getInput()
     */
    public function getInput()
    {
        $jinput = Factory::getApplication()->getInput();
        $currentid = $jinput->getInt('id');
        $attr = '';
        $selectedcats = [];

        // Initialize field attributes.
        $attr .= !empty($this->class) ? ' class="' . $this->class . '"' : '';
        $attr .= !empty($this->size) ? ' size="' . $this->size . '"' : '';
        $attr .= $this->multiple ? ' multiple' : '';
        $attr .= $this->required ? ' required aria-required="true"' : '';

        // To avoid user's confusion, readonly="true" should imply disabled="true".
        if ((string) $this->readonly == '1' || (string) $this->readonly == 'true' || (string) $this->disabled == '1'|| (string) $this->disabled == 'true')
        {
            $attr .= ' disabled="disabled"';
        }

        // Initialize JavaScript field attributes.
        $attr .= $this->onchange ? ' onchange="' . $this->onchange . '"' : '';

        $attr2  = '';
        $attr2 .= $this->multiple ? ' multiple' : '';
        $attr2 .= $this->required ? ' required aria-required="true"' : '';
        $attr2 .= ' placeholder="' . Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS') . '" ';

        // To avoid user's confusion, readonly="true" should imply disabled="true".
        if ((string) $this->readonly == '1' || (string) $this->readonly == 'true' || (string) $this->disabled == '1'|| (string) $this->disabled == 'true')
        {
            $attr2 .= ' disabled="disabled"';
        }

        // Get the field options.
        $options = (array) $this->getOptions();

        // Gets currently selected categories (existing event) or default categories (new event)
        if(empty($currentid)) {
            $selectedcats = $this->default ? (array)$this->default : [];
        } else {
            $db = Factory::getContainer()->get('DatabaseDriver');
            $query = $db->getQuery(true);
            $query->select('DISTINCT catid');
            $query->from('#__jem_cats_event_relations');
            $query->where('itemid = ' . $db->quote($currentid));
            $db->setQuery($query);
            $selectedcats = $db->loadColumn();
        }

        // Create a read-only list (no name) with a hidden input to store the value.
        if ((string) $this->readonly == '1' || (string  ) $this->readonly == 'true')
        {
            $html[] = HTMLHelper::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $selectedcats,$this->id);
            $html[] = '<input type="hidden" name="' . $this->name . '" value="' . htmlspecialchars($selectedcats, ENT_COMPAT, 'UTF-8') . '"/>';
        }
        else
        // Create a regular list.
        {
            $html[] = HTMLHelper::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $selectedcats,$this->id);
        }

        Factory::getApplication()->getDocument()->getWebAssetManager()
            ->usePreset('choicesjs')
            ->useScript('webcomponent.field-fancy-select');

        return '<joomla-field-fancy-select ' . $attr2 . '>' . implode($html) . '</joomla-field-fancy-select>';
    }


    /**
     * Retrieve Options
     * @see ListField::getOptions()
     */
    protected function getOptions()
    {
        $options = JemCategories::getCategoriesTree();
        $options = array_values($options);

        // Pad the option text with spaces using depth level as a multiplier
        # the level has to be decreased as we are having a (invisible) root
        # treename is generated by the function so let's use that one instead of the Joomla way
        for ($i = 0, $n = (is_array($options) ? count($options) : 0); $i < $n; $i++)
        {
            /*
            if ($options[$i]->published == 1)
            {
                $options[$i]->text = str_repeat('- ', ($options[$i]->level - 1)) . $options[$i]->text;
            }
            else
            {
                $options[$i]->text = str_repeat('- ', ($options[$i]->level - 1)) . '[' . $options[$i]->text . ']';
            }
            */

            $options[$i]->text = $options[$i]->treename;
        }

        // Merge any additional options in the XML definition.
        $options = array_merge(parent::getOptions(), $options);

        return $options;
    }
}
