<?php
/**
 * @package    JEM
 * @copyright  (C) 2013-2026 joomlaeventmanager.net
 * @copyright  (C) 2005-2009 Christoph Lukes
 * @license    https://www.gnu.org/licenses/gpl-3.0 GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Date\Date;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

// Create shortcuts to some parameters.
$params      = $this->item->params;
$images      = json_decode($this->item->datimage);
$attribs     = json_decode($this->item->attribs);
$user        = JemFactory::getUser();
$jemsettings = JemHelper::config();
$app         = Factory::getApplication();
$document    = $app->getDocument();
$uri         = Uri::getInstance();

// Add expiration date, if old events will be archived or removed
if ($jemsettings->oldevent > 0) {
    $enddate = strtotime($this->item->enddates?:($this->item->dates?:date("Y-m-d")));
    $expDate = date("D, d M Y H:i:s", strtotime('+1 day', $enddate));
    $document->addCustomTag('<meta http-equiv="expires" content="' . $expDate . '"/>');
}

$catclasses = '';
foreach ((array)$this->categories as $category) {
    $catclasses .= ' cat_id' . $this->escape($category->id);
}

if ($params->get('access-view')) { /* This will show nothings otherwise - ??? */ ?>

    <div id="jem" class="event_id<?php
    echo $this->escape($this->item->did);
    if (!empty($this->item->locid)) {
        echo ' venue_id' . $this->escape($this->item->locid);
    }
    if (!empty($catclasses)) {
        echo $this->escape($catclasses);
    }
    ?> jem_event<?php echo $this->escape($this->pageclass_sfx); ?>"
         itemscope="itemscope" itemtype="https://schema.org/Event">

        <meta itemprop="url" content="<?php echo rtrim($uri->base(), '/').Route::_(JemHelperRoute::getEventRoute($this->item->slug)); ?>" />
        <meta itemprop="identifier" content="<?php echo rtrim($uri->base(), '/').Route::_(JemHelperRoute::getEventRoute($this->item->slug)); ?>" />

        <div class="buttons">
            <?php
            $btn_params = array('slug' => $this->item->slug, 'print_link' => $this->print_link);
            echo JemOutput::createButtonBar($this->getName(), $this->permissions, $btn_params);
            ?>
        </div>

        <?php if ($this->params->get('show_page_heading', 1)) : ?>
            <h1 class="componentheading">
                <?php echo $this->escape($this->params->get('page_heading')); ?>
            </h1>
        <?php endif; ?>

        <!-- Event -->
        <h2 class="jem">
            <?php
            echo Text::_('COM_JEM_EVENT') . JemOutput::recurrenceicon($this->item) . ' ';
            if($this->item_root) {
                echo JemOutput::editbutton($this->item_root, $params, $attribs, $this->permissions->canEditEvent, 'editevent') . ' ';
            }
            if(!$this->item_root || ($this->item_root && $this->item->recurrence_first_id)) {
                echo JemOutput::editbutton($this->item, $params, $attribs, $this->permissions->canEditEvent, 'editevent') .' ';
            }
            echo JemOutput::copybutton($this->item, $params, $attribs, $this->permissions->canAddEvent, 'editevent');
            ?>
        </h2>
        <div class="jem-row">
            <div class="jem-info">
                <dl class="jem-dl">
                    <?php if ($params->get('event_show_detailstitle',1)) : ?>
                        <dt class="jem-title hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_TITLE'); ?>"><?php echo Text::_('COM_JEM_TITLE'); ?>:</dt>
                        <dd class="jem-title" itemprop="name"><?php echo $this->escape($this->item->title); ?></dd>
                    <?php else : ?>
                        <meta itemprop="name" content="<?php echo $this->escape($this->item->title); ?>" />
                    <?php endif; ?>
                    <dt class="jem-when hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_WHEN'); ?>"><?php echo Text::_('COM_JEM_WHEN'); ?>:</dt>
                    <dd class="jem-when">
            <span style="white-space: nowrap;">
              <?php
              echo JemOutput::formatLongDateTime($this->item->dates, $this->item->times,$this->item->enddates, $this->item->endtimes);
              echo JemOutput::formatSchemaOrgDateTime($this->item->dates, $this->item->times,$this->item->enddates, $this->item->endtimes);
              ?>
            </span>
                    </dd>
                    <?php if ((!empty($this->item->locid)) && ($params->get('event_show_venue_name') == 1)) : ?>
                        <dt class="jem-where hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_WHERE'); ?>"><?php echo Text::_('COM_JEM_WHERE'); ?>:</dt>
                        <dd class="jem-where"><?php
                            if (($params->get('event_show_detlinkvenue') == 1) && (!empty($this->item->url))) :
                                ?><a target="_blank" href="<?php echo $this->item->url; ?>"><?php echo $this->escape($this->item->venue); ?></a><?php
                            elseif (($params->get('event_show_detlinkvenue') == 2) && (!empty($this->item->venueslug))) :
                                ?><a href="<?php echo Route::_(JemHelperRoute::getVenueRoute($this->item->venueslug)); ?>"><?php echo $this->item->venue; ?></a><?php
                            else :
                                echo $this->escape($this->item->venue);
                            endif;

                            # will show "venue" or "venue - city" or "venue - city, state" or "venue, state"
                            $city  = $this->escape($this->item->city);
                            $state = $this->escape($this->item->state);
                            if ($city)  { echo ' - ' . $city; }
                            if ($state) { echo ', ' . $state; }
                            ?>
                        </dd>
                    <?php
                    endif;
                    $n = is_array($this->categories) ? count($this->categories) : 0;
                    if ($params->get('event_show_category') == 1) : ?>

                    <dt class="jem-category hasTooltip" data-original-title="<?php echo $n < 2 ? Text::_('COM_JEM_CATEGORY') : Text::_('COM_JEM_CATEGORIES'); ?>">
                        <?php echo $n < 2 ? Text::_('COM_JEM_CATEGORY') : Text::_('COM_JEM_CATEGORIES'); ?>:
                    </dt>
                    <dd class="jem-category">
                        <?php
                    foreach ((array)$this->categories as $i => $category) {
                        if ($i > 0) {
                                echo ', ';
                        }
                           if ($params->get('event_link_category') == 1) {
                            echo '<a href="' . Route::_(JemHelperRoute::getCategoryRoute($category->catslug)) . '">' . $this->escape($category->catname) . '</a>';
                        } else {
                            echo $this->escape($category->catname);
                        }
                    }
                    echo '</dd>';
                            endif;

                    for ($cr = 1; $cr <= 10; $cr++) {
                        $currentRow = $this->item->{'custom'.$cr};
                        if (preg_match('%^http(s)?://%', $currentRow)) {
                            $currentRow = '<a href="'.$this->escape($currentRow).'" target="_blank">'.$this->escape($currentRow).'</a>';
                        }
                        if ($currentRow) {
                            ?>
                            <dt class="jem-custom<?php echo $cr; ?> hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_EVENT_CUSTOM_FIELD'.$cr); ?>"><?php echo Text::_('COM_JEM_EVENT_CUSTOM_FIELD'.$cr); ?>:</dt>
                            <dd class="jem-custom<?php echo $cr; ?>"><?php echo $currentRow; ?></dd>
                            <?php
                        }
                    }
                    ?>

                    <?php if ($params->get('event_show_hits')) : ?>
                        <dt class="jem-hits hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_EVENT_HITS_LABEL'); ?>"><?php echo Text::_('COM_JEM_EVENT_HITS_LABEL'); ?>:</dt>
                        <dd class="jem-hits"><?php echo Text::sprintf('COM_JEM_EVENT_HITS', $this->item->hits); ?></dd>
                    <?php endif; ?>


                    <!-- AUTHOR -->
                    <?php if ($params->get('event_show_author') && !empty($this->item->author)) : ?>
                        <dt class="createdby hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_EVENT_CREATED_BY_LABEL'); ?>"><?php echo Text::_('COM_JEM_EVENT_CREATED_BY_LABEL'); ?>:</dt>
                        <dd class="createdby">
                            <?php $author = $this->item->created_by_alias ? $this->item->created_by_alias : $this->item->author; ?>
                            <?php if (!empty($this->item->contactid2) && $params->get('event_link_author') == true) :
                                $needle = 'index.php?option=com_contact&view=contact&id=' . $this->item->contactid2 . '&catid=' . $this->item->concatid;
                                $menu = Factory::getApplication()->getMenu();
                                $item = $menu->getItems('link', $needle, true);
                                $cntlink = !empty($item) ? $needle . '&Itemid=' . $item->id : $needle;
                                echo Text::sprintf('COM_JEM_EVENT_CREATED_BY', HTMLHelper::_('link', Route::_($cntlink), $author));
                            else :
                                echo Text::sprintf('COM_JEM_EVENT_CREATED_BY', $author);
                            endif;
                            ?>
                        </dd>
                    <?php endif; ?>

                    <!-- PUBLISHING STATE -->
                    <?php if (!empty($this->showeventstate) && isset($this->item->published)) : ?>
                        <dt class="jem-published hasTooltip" data-original-title="<?php echo Text::_('JSTATUS'); ?>"><?php echo Text::_('JSTATUS'); ?>:</dt>
                        <dd class="jem-published">
                            <?php switch ($this->item->published) {
                                case  1: echo Text::_('JPUBLISHED');   break;
                                case  0: echo Text::_('JUNPUBLISHED'); break;
                                case  2: echo Text::_('JARCHIVED');    break;
                                case -2: echo Text::_('JTRASHED');     break;
                            } ?>
                        </dd>
                    <?php endif; ?>
                </dl>
            </div>
            <style>
                .jem-img {
                    flex-basis: <?php echo $this->jemsettings->imagewidth; ?>px;
                }
            </style>
            <div class="jem-img">
                <?php echo JemOutput::flyer($this->item, $this->dimage, 'event'); ?>
            </div>
        </div>

        <!-- DESCRIPTION -->
        <?php if ($params->get('event_show_description','1') && ($this->item->fulltext != '' && $this->item->fulltext != '<br>' || $this->item->introtext != '' && $this->item->introtext != '<br>')) { ?>
            <h2 class="jem-description"><?php echo Text::_('COM_JEM_EVENT_DESCRIPTION'); ?></h2>
            <div class="jem-description event_desc" itemprop="description">

                <?php
                if ($params->get('access-view')) {
                    if (!$params->get('event_show_intro') && $this->item->fulltext != null) {
                        echo $this->item->fulltext;
                    } else {
                        echo $this->item->text;
                    }
                }
                /* optional teaser intro text for guests - NOT SUPPORTED YET */
                elseif (0 /*$params->get('event_show_noauth') == true and  $user->get('guest')*/ ) {
                    echo $this->item->introtext;
                    // Optional link to let them register to see the whole event.
                    if ($params->get('event_show_readmore') && $this->item->fulltext != null) {
                        $link1 = Route::_('index.php?option=com_users&view=login');
                        $link = new Uri($link1);
                        echo '<p class="readmore">';
                        echo '<a href="'.$link.'">';
                        if ($params->get('event_alternative_readmore') == false) {
                            echo Text::_('COM_JEM_EVENT_REGISTER_TO_READ_MORE');
                        } elseif ($readmore = $params->get('alternative_readmore')) {
                            echo $readmore;
                        }

                        if ($params->get('event_show_readmore_title', 0) != 0) {
                            echo HTMLHelper::_('string.truncate', ($this->item->title), $params->get('event_readmore_limit'));
                        } elseif ($params->get('event_show_readmore_title', 0) == 0) {
                        } else {
                            echo HTMLHelper::_('string.truncate', ($this->item->title), $params->get('event_readmore_limit'));
                        } ?>
                        </a>
                        </p>
                        <?php
                    }
                } /* access_view / show_noauth */
                ?>
            </div>
        <?php } ?>

        <!--  Contact -->
        <?php if ($params->get('event_show_contact') && !empty($this->item->conid )) : ?>

            <h2 class="jem-contact"><?php echo Text::_('COM_JEM_CONTACT_INFO') ; ?></h2>

            <dl class="jem-dl">
                <dt class="con_name hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_NAME'); ?>"><?php echo Text::_('COM_JEM_NAME'); ?>:</dt>
                <dd class="con_name">
                    <?php
                    $contact = $this->item->conname;
                    if ($params->get('event_link_contact') == true) :
                        $needle = 'index.php?option=com_contact&view=contact&id=' . $this->item->conid . '&catid=' . $this->item->concatid;
                        $menu = Factory::getApplication()->getMenu();
                        $item = $menu->getItems('link', $needle, true);
                        $cntlink2 = !empty($item) ? $needle . '&Itemid=' . $item->id : $needle;
                        echo Text::sprintf('COM_JEM_EVENT_CONTACT', HTMLHelper::_('link', Route::_($cntlink2), $contact));
                    else :
                        echo Text::sprintf('COM_JEM_EVENT_CONTACT', $contact);
                    endif;
                    ?>
                </dd>

                <?php if ($this->item->contelephone) : ?>
                    <dt class="con_telephone hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_TELEPHONE'); ?>"><?php echo Text::_('COM_JEM_TELEPHONE'); ?>:</dt>
                    <dd class="con_telephone">
                        <?php echo $this->escape($this->item->contelephone); ?>
                    </dd>
                <?php endif; ?>
            </dl>
        <?php endif ?>

        <?php $this->attachments = $this->item->attachments; ?>
        <?php echo $this->loadTemplate('attachments'); ?>

        <!-- Venue -->
        <?php if ((!empty($this->item->locid)) && !empty($this->item->venue) && $params->get('event_show_venue', '1')) : ?>
            <p></p>
            <hr class="jem-hr">
            <?php
            // has user access
            $venueaccess = '';
            if (!$this->item->user_has_access_venue) {
                // show a closed lock icon
                $venueaccess = ' <span class="icon-lock jem-lockicon" aria-hidden="true"></span>';
            }
            ?>

            <div class="venue_id<?php echo $this->item->locid; ?>" itemprop="location" itemscope="itemscope" itemtype="https://schema.org/Place">
                <meta itemprop="name" content="<?php echo $this->escape($this->item->venue); ?>" />
                <?php $itemid = $this->item ? $this->item->id : 0 ; ?>
                <h2 class="jem-location">
                    <?php
                    echo Text::_('COM_JEM_VENUE').' '.JemOutput::editbutton($this->item, $params, $attribs, $this->permissions->canEditVenue, 'editvenue').' '.JemOutput::copybutton($this->item, $params, $attribs, $this->permissions->canAddVenue, 'editvenue');
                    ?>
                </h2>

                <div class="jem-row jem-wrap-reverse">
                    <?php if ($params->get('event_show_detailsadress', '1')) : ?>
                        <div class="jem-grow-2">
                            <dl class="jem-dl" itemprop="address" itemscope
                                itemtype="https://schema.org/PostalAddress">
                                <dt class="venue hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_LOCATION'); ?>"><?php echo Text::_('COM_JEM_LOCATION'); ?>:</dt>
                                <dd class="venue">
                                    <?php
                                    if (($params->get('event_show_detlinkvenue') == 1) && (!empty($this->item->url))) :
                                        echo '<a target="_blank" href="' . $this->item->url . '">' . $this->escape($this->item->venue) . '</a>';
                                    elseif (($params->get('event_show_detlinkvenue') == 2) && (!empty($this->item->venueslug))) :
                                        echo '<a href="' . Route::_(JemHelperRoute::getVenueRoute($this->item->venueslug)) . '">' . $this->escape($this->item->venue) . '</a>';
                                    else :
                                        echo $this->escape($this->item->venue);
                                    endif;
                                    echo $venueaccess;
                                    ?>
                                </dd>
                                <?php if($this->item->user_has_access_venue) : ?>
                                <?php if ($this->item->street) : ?>
                                    <dt class="venue_street hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_STREET'); ?>"><?php echo Text::_('COM_JEM_STREET'); ?>:</dt>
                                    <dd class="venue_street" itemprop="streetAddress">
                                        <?php echo $this->escape($this->item->street); ?>
                                    </dd>
                                <?php endif; ?>

                                <?php if ($this->item->postalCode) : ?>
                                    <dt class="venue_postalCode hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_ZIP'); ?>"><?php echo Text::_('COM_JEM_ZIP'); ?>:</dt>
                                    <dd class="venue_postalCode" itemprop="postalCode">
                                        <?php echo $this->escape($this->item->postalCode); ?>
                                    </dd>
                                <?php endif; ?>

                                <?php if ($this->item->city) : ?>
                                    <dt class="venue_city hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_CITY'); ?>"><?php echo Text::_('COM_JEM_CITY'); ?>:</dt>
                                    <dd class="venue_city" itemprop="addressLocality">
                                        <?php echo $this->escape($this->item->city); ?>
                                    </dd>
                                <?php endif; ?>

                                <?php if ($this->item->state) : ?>
                                    <dt class="venue_state hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_STATE'); ?>"><?php echo Text::_('COM_JEM_STATE'); ?>:</dt>
                                    <dd class="venue_state" itemprop="addressRegion">
                                        <?php echo $this->escape($this->item->state); ?>
                                    </dd>
                                <?php endif; ?>

                                <?php if ($this->item->country) : ?>
                                    <dt class="venue_country hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_COUNTRY'); ?>"><?php echo Text::_('COM_JEM_COUNTRY'); ?>:</dt>
                                    <dd class="venue_country">
                                        <?php echo $this->item->countryimg ? $this->item->countryimg : $this->item->country; ?>
                                        <meta itemprop="addressCountry" content="<?php echo $this->item->country; ?>" />
                                    </dd>
                                <?php endif; ?>

                                <!-- PUBLISHING STATE -->
                                <?php if (!empty($this->showvenuestate) && isset($this->item->locpublished)) : ?>
                                    <dt class="venue_published hasTooltip" data-original-title="<?php echo Text::_('JSTATUS'); ?>"><?php echo Text::_('JSTATUS'); ?>:</dt>
                                    <dd class="venue_published">
                                        <?php switch ($this->item->locpublished) {
                                            case  1: echo Text::_('JPUBLISHED');   break;
                                            case  0: echo Text::_('JUNPUBLISHED'); break;
                                            case  2: echo Text::_('JARCHIVED');    break;
                                            case -2: echo Text::_('JTRASHED');     break;
                                        } ?>
                                    </dd>
                                <?php endif; ?>

                                <?php
                                for ($cr = 1; $cr <= 10; $cr++) {
                                    $currentRow = $this->item->{'venue'.$cr};
                                    if (preg_match('%^http(s)?://%', $currentRow)) {
                                        $currentRow = '<a href="' . $this->escape($currentRow) . '" target="_blank">' . $this->escape($currentRow) . '</a>';
                                    }
                                    if ($currentRow) {
                                        ?>
                                        <dt class="custom<?php echo $cr; ?> hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_VENUE_CUSTOM_FIELD'.$cr); ?>"><?php echo Text::_('COM_JEM_VENUE_CUSTOM_FIELD'.$cr); ?>:</dt>
                                        <dd class="custom<?php echo $cr; ?>"><?php echo $currentRow; ?></dd>
                                        <?php
                                    }
                                }
                                ?>
                                <?php if ($params->get('event_show_mapserv') == 1 || $params->get('event_show_mapserv') == 4) : ?>
                                    <?php echo JemOutput::mapicon($this->item, 'event', $params); ?>
                                <?php endif; ?>
                                <?php endif; ?>
                            </dl>
                        </div>

                        <div class="jem-img">
                            <?php echo JemOutput::flyer($this->item, $this->limage, 'venue'); ?>
                        </div>
                    <?php else : // $params->get('event_show_detailsadress', '1') == 0 ?>
                        <div class="jem-grow-2">
                            <dl class="jem-dl" itemprop="address" itemscope
                                itemtype="https://schema.org/PostalAddress">
                                <dt class="venue hasTooltip" data-original-title="<?php echo Text::_('COM_JEM_LOCATION'); ?>"><?php echo Text::_('COM_JEM_LOCATION'); ?>:</dt>
                                <dd class="venue">
                                    <?php
                                    if (($params->get('event_show_detlinkvenue') == 1) && (!empty($this->item->url))) :
                                        echo '<a target="_blank" href="' . $this->item->url . '">' . $this->escape($this->item->venue) . '</a>';
                                    elseif (($params->get('event_show_detlinkvenue') == 2) && (!empty($this->item->venueslug))) :
                                        echo '<a href="' . Route::_(JemHelperRoute::getVenueRoute($this->item->venueslug)) . '">' . $this->escape($this->item->venue) . '</a>';
                                    else :
                                        echo $this->escape($this->item->venue);
                                    endif;
                                    ?>
                                </dd>
                            </dl>
                        </div>

                        <div class="jem-img">
                            <?php echo JemOutput::flyer($this->item, $this->limage, 'venue'); ?>
                        </div>
                    <?php endif; /* event_show_detailsadress */ ?>
                </div>
                <?php if($this->item->user_has_access_venue) :
                $event_show_mapserv = $params->get('event_show_mapserv');
                if ($params->get('event_show_mapserv') == 2 || $params->get('event_show_mapserv') == 5) : ?>
                    <div class="jem-map">
                        <?php echo JemOutput::mapicon($this->item, 'event', $params); ?>
                    </div>
                <?php endif; ?>
                <?php if ($event_show_mapserv == 3) : ?>
                    <div class="jem-map">
                        <input type="hidden" id="latitude" value="<?php echo $this->item->latitude; ?>">
                        <input type="hidden" id="longitude" value="<?php echo $this->item->longitude; ?>">
                        <input type="hidden" id="venue" value="<?php echo $this->item->venue; ?>">
                        <input type="hidden" id="street" value="<?php echo $this->item->street; ?>">
                        <input type="hidden" id="city" value="<?php echo $this->item->city; ?>">
                        <input type="hidden" id="state" value="<?php echo $this->item->state; ?>">
                        <input type="hidden" id="postalCode" value="<?php echo $this->item->postalCode; ?>">
                        <?php echo JemOutput::mapicon($this->item, 'event', $params); ?>
                    </div>
                <?php endif; ?>

                <?php if ($params->get('event_show_locdescription', '1') && $this->item->locdescription != ''
                    && $this->item->locdescription != '<br>') : ?>
                    <h2 class="location_desc"><?php echo Text::_('COM_JEM_VENUE_DESCRIPTION'); ?></h2>
                    <div class="description location_desc" itemprop="description">
                        <?php echo $this->item->locdescription; ?>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

                <?php $this->attachments = $this->item->vattachments; ?>
                <?php echo $this->loadTemplate('attachments'); ?>

            </div>

        <?php elseif (empty($this->item->locid)) : ?>
            <div itemtype="https://schema.org/Place" itemscope itemprop="location" style="display: none;">
                <meta itemprop="name" content="None"/>
            </div>

        <?php else : ?>
            <div itemtype="https://schema.org/Place" itemscope itemprop="location" style="display: none;">
                <meta itemprop="name" content="<?php echo $this->escape($this->item->venue); ?>" />
                <div itemprop="address" itemscope itemtype="https://schema.org/PostalAddress" style="display: none;">
                    <?php if ($this->item->street) : ?>
                        <meta itemprop="streetAddress" content="<?php echo $this->escape($this->item->street); ?>">
                    <?php endif; ?>
                    <?php if ($this->item->postalCode) : ?>
                        <meta itemprop="postalCode" content="<?php echo $this->escape($this->item->postalCode); ?>">
                    <?php endif; ?>
                    <?php if ($this->item->city) : ?>
                        <meta itemprop="addressLocality" content="<?php echo $this->escape($this->item->city); ?>">
                    <?php endif; ?>
                    <?php if ($this->item->state) : ?>
                        <meta itemprop="addressRegion" content="<?php echo $this->escape($this->item->state); ?>">
                    <?php endif; ?>
                    <?php if ($this->item->country) : ?>
                        <meta itemprop="addressCountry" content="<?php echo $this->escape($this->item->country); ?>">
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Registration -->
        <?php if ($this->showAttendees && $params->get('event_show_registration', '0')) { ?>
            <hr class="jem-hr">
            <dl class="jem-dl floattext">
                <?php
                $timeNow = time();

                switch ($this->e_reg) {
                    case 0:
                        //Event without registration (NO)
                        break;
                    case 1:
                        //Event with registration (YES with or witout UNTIL)
                         echo '<h2 class="register">' . Text::_('COM_JEM_REGISTRATION') . '</h2>';
                        echo $this->loadTemplate('attendees');
                        if($this->dateUnregistationUntil) {
                            echo '<dt>' . ($this->allowAnnulation? Text::_('COM_JEM_EVENT_ANNULATION_NOTWILLBE_FROM') : Text::_('COM_JEM_EVENT_ANNULATION_ISNOT_FROM')) . '</dt><dd>' . HTMLHelper::_('date', $this->dateUnregistationUntil, Text::_('DATE_FORMAT_LC2')) . '</dd>';
                        }
                        break;
                    case 2:
                        //Event with date starting registration (FROM with or witout UNTIL)
                        echo '<h2 class="register">' . Text::_('COM_JEM_REGISTRATION') . '</h2>';
                        if($this->dateRegistationFrom > $timeNow) {
                            echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_WILLBE_FROM') . '</dt><dd>' . HTMLHelper::_('date', $this->dateRegistationFrom, Text::_('DATE_FORMAT_LC2'));
                        }else if ($this->allowRegistration) {
                            echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_IS_FROM') . '</dt><dd>' . HTMLHelper::_('date', $this->dateRegistationFrom, Text::_('DATE_FORMAT_LC2'));
                            if($this->dateRegistationUntil){
                                echo " " . mb_strtolower(Text::_('COM_JEM_UNTIL')) . ' ' . HTMLHelper::_('date', $this->dateRegistationUntil, Text::_('DATE_FORMAT_LC2'));
                            }
                            echo "</dd>";
                            echo $this->loadTemplate('attendees');

                            //Event with date starting annulation
                            if($this->dateUnregistationUntil) {
                                echo '<dt>' . ($this->allowAnnulation? Text::_('COM_JEM_EVENT_ANNULATION_NOTWILLBE_FROM') : Text::_('COM_JEM_EVENT_ANNULATION_ISNOT_FROM')) . '</dt><dd>' . HTMLHelper::_('date', $this->dateUnregistationUntil, Text::_('DATE_FORMAT_LC2')) . '</dd>';
                            }
                        }else if($this->dateRegistationUntil !== false && $this->dateRegistationUntil < $timeNow) {
                            echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_WAS_UNTIL') . '</dt><dd>' . HTMLHelper::_('date', $this->dateRegistationUntil, Text::_('DATE_FORMAT_LC2')) .  '</dd>';
                            echo $this->loadTemplate('attendees');

                            //Event with date starting annulation
                            if($this->dateUnregistationUntil) {
                                echo '<dt>' . ($this->allowAnnulation? Text::_('COM_JEM_EVENT_ANNULATION_NOTWILLBE_FROM') : Text::_('COM_JEM_EVENT_ANNULATION_ISNOT_FROM')) . '</dt><dd>' . HTMLHelper::_('date', $this->dateUnregistationUntil, Text::_('DATE_FORMAT_LC2')) . '</dd>';
                            }
                        } else {
                            // open registration to the end of event
                            if($this->item->enddates){
                                $endDateEvent = strtotime($this->item->enddates . ' ' . ($this->item->endtimes ? $this->item->endtimes : '23:59:59'));
                                if($timeNow <= $endDateEvent){
                                    echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_IS_UNTIL');
                                } else {
                                    echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_WAS_UNTIL');
                                }
                                echo '</dt><dd>' . HTMLHelper::_('date', $endDateEvent, Text::_('DATE_FORMAT_LC2')) . '</dd>';
                                echo $this->loadTemplate('attendees');
                            }else{
                                if(!empty($this->item->dates)) {
                                    $endDateEvent = strtotime($this->item->dates . ' ' . ($this->item->times ? $this->item->times : '23:59:59'));
                                    if($timeNow <= $endDateEvent){
                                        echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_IS_UNTIL');
                                    } else {
                                        echo '<dt>' . Text::_('COM_JEM_EVENT_REGISTRATION_WAS_UNTIL');
                                    }
                                    echo '</dt><dd>' . HTMLHelper::_('date', $endDateEvent, Text::_('DATE_FORMAT_LC2')) . '</dd>';
                                    echo $this->loadTemplate('attendees');
                                }
                            }
                        }
                        break;
                } ?>
            </dl>
        <?php } ?>

        <?php if (!empty($this->item->pluginevent->onEventEnd)) : ?>
            <hr class="jem-hr">
            <?php echo $this->item->pluginevent->onEventEnd; ?>
        <?php endif; ?>

        <div class="copyright">
            <?php echo JemOutput::footer(); ?>
        </div>
    </div>

<?php }

echo JemOutput::lightbox();
?>
