import os
import pathlib
import shutil

try:
	if os.path.isdir('title'):
		shutil.rmtree('title')
		print("Older title folder found - removing")


	print("Copying titles folder...")
	shutil.copytree('titles', 'title')

	for path, subdirs, files in os.walk('title'):
		for name in files:
			if name == "cetk":
				os.remove(pathlib.PurePath(path, name))
				print("Deleting cetk")
			if 'tmd.' in name:
				os.rename(pathlib.PurePath(path, name), path + "/title.tmd")
				print('Renaming {0} to title.tmd'.format(name))
	dirs = []
	for subdir in os.listdir('title'):
		name, subname = subdir[:len(subdir)//2], subdir[len(subdir)//2:]
		if os.path.isdir("title/" + name):
			print("Merging {0} with existing folder {1}".format(subdir, name))
			for file in os.listdir('title/' + subdir):
				os.rename("title/{0}/{1}".format(subdir, file), "title/{0}/{1}".format(name, subname))
			os.rmdir("title/" + subdir)
		else:
			print("Renaming {0} to {1}".format(subdir, name))
			for file in os.listdir('title/' + subdir):
				print("Renaming subdirectory {0} to {1}".format(file, subname))
				os.rename("title/{0}/{1}".format(subdir, file), "title/{0}/{1}".format(subdir, subname))
			os.rename("title/{0}".format(subdir), "title/{0}".format(name))
		dirs.append('title/{0}/{1}'.format(name, subname))

                
	for dir in dirs:
		print("Adding content folder to " + dir)
		os.mkdir(dir + "/content")
		print("Moving contents to /content")
		for file in os.listdir(dir):
			if not os.path.isdir('{0}/{1}'.format(dir, file)):
				os.rename('{0}/{1}'.format(dir, file), '{0}/content/{1}'.format(dir, file))
except Exception as e:
	print("ERROR: {0}".format(e))
else:
	print("Success")
	
input("Press Enter to continue...")        
