// These demos use .mjs for native ESM modules, to avoid showing bundling:
// https://nodejs.org/api/esm.html
import {app, h, text} from 'https://unpkg.com/hyperapp';
import {IncreaseSum} from './actions.mjs';

const init = {sum: 0};
const view = ({sum}) => {
    return h('h1', {onclick: IncreaseSum}, text(`Sum: ${sum}`));
}

const node = document.getElementById('app');

app({init, view, node});
