// These demos use .mjs for native ESM modules, to avoid showing bundling:
// https://nodejs.org/api/esm.html

function getRandom(multiplier) {
    return Math.floor((Math.random() * multiplier));
}

function getMultiplier(i) {
    // Don't increase so fast as looping continues
    if (i < 10) {
        return 100
    } else {
        return 10
    }
}

export function sumRandoms(setLength) {
    let sum = 0;
    for (let i = 0; i < setLength; i++) {
        sum += getRandom(getMultiplier(i));
    }
    return sum;
}
