// These demos use .mjs for native ESM modules, to avoid showing bundling:
// https://nodejs.org/api/esm.html
import {sumRandoms} from './randoms.mjs';

export const IncreaseSum = (state) => {
    const thisRandom = sumRandoms(20);
    const newSum = state.sum + thisRandom;
    return {...state, sum: newSum};
}


// Added for debugging
const newState = IncreaseSum({sum: 10});
console.log(`Getting a new sum: ${newState.sum}`);
