# -*- coding: utf-8 -*-

import re
import random

from resources.lib.modules import client
from resources.lib.modules import control
from resources.lib.modules import directory as lets
from resources.lib.modules import player
from resources.lib.modules import log_utils


class watchyourtv:
    def __init__(self):
        self.base_link = 'https://watchyour.tv'
        self.list = []
        self.categories = [
            {'title': 'Random Channel', 'url': 'random_channel', 'image': '/images/logo.png'},
            {'title': 'Logged Channels', 'url': 'logged_channels', 'image': '/images/logo@2x.png'},
            {'title': 'Scrape Channels', 'url': '/channels.php', 'image': '/images/logo@2x.png'}
        ]
        self.channels = [
            {"title": "TVS Bazaar of All Nations", "url": "/dvr.php?id=848", "image": "/channels/logo/tvs-bazaar-of-all-nations.png"},
            {"title": "TVS Boxing Network", "url": "/dvr.php?id=786", "image": "/channels/logo/tvs-boxing-network.jpg"},
            {"title": "TVS Cartoon Network/Pinball Network", "url": "/dvr.php?id=837", "image": "/channels/logo/tvs-cartoon-network.jpg"},
            {"title": "TVS Classic Movies", "url": "/watch.php?id=820", "image": "/channels/logo/tvs-classic-movies.png"},
            {"title": "TVS Classic Sports", "url": "/watch.php?id=735", "image": "/channels/logo/tvs-classic-sports.jpg"},
            {"title": "TVS Consumer Direct", "url": "/watch.php?id=840", "image": "/channels/logo/.jpg"},
            {"title": "TVS Drive In Movie", "url": "/watch.php?id=819", "image": "/channels/logo/tvs-drive-in-movie.jpg"},
            {"title": "TVS Family Channel/Light Network", "url": "/watch.php?id=819", "image": "/channels/logo/tvs-family-channel.jpg"},
            {"title": "TVS Film Noir Network", "url": "/watch.php?id=842", "image": "/channels/logo/tvs-film-noir-network.jpg"},
            {"title": "TVS Flashback Network", "url": "/watch.php?id=815", "image": "/channels/logo/tvs-flashback-network.jpg"},
            {"title": "TVS Front Page Detective", "url": "/watch.php?id=844", "image": "/channels/logo/tvs-front-page-detective-.jpg"},
            {"title": "TVS Frontier/Buckboard Network", "url": "/watch.php?id=802", "image": "/channels/logo/tvs-frontier.jpg"},
            {"title": "TVS Hi Tops", "url": "/watch.php?id=816", "image": "/channels/logo/tvs-hi-tops.jpg"},
            {"title": "TVS Hollywood History", "url": "/watch.php?id=823", "image": "/channels/logo/tvs-hollywood-history.jpg"},
            {"title": "TVS Horror", "url": "/watch.php?id=825", "image": "/channels/logo/tvs-horror.jpg"},
            {"title": "TVS Inspirational Network", "url": "/watch.php?id=839", "image": "/channels/logo/tvs-inspirational-network.jpg"},
            {"title": "TVS Jewelry Television", "url": "/watch.php?id=833", "image": "/channels/logo/jewelry-television.jpg"},
            {"title": "TVS Main Street", "url": "/watch.php?id=799", "image": "/channels/logo/tvs-main-street.jpg"},
            {"title": "TVS Music Network/Opus Network", "url": "/watch.php?id=845", "image": "/channels/logo/tvs-music-network.jpg"},
            {"title": "TVS Mystery Network/Cipher Network", "url": "/watch.php?id=843", "image": "/channels/logo/tvs-mystery-network.jpg"},
            {"title": "TVS Nostalgia", "url": "/watch.php?id=797", "image": "/channels/logo/tvs-nostalgia.jpg"},
            {"title": "TVS Nostalgia Movie Network", "url": "/watch.php?id=822", "image": "/channels/logo/tvs-nostalgia-movies.jpg"},
            {"title": "TVS Pet Parade Network", "url": "/watch.php?id=834", "image": "/channels/logo/pet-parade-network.jpg"},
            {"title": "TVS Quiz Show Network", "url": "/watch.php?id=830", "image": "/channels/logo/tvs-game-show-network.jpg"},
            {"title": "TVS Rare Collectibles Televison", "url": "/watch.php?id=831", "image": "/channels/logo/rare-collectibles-televison.jpg"},
            {"title": "TVS Select Network", "url": "/watch.php?id=827", "image": "/channels/logo/tvs-select-network.jpg"},
            {"title": "TVS Silo Discount Network", "url": "/watch.php?id=847", "image": "/channels/logo/tvs-silo-discount-network.png"},
            {"title": "TVS Sitcom", "url": "/watch.php?id=829", "image": "/channels/logo/tvs-comedy-channel.jpg"},
            {"title": "TVS Sports Bureau", "url": "/watch.php?id=832", "image": "/channels/logo/tvs-sports-bureau.jpg"},
            {"title": "TVS Sports Network", "url": "/watch.php?id=832", "image": "/channels/logo/tvs-sports-network.jpg"},
            {"title": "TVS Talk Network", "url": "/watch.php?id=846", "image": "/channels/logo/tvs-talk-network.png"},
            {"title": "TVS Tally Ho", "url": "/watch.php?id=826", "image": "/channels/logo/tvs-tally-ho.jpg"},
            {"title": "TVS Tavern TV", "url": "/watch.php?id=795", "image": "/channels/logo/tvs-tavern-tv.jpg"},
            {"title": "TVS Television Network", "url": "/watch.php?id=818", "image": "/channels/logo/tvs-television-network.jpg"},
            {"title": "TVS Today Home Entertainment Network", "url": "/watch.php?id=841", "image": "/channels/logo/tvs-today-home-entertainment-network.jpg"},
            {"title": "TVS Travel Network/Port O Call", "url": "/watch.php?id=824", "image": "/channels/logo/tvs-travel-network.jpg"},
            {"title": "TVS Turbo Network", "url": "/watch.php?id=793", "image": "/channels/logo/tvs-turbo-network.jpg"},
            {"title": "TVS Vintage Network", "url": "/dvr.php?id=849", "image": "/channels/logo/tvs-vintage-network.jpg"},
            {"title": "TVS Western Movie", "url": "/watch.php?id=821", "image": "/channels/logo/.png"},
            {"title": "TVS Women's Sports Network", "url": "/watch.php?id=798", "image": "/channels/logo/tvs-women-s-sports-network.jpg"}
        ]


    def root(self):
        try:
            for i in self.categories:
                title = client.replaceHTMLCodes(i['title'])
                url = i['url']
                image = self.base_link + i['image']
                if i['url'] == 'random_channel':
                    action = 'watchyourtv_scrape_channel'
                else:
                    action = 'watchyourtv_scrape_category'
                self.list.append({'title': title, 'url': url, 'image': image, 'action': action})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            if url == 'logged_channels':
                for i in self.channels:
                    title = client.replaceHTMLCodes(i['title'])
                    link = self.base_link + i['url']
                    image = self.base_link + i['image']
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'watchyourtv_scrape_channel'})
            else:
                url = self.base_link + url
                html = client.scrapePage(url).text
                channels = client.parseDOM(html, 'div', attrs={'class': 'thumbnail text-center'})
                for i in channels:
                    title = client.parseDOM(i, 'img', ret='alt')[0]
                    title = client.replaceHTMLCodes(title)
                    link = client.parseDOM(i, 'a', ret='href')[0]
                    if not link.startswith('/'):
                        link = '/' + link
                    image = self.base_link + client.parseDOM(i, 'img', ret='src')[0]
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'watchyourtv_scrape_channel'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list


    def scrape_channel(self, url):
        try:
            if url == 'random_channel':
                choice = random.choice(self.channels)
                url = self.base_link + choice['url']
            if not url.startswith('http'):
                url = self.base_link + url
            html = client.scrapePage(url).text
            try:
                try:
                    title = client.parseDOM(html, 'meta', attrs={'property': 'og:title'}, ret='content')[0]
                except:
                    title = client.parseDOM(html, 'title')[0]
                    title = title.replace(' - watchyour.tv - Watch Online Streaming FREE', '')
            except:
                title = url.replace(self.base_link, '')
            title = client.replaceHTMLCodes(title)
            link = re.findall("'(http.+?(?:m3u8|).+?)'", html)[0]
            return player.play(link, title)
        except:
            log_utils.log('scrape_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


class toonamiaftermath:
    def __init__(self):
        self.base_link = 'https://www.toonamiaftermath.com/tatv.json'
        self.list = []


    def root(self):
        try:
            html = client.scrapePage(self.base_link).json()
            channels = html['channels']
            for channel in channels:
                title = client.replaceHTMLCodes(channel['title'])
                description = channel['description']
                url = channel['url']
                image = channel['appImageURL']
                self.list.append({'title': title, 'plot': description, 'plotoutline': description, 'url': url, 'image': image, 'action': 'toonamiaftermath_scrape_channel'})
            lets.addDirectory(self.list, content='episodes')
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_channel(self, title, url):
        try:
            if not url:
                return
            html = client.scrapePage(url).text
            link = re.findall('<file .+?>(.+?)</file>', html)[0]
            return player.play(link, title)
        except:
            log_utils.log('scrape_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


