# -*- coding: utf-8 -*-

import sys

import six

from resources.lib.modules import colorcode
from resources.lib.modules import control
from resources.lib.modules import log_utils

sysaddon = sys.argv[0]
syshandle = int(sys.argv[1])

addonFanart = control.addonFanart()
artwork_enabled = control.setting('addon.artwork')

kodi_version = control.getKodiVersion()

if kodi_version >= 20:
    from resources.lib.modules.listitem import ListItemInfoTag


def endDirectory(content='addons', cached=True):
    control.content(syshandle, content)
    control.directory(syshandle, cacheToDisc=cached)


def addDirectoryItem(title, query, icon, isAction=True, isFolder=True):
    try:
        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
        label = colorcode.customize_text(title)
        try:
            item = control.item(label=label, offscreen=True)
        except:
            item = control.item(label=label)
        item.setArt({'icon': icon, 'thumb': icon, 'fanart': addonFanart})
        control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)
    except Exception:
        log_utils.log('addDirectory', 1)
        pass


def addDirectory(items, queue=False, isFolder=True, content='addons'):
    if items == None or len(items) == 0:
        control.idle()
        #sys.exit()
    for i in items:
        try:
            url = '%s?action=%s&url=%s' % (sysaddon, i['action'], i['url'])
            meta = dict((k,v) for k, v in six.iteritems(i) if not v == '0')
            title = i['title']
            label = colorcode.customize_text(title)
            if artwork_enabled == 'true':
                icon = i['image'] if not i['image'] == (None or 'None') else 'DefaultVideo.png'
            else:
                icon = 'DefaultVideo.png'
            try:
                item = control.item(label=label, offscreen=True)
            except:
                item = control.item(label=label)
            item.setArt({'icon': icon, 'thumb': icon, 'fanart': addonFanart})
            item.setProperty('IsPlayable', 'true')
            video_streaminfo = {'codec': 'h264'}
            if kodi_version >= 20:
                info_tag = ListItemInfoTag(item, 'video')
                info_tag.set_info(control.metadataClean(meta))
                info_tag.add_stream_info('video', video_streaminfo)
            else:
                item.setInfo(type='Video', infoLabels=control.metadataClean(meta))
                item.addStreamInfo('video', video_streaminfo)
            control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)
        except Exception:
            log_utils.log('addDirectory', 1)
            pass
    endDirectory(content=content)


