%{
Jing Lou, Mingwu Ren, Huan Wang, "Regional Principal Color Based Saliency Detection," PLoS ONE, vol. 9, no. 11, pp. e112475: 1-13, 2014. doi: 10.1371/journal.pone.0112475
Project webpage: http://www.loujing.com/rpc-saliency
%}

% PLOTPRF plots the Precision-Recall curve and the F-measure curve of our RPC saliency method.
% 	The variable PRF includes three columns:
% 		1st column: Precision
% 		2nd column: Recall
% 		3rd column: F-measure

clc; clear; close all;

load('ECSSD_RPC_PRF.mat');

% Precision-Recall
figure;
plot(PRF(:,2), PRF(:,1));
axis([0 1 0 1]);
set(gca, 'XTick',0:0.1:1);
set(gca, 'YTick',0:0.1:1);
set(gca, 'XTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Recall');
ylabel('Precision');
title('Precision-Recall curve');

% F-measure
figure;
plot(0:255, PRF(:,3));
axis([0 255 0 1]);
set(gca, 'XTick',0:50:255);
set(gca, 'YTick',0:0.1:1);
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Threshold');
ylabel('F-measure');
title('F-measure curve');

