%{
Jing Lou, Fenglei Xu, Qingyuan Xia, Wankou Yang, Mingwu Ren, "Hierarchical Co-salient Object Detection via Color Names," 
in Proceedings of the Asian Conference on Pattern Recognition (ACPR), pp. 718-724, 2017. (Spotlight)

Project webpage: http://www.loujing.com/hcn-co-sod/
%}

% PLOTPRF plots the Precision-Recall curve and the F-measure curve of our HCN saliency method.
% 	The variable PRF includes three columns:
% 		1st column: Precision
% 		2nd column: Recall
% 		3rd column: F-measure

clc; clear; close all;

load('ASD_HCNs_PRF.mat');


%% Precision-Recall
figure;
hold on;

plot(PRF(1,2), PRF(1,1), 'Marker','.', 'MarkerSize',20, 'Color', [1 0 0]);
plot(PRF(2:256,2), PRF(2:256,1), 'LineWidth',2, 'Color', [1 0 0]);
%%% OR
% plot(PRF(1:256,2), PRF(1:256,1), 'LineWidth',2, 'Color', [1 0 0]);

axis([0 1 0 1]);
set(gca, 'XTick',0:0.1:1);
set(gca, 'YTick',0:0.1:1);
set(gca, 'XTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Recall');
ylabel('Precision');
title('Precision-Recall curve');


%% F-measure
figure;
hold on;

plot(0, PRF(1,3), 'Marker','.', 'MarkerSize',20, 'Color', [1 0 0]);
plot(1:255, PRF(2:256,3), 'LineWidth',2, 'Color', [1 0 0]);
%%% OR
% plot(0:255, PRF(1:256,3), 'LineWidth',2, 'Color', [1 0 0]);

axis([0 255 0 1]);
set(gca, 'XTick',0:50:255);
set(gca, 'YTick',0:0.1:1);
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Threshold');
ylabel('F-measure');
title('F-measure curve');

