%{
Jing Lou*, Huan Wang, Longtao Chen, Fenglei Xu, Qingyuan Xia, Wei Zhu, Mingwu Ren*, "Exploiting Color Name Space for Salient Object Detection," 
Multimedia Tools and Applications, vol. 79, no. 15, pp. 10873C10897, 2020. doi:10.1007/s11042-019-07970-x

Project webpage: http://www.loujing.com/cns-sod/
%}

% PLOTPRF plots the Precision-Recall curve, F-measure curve, and Precision-Recall bar of our CNS model.
% 	The variable PRF includes three columns:
% 		1st column: Precision
% 		2nd column: Recall
% 		3rd column: F-measure


clc; clear; close all;

load('ASD_CNS_PRF.mat');

% Precision-Recall curve
figure;
plot(PRF(1:256, 2), PRF(1:256, 1));
axis([0 1 0 1]);
set(gca, 'XTick', 0:0.1:1);
set(gca, 'YTick', 0:0.1:1);
set(gca, 'XTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Recall');
ylabel('Precision');
title('Precision-Recall curve');

% F-measure curve
figure;
plot(0:255, PRF(1:256, 3));
axis([0 255 0 1]);
set(gca, 'XTick', 0:50:255);
set(gca, 'YTick', 0:0.1:1);
set(gca, 'YTickLabel',{'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
grid on;
xlabel('Threshold');
ylabel('F-measure');
title('F-measure curve');

% Precision-Recall bar
PRBar = [PRF(257,1:3); NaN(1,3)];
figure;
b = bar(PRBar);
FaceColor = {[.2157, .4941, .7216]; [.8941, .1020, .1098]; [.3020, .6863, .2902]};
for k = 1:3
	b(k).FaceColor = FaceColor{k};
	b(k).EdgeColor = FaceColor{k};
end
axis([0.5, size(PRBar,1)+0.5, 0, 1]);
legend('Precision','Recall','F-measure');
set(gca, 'YTickLabel', {'0', '', '0.2', '', '0.4', '', '0.6', '', '0.8', '', '1'});
set(gca, 'YTick', 0:0.1:1);
set(gca, 'XTickLabel', {'CNS', 'NaN'});
set(gca, 'XTick', 1:size(PRBar,1));
set(gca, 'XGrid','off','YGrid','on');
box off;
title('Precision-Recall bar');
