library(shinyalert)
library(shiny)
library(DT)
library(shinyWidgets)
library(tidyverse)
source("www/question_source.R")

# 설문조사 질문 정의
q1_code <- c("slp_q1", "slp_q2", "slp_q3")
q1_source <- c("1. 잠들기 어렵다", "2. 잠을 유지하기 어렵다", "3. 너무 일찍 깬다")

# 답변 옵션 정의
opt1_code   <- c("opt1_1", "opt1_2", "opt1_3", "opt1_4", "opt1_5")
opt1_source <- c("없음", "약간", "중간", "심함", "매우<br>심함")
opt1_value  <- c(0, 1, 2, 3, 4)



generate_html <- function(q_code, q_source, opt_value, opt_source) {
  html_matrix <- sapply(q_code, function(code) {
    sapply(opt_value, function(value) {
      sprintf('<input type="radio" class="my-radio-button" id="%s-%d" name="%s" value="%d"/>', 
              code, value, code, value)
    }, USE.NAMES = FALSE)
  }, USE.NAMES = FALSE)
  html_matrix <- matrix(unlist(html_matrix), nrow = length(q_code), byrow = TRUE)
  rownames(html_matrix) <- q_source
  colnames(html_matrix) <- opt_source
  return(html_matrix)
}

# Use the function to generate your HTML matrix
q1m <- generate_html(q1_code,q1_source,opt1_value,opt1_source)




input_ids = c("compname", "birthyear", "name", exp1$variable, exp2$variable, q1_code, sleep2$variable)
input_ids

              
