ui <- fluidPage(
  tags$head(
    # tags start---------------
    tags$link(href="https://fonts.googleapis.com/css2?family=Gowun+Dodum&display=swap", rel="stylesheet"),
    tags$link(rel="stylesheet", type="text/css", href="styles.css"),
    tags$script(src="app.js")  # Link to the external JavaScript file
    # tags end---------------
  ),

h4("야간 종합 문진 표 [1차]", class="h3-center", style="margin-bottom:2px;font-weight: bold;"),
  
  #div(class = "table-header", "Input Form"),
  div(class = "table-like",
      fluidRow(class = "input-row inline",
               column(4, textInput(inputId = "compname", label = "  사업장명: ", placeholder = "00회사")),
               column(4, dateInput(inputId = "birthyear",label ="생년월일: ")),
               column(4, textInput(inputId = "name",label = "성명: ", placeholder = "성명"))
       # Add more fluidRow(s) for additional rows of inputs
  )),
  
  
  DT::dataTableOutput("tableOutput"),
  fluidRow(
    column(6, 
           style = "border-right: 2px solid #ddd; padding: 10px;",
           # 왼쪽-------
           h4(">> 노출 평가"),
           # Large text area
           textAreaInput("past_history", "과거에 앓은 질병이 있으면 적어 주십시오", "", 
                         rows = 5, placeholder = "내용을 입력하세요", width = "100%", height = "50px"), 
           lapply(1:c(length(exp1$variable)), function(i){list(radioButtons(inputId = exp1$variable[i],
                     label = HTML(exp1$question[i]),   choiceNames = exp1$source[i][[1]],
                     choiceValues = exp1$value[i][[1]],inline = TRUE))})
           # 왼쪽 ---------
           ), 
    
    column(6,
           # 오른쪽 --------------
           h5("9.야간근무에 대하여 다음과 같은 사항이 허용됩니까?", style="font-weight: bold;margin-left:5px;"),
           lapply(1:c(length(exp2$variable)), function(i){list(
             fluidRow(class="custom-row",
               column(6,h5(exp2$question[i], style="margin-left:10px; margin-bottom:2px;font-weight: bold;")), 
               column(6,radioButtons(inputId     = exp2$variable[i], label=NULL,
                                     choiceNames = exp2$source[i][[1]], 
                                     choiceValues= exp2$value[i][[1]], inline = TRUE))))
           }),
           hr(),
           h4(">> 수면 장애 (불면증지수)"),
           h5("1~3. 최근 2주간 다음 각 항목의 문제들이 얼마나 심한지 표시해 주십시오.", style="font-weight: bold;margin-left:5px;"),
           DT::dataTableOutput('input_table_sleep_1'), 
           br(),
           lapply(1:c(length(sleep2$variable)), function(i){list(radioButtons(inputId = sleep2$variable[i],
                                                              label = HTML(sleep2$question[i]),   choiceNames = sleep2$source[i][[1]],
                                                              choiceValues = sleep2$value[i][[1]],inline = TRUE))})
         
    )
    # 오른쪽 -------------- 
  ),
hr(),  
fluidRow(
column(8, 
  h4(">>답변하시느라 고생많으셨습니다, 아래 버튼을 눌러 저장해 주세요!", style="font-weight: bold;")
), 
column(4,
 class="action-button", actionButton("save1", "저장해주세요!")
)),
  DT::dataTableOutput('output_table_sleep_1'),
)
