server <- function(input, output, session) {
  #basic table
  
  
  # DataTable rendering
  output$input_table_sleep_1 <- DT::renderDataTable(
    q1m, escape = FALSE, selection = 'none', server = FALSE,
    options = list(dom = 't', paging = FALSE, ordering = FALSE), 
    class = 'cell-border stripe'
  )

  
  reactive_table <- reactive({
    te= function(code){
      value= input[[code]] %||% NA
      tibble(Variables=code, Values=value %>% as.character())
    }
    rbind(lapply(input_ids, te) %>% do.call(rbind, .), 
          tibble(Variables="StartTime", Values=as.character(Sys.time())))
  })
  
  
  output$output_table_sleep_1 <- renderDataTable(
    reactive_table(), escape = FALSE, selection = 'none', server = FALSE,
    options = list(dom = 't', paging = FALSE, ordering = FALSE)
  )
  
  observeEvent(input$save1, {
    current_data <- reactive_table()  # Assuming this is defined elsewhere in your server function
    
    if (any(is.na(current_data)) || any(current_data == "")) {
      # Show error shinyalert if data contains missing values
      shinyalert::shinyalert(
        title = "중요!!",
        text = "응답하지 않은 설문이 있습니다.",
        type = "error",
        closeOnEsc = TRUE,
        showConfirmButton = TRUE,
        confirmButtonText = "돌아가기"
      )
    } else {
      # Confirm save process with shinyalert
      shinyalert::shinyalert(
        title = "저장확인",
        text = "정말 저장하시겠습니까?",
        type = "info",
        showCancelButton = TRUE,
        showConfirmButton = TRUE,
        confirmButtonText = "저장 확인",
        closeOnEsc = TRUE,
        callbackR = function(x) {
          if (x) {  # If user confirms the save
            current_time <- format(Sys.time(), "%Y%m%d_%H%M%S")
            name_sanitized <- gsub("[^A-Za-z0-9]", "", input$name)
            filename <- sprintf("Outs/d_%s_%s_%s_d.rds", current_time, sample(1:10000, 1), input$birthyear)
            saveRDS(reactive_table(), filename)
            
            # Show success shinyalert
            shinyalert::shinyalert(
              title = "감사합니다.",
              text = "데이터가 잘 저장되었습니다!",
              type = "success",
              closeOnEsc = TRUE,
              showConfirmButton = TRUE,
              confirmButtonText = "확인"
            )
          }
        }
      )
    }
  })
}
