/*
 * This file contains code from "C++ Primer, Fourth Edition", by Stanley B.
 * Lippman, Jose Lajoie, and Barbara E. Moo, and is covered under the
 * copyright and warranty notices given in that book:
 * 
 * "Copyright (c) 2005 by Objectwrite, Inc., Jose Lajoie, and Barbara E. Moo."
 * 
 * 
 * "The authors and publisher have taken care in the preparation of this book,
 * but make no expressed or implied warranty of any kind and assume no
 * responsibility for errors or omissions. No liability is assumed for
 * incidental or consequential damages in connection with or arising out of the
 * use of the information or programs contained herein."
 * 
 * Permission is granted for this code to be used for educational purposes in
 * association with the book, given proper citation if and when posted or
 * reproduced.Any commercial use of this code requires the explicit written
 * permission of the publisher, Addison-Wesley Professional, a division of
 * Pearson Education, Inc. Send your request for permission, stating clearly
 * what code you would like to use, and in what specific way, to the following
 * address: 
 * 
 * 	Pearson Education, Inc.
 * 	Rights and Contracts Department
 * 	75 Arlington Street, Suite 300
 * 	Boston, MA 02216
 * 	Fax: (617) 848-7047
*/ 

#include <stdexcept>
using std::runtime_error;
#include <iostream>
#include "Sales_item.h"
using std::cin; using std::cout; using std::endl;

int main() 
{
    Sales_item item1, item2;

    while (cin >> item1 >> item2) {
        try {
            // execute code that will add the two Sales_items
            // if the addition fails, the code throws a runtime_error exception
            // first check that data is for the same item 
            if (!item1.same_isbn(item2))
                throw runtime_error("Data must refer to same ISBN");

            // ok, if we're still here the ISBNs are the same
            std::cout << item1 + item2 << std::endl;
        } catch (runtime_error err) {
            // remind the user that ISBN must match and prompt for another pair
            cout << err.what() 
                 << "\nTry Again?  Enter y or n" << endl;
            char c;
            cin >> c;
            if (cin && c == 'n')
                break;      // break out of the while loop
        }
    }
    return 0;   // indicate success
}
