/*
THINGS YET TO BE IMPLEMENTED
IN ORDER OF IMPORTANCE
#1-Automatcic FPS rate maintenance
#2-Axes that miss the player will continue moving indefinitely, populating memory with unuseful entities
#3-"Game over" screen
#4-Shiled or something alike
#5-Attack
*/


#define DEBUG_MODE

#include <vector>
#include <map>
#include <list>
#include <string>
#include <cstdlib>
#include <ctime>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include <allegro.h>

#include "grandeNappa.h"

struct Player
{
     int x, y;
     int width, height;
     int yVelocity;
     int oldYVelocity;
     bool standing;
     bool facing;
     bool doubleJump;
     bool canDoubleJump;
};

// Prototypes
class Entity;
bool BoxToPlayerCollision(int, int, int, int);
double Distance(int, int, int, int);

// Constants
const int gravity = 1;
const int jumpVelocity = 10;
const int walkVelocity = 6;
const int maxFallingSpeed = 16;
const int maxDeadEntities = 10;
const int trollSpeed = 4;
const int trollDieFrames = 30;
const int trollRechargeFrames = 75;
const double maxTrollDistance = 700.0;
const double axeSpeed = 6;
const int axeRotateSpeed = 8;
const int maxFPS = 60;
const int fpsTolerance = 4;
const int delayIncrease = 10;

// Global variables
std::vector<BITMAP *> tileSet;
std::map<int, BITMAP *> coinSprites;
//std::vector<Entity *> entities;
std::list<Entity *> entities;
std::vector<Entity *> deadEntities;
BITMAP *doubleBuffer;
Player player;
BITMAP *playerSprite;
BITMAP *heartSprite;
BITMAP *goldSprite;
BITMAP *trollSprite[2];
BITMAP *axeSprite;
BITMAP *gameOverScreen;
BITMAP *successScreen;
SAMPLE *ohYeahSound;
SAMPLE *ohShitSound;
SAMPLE *dieSound;
SAMPLE *ughSound;
SAMPLE *plimSound;
int scrollX = 0, scrollY;
int gold = 0;
int lifes = 5;
int gameState = 0;
int totalGold = 0;

// Some classes
class Entity
{
     public:
           bool alive; 
            
           virtual void Draw()
           {
           }
           
           virtual void Update()
           {
           }
};

class Coin : public Entity
{
     public:
           int value;
           int x, y;
            
           void Draw()
           {
                 draw_sprite(doubleBuffer, coinSprites[value], x - scrollX, y - scrollY);
           }
           
           void Update()
           {
                 if(BoxToPlayerCollision(x, y, coinSprites[value]->w, coinSprites[value]->h))
                 {
                       play_sample(plimSound, 255, 128, 1000, 0);
                       alive = false;
                       deadEntities.push_back(this);
                       gold += value;
                 }
           }
           
           Coin(int v, int _x, int _y)
           {
                 value = v;
                 alive = true;
                 x = _x - coinSprites[value]->w / 2;
                 y = _y - coinSprites[value]->h / 2;
                 totalGold += v;
           }
};

class Axe : public Entity
{
     private:
           fixed rotation;
           double x, y;
           double dx, dy;
     public:
           void Update()
           {
                 x += dx;
                 y += dy;
                 if(BoxToPlayerCollision(int(x) - (axeSprite->w / 2), int(y) - (axeSprite->h / 2), axeSprite->w, axeSprite->h))
                 {
                       alive = false;
                       deadEntities.push_back(this);
                       play_sample(ughSound, 255, 128, 1000, 0);
                       lifes--;
                 }
                 rotation = fixadd(rotation, itofix(axeRotateSpeed));
                 if(fixtoi(rotation) >= 256) rotation = itofix(0);
           }
           void Draw()
           {
                 rotate_sprite(doubleBuffer, axeSprite, int(x) - scrollX, int(y), rotation);
           }
           Axe(int _x, int _y)
           {
                 double __x, __y, length;
                 __x = double(player.x) - double(_x);
                 __y = double(player.y) - double(_y);
                 length = sqrt((__x * __x) + (__y * __y));
                 __x /= length;
                 __y /= length;
                 dx = __x * axeSpeed;
                 dy = __y * axeSpeed;
                 x = _x;
                 y = _y;
                 rotation = itofix(0);
                 alive = true;
           }
};

class Troll : public Entity
{
     private:
           int x, y;
           int frame;
           unsigned int timeAxe;
           int x1, x2;
           int dx;
     public:
           void Update()
           {
                 if(Distance(x, y, player.x, player.y) <= maxTrollDistance)
                 {
                       if(timeAxe >= trollDieFrames + trollRechargeFrames)
                       {
                             frame = 1;
                             play_sample(dieSound, 255, 128, 1000, 0);
                             timeAxe = 0;
                             entities.push_back(new Axe(x, y));
                       }
                       else
                       {
                             if(timeAxe >= trollDieFrames) frame = 0;
                       }
                       timeAxe++;
                 }
                 else
                 {
                       timeAxe = rand() % ((trollDieFrames + trollRechargeFrames) / 2);
                       frame = 0;
                 }
                 if(dx == 1)
                 {
                       if(x == x2)
                       {
                             dx = -1;
                             x -= trollSpeed;
                       }
                       else x += trollSpeed;
                 }
                 else
                 {
                       if(x == x1)
                       {
                             dx = 1;
                             x += trollSpeed;
                       }
                       else x -= trollSpeed;
                 }
           }
           
           void Draw()
           {
                 if(dx < 0) draw_sprite_h_flip(doubleBuffer, trollSprite[frame], x - scrollX, y);
                 else draw_sprite(doubleBuffer, trollSprite[frame], x - scrollX, y);
           }
           
           Troll(int _x1, int _x2, int _y)
           {
                 x1 = _x1;
                 x2 = _x2;
                 x = x1 + trollSpeed;
                 y = _y + (player.width / 2) - trollSprite[0]->h;
                 rand() % ((trollDieFrames + trollRechargeFrames) / 2);
                 frame = 0;
                 if(x2 < x1)
                 {
                       int temp = x1;
                       x1 = x2;
                       x2 = temp;
                 }
                 if((x2 - x1) % trollSpeed != 0) x2 += (x2 - x1) % trollSpeed;
                 dx = 1;
                 alive = true;
           }
};

// Setup functions
void InitAllegro()
{
     allegro_init();
     set_color_depth(32);
     set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
     install_keyboard();
     install_mouse();
     install_sound(DIGI_AUTODETECT, MIDI_NONE, 0);
     doubleBuffer = create_bitmap(640, 480);
}

void LoadTileSet()
{
     std::vector<std::string> temp;
     std::string ts = grandeNappa.tileSet;
     while(ts.size() != 0)
     {
           if(ts.find(",") != std::string::npos)
           {
                 temp.push_back(ts.substr(0, ts.find(",")));
                 ts = ts.substr(ts.find(",") + 1);
           }
           else
           {
                 if(ts.find(";") != std::string::npos)
                 {
                       temp.push_back(ts.substr(0, ts.find(";")));
                       ts = ts.substr(ts.find(";") + 1);
                 }
                 else
                 {
                       std::exit(-1);
                 }
           }
     }
     for(int i = 0; i < temp.size(); i++) tileSet.push_back(load_bitmap(temp[i].c_str(), 0));
     temp.clear();
}

// Map functions
unsigned int XYToIndex(unsigned int x, unsigned int y)
{
     return ((y * grandeNappa.width) + x);
}

void DrawMap(int _scrollX, int _scrollY)
{
     if(_scrollX < 0) _scrollX = 0;
     if(_scrollY < 0) _scrollY = 0;
     for(int x = _scrollX / grandeNappa.tileSize; (x < grandeNappa.width) & (x <= (_scrollX / grandeNappa.tileSize) + 20); x++)
     {
           for(int y = _scrollY / grandeNappa.tileSize; (y < grandeNappa.height) & (y <= (_scrollY / grandeNappa.tileSize) + 15); y++) 
           {
                 draw_sprite(doubleBuffer,                 
                 tileSet[grandeNappa.tiles[XYToIndex(x, y)]],
                 (x * grandeNappa.tileSize) - _scrollX,
                 (y * grandeNappa.tileSize) - _scrollY);
           }
     }
}

// Game logic
bool PointCollision(int x, int y, int blockType)
{
     return (grandeNappa.blocks[XYToIndex((x / 32), (y / 32))] == blockType);
}

bool BoxCollision(int x1, int y1, int x2, int y2, int blockType)
{
     if(x1 > x2)
     {
           int temp = x2;
           x2 = x1;
           x1 = temp;
     }
     if(y1 > y2)
     {
           int temp = y2;
           y2 = y1;
           y1 = temp;
     }
     for(int x = x1 - (x1 % grandeNappa.tileSize); x < x2; x += grandeNappa.tileSize)
     {
           for(int y = y1 - (y1 % grandeNappa.tileSize); y < y2; y += grandeNappa.tileSize)
           {
                 if(PointCollision(x, y, blockType)) return true;
           }
           if(PointCollision(x, y2, blockType)) return true;
     }
     if(PointCollision(x2, y2, blockType)) return true;
     return false;
}

bool BoxToBoxCollision(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2)
{
     if(x1 + w1 < x2) return false;
     if(x2 + w2 < x1) return false;
     if(y1 + h1 < y2) return false;
     if(y2 + h2 < y1) return false;
     return true;
}

bool BoxToPlayerCollision(int x, int y, int w, int h)
{
     return BoxToBoxCollision(x, y, w, h, player.x, player.y, player.width, player.height);
}

// Math!!!! I LOVE MATH! MATH IS FREAKIN' AWESOME (by the way its 04:22am)
double Distance(int x1, int y1, int x2, int y2)
{
     double a = std::fabs(double(x1 - x2)) * std::fabs(double(x1 - x2));
     double b = std::fabs(double(y1 - y2)) * std::fabs(double(y1 - y2));
     return std::sqrt(a + b);
}

// Whateva
void DrawLife()     // If you call that a livin'
{
     for(int x = 16; x < 16 + lifes * 32; x += 32) draw_sprite(doubleBuffer, heartSprite, x, 16);
}

// Game logic
void DrawEntities()
{
     std::list<Entity *>::iterator i;
     for(i = entities.begin(); i != entities.end(); i++)
     {
           if((*i)->alive) (*i)->Draw();
     }
}

void UpdateEntities()
{
     std::list<Entity *>::iterator i;
     for(i = entities.begin(); i != entities.end(); i++)
     {
           if((*i)->alive) (*i)->Update();
     }
}

void CleanEntities()
{
     for(int i = 0; i < deadEntities.size(); i++) entities.remove(deadEntities[i]);
     deadEntities.clear();
}

bool PlayerCollision(Player p, int blockType)
{
     return BoxCollision(p.x, p.y, p.x + p.width - 1, p.y + p.height - 1, blockType);
}

void MovePlayer(bool left, bool right, bool up, bool upReleased, bool down)
{
     Player newPlayer = player;
     if(left)
     {
           newPlayer.facing = true;
           newPlayer.x -= walkVelocity;
           if(PlayerCollision(newPlayer, SOLID_BLOCK)) newPlayer.x += grandeNappa.tileSize - (newPlayer.x % grandeNappa.tileSize);           
     }
     if(right)
     {
           newPlayer.facing = false;
           newPlayer.x += walkVelocity;
           if(PlayerCollision(newPlayer, SOLID_BLOCK))
           {
                 newPlayer.x -= (newPlayer.x + newPlayer.width) % grandeNappa.tileSize;  
           }
     }
     if(newPlayer.standing)
     {
           Player temp = newPlayer;
           temp.yVelocity += gravity;
           temp.y += temp.yVelocity;
           if(!PlayerCollision(temp, SOLID_BLOCK)) newPlayer.standing = false;
     }
     if(newPlayer.standing == false)
     {
           newPlayer.yVelocity += gravity;
           if(newPlayer.yVelocity > maxFallingSpeed) newPlayer.yVelocity = maxFallingSpeed;
     }
     if(up)
     {
           if(newPlayer.standing)
           {
                 newPlayer.yVelocity = -jumpVelocity;
                 newPlayer.standing = false;
           }
           else
           {
                 while(newPlayer.doubleJump)
                 {
                       if(!newPlayer.canDoubleJump) break;
                       if(upReleased)
                       {
                             newPlayer.yVelocity = -jumpVelocity;
                             newPlayer.doubleJump = false;
                       }
                       else break;
                 }
           }
     }
     if(newPlayer.yVelocity != 0)
     {
           Player temp = newPlayer;
           temp.y += temp.yVelocity;
           if(temp.yVelocity < 0)
           {
                 if(PlayerCollision(temp, SOLID_BLOCK))
                 {
                       //newPlayer.y += grandeNappa.tileSize - (newPlayer.y % grandeNappa.tileSize);
                       newPlayer.yVelocity = 0;
                 }
           }
           if(temp.yVelocity > 0)
           {
                 if(PlayerCollision(temp, SOLID_BLOCK))
                 {
                       newPlayer.y = temp.y - ((temp.y + temp.height) % grandeNappa.tileSize);
                       newPlayer.yVelocity = 0;
                       newPlayer.standing = true;
                       newPlayer.doubleJump = true;
                 }
           }           
     }
     newPlayer.y += newPlayer.yVelocity;
     newPlayer.oldYVelocity = player.yVelocity;
     player = newPlayer;
}

void UpdateCamera()
{
     if(player.x - scrollX < 214) scrollX = player.x - (640 / 3);
     if(player.x - scrollX > 418) scrollX = player.x - 418;
     if(scrollX < 0) scrollX = 0;
}

void GameOver(bool success)
{
     if(success)
     {
           draw_sprite(screen, successScreen, 0, 0);
           play_sample(ohYeahSound, 255, 128, 1000, 0);
     }
     else
     {
           draw_sprite(screen, gameOverScreen, 0, 0);
           play_sample(ohShitSound, 255, 128, 1000, 0);
     }
     while(!key[KEY_ESC])
     {
     }
}

void GameLoop()
{
     bool up;
     unsigned int fpsTime = clock();
     int fps;
     int frames = 0;
     int delay = 0;
     while(!key[KEY_ESC])
     {
           if(lifes < 0)
           {
                 GameOver(false);
                 break;
           }
           if(gold >= totalGold)
           {
                 GameOver(true);
                 break;
           }
           #ifdef DEBUG_MODE
           if(mouse_b & 1) player.x = mouse_x + scrollX;
           if(mouse_b & 1) player.y = mouse_y + scrollY;
           #endif
           MovePlayer(key[KEY_LEFT], key[KEY_RIGHT], key[KEY_UP], (!up) & (key[KEY_UP]), key[KEY_DOWN]);
           up = key[KEY_UP];
           UpdateCamera();
           UpdateEntities();
           if(deadEntities.size() > maxDeadEntities) CleanEntities();
           clear(doubleBuffer);           
           DrawMap(scrollX, 0);
           //rect(doubleBuffer, player.x, player.y, player.x + player.width - 1, player.y + player.height - 1, 0);
           player.facing = !player.facing;
           if(player.facing) draw_sprite(doubleBuffer, playerSprite, player.x - scrollX, player.y);
           else draw_sprite_h_flip(doubleBuffer, playerSprite, player.x - scrollX, player.y);
           player.facing = !player.facing;
           DrawEntities();
           DrawLife();
           draw_sprite(doubleBuffer, goldSprite, 480, 16);
           textprintf_ex(doubleBuffer, font, 480 + 52 + 8, 16 + (52 / 2) - 4, (227 << 16) + (165 << 8) + 59, -1, "%d", gold);
           #ifdef DEBUG_MODE
           textprintf_ex(doubleBuffer, font, 320, 240, 0, -1, "X%dY%d", player.x + (player.width / 2), player.y + (player.height / 2));
           textprintf_ex(doubleBuffer, font, 320, 0, 0, -1, "FPS:%dDelay:%d", fps, delay);
           #endif
           draw_sprite(screen, doubleBuffer, 0, 0);
           if(clock() - fpsTime >= CLOCKS_PER_SEC)
           {
                 fps = frames;
                 frames = 0;
                 fpsTime = clock();
                 if(fps > maxFPS + fpsTolerance) delay += delayIncrease;
                 if(fps < maxFPS - fpsTolerance)
                 {
                       if(delay != 0) delay -= delayIncrease;
                 }
           }           
           else frames++;
           rest(delay);
     }
}

// Main
int main(int argc, char **argv)
{
     srand(time(0));
     InitAllegro();
     LoadTileSet();
     player.width = 40;
     player.height = 64;
     player.x = 320;
     player.y = 320 + 32;
     player.yVelocity = 0;
     player.standing = false;
     player.doubleJump = true;
     player.canDoubleJump = true;
     lifes = 5;
     playerSprite = load_bitmap("player_char.bmp", 0);
     heartSprite = load_bitmap("heart.bmp", 0);
     goldSprite = load_bitmap("gold.bmp", 0);
     axeSprite = load_bitmap("Machado.bmp", 0);
     gameOverScreen = load_bitmap("gameover.bmp", 0);
     successScreen = load_bitmap("success.bmp", 0);
     trollSprite[0] = load_bitmap("Troll.bmp", 0);
     trollSprite[1] = load_bitmap("TrollACT.bmp", 0);
     dieSound = load_wav("die.wav");
     ughSound = load_wav("ugh.wav");
     plimSound = load_wav("plim.wav");
     ohYeahSound = load_wav("ohyeah.wav");
     ohShitSound = load_wav("ohshit.wav");
     coinSprites[1] = load_bitmap("coin1.bmp", 0);
     coinSprites[25] = load_bitmap("coin25.bmp", 0);
     coinSprites[50] = load_bitmap("coin50.bmp", 0);
     coinSprites[100] = load_bitmap("coin100.bmp", 0);
/*
Troll positions
x1   y      x2
1396-416	1684
1684-416	1978
92-96		476
1204-416	1324
2560-416	2668
2740-416	2860
*/
     entities.push_back(new Troll(1396,1684 - 48,416));
     entities.push_back(new Troll(1684,1978 - 48,416));
     entities.push_back(new Troll(92,476 - 48,96));
     entities.push_back(new Troll(1204,1324 - 48,416));
     entities.push_back(new Troll(2560,2668 - 48,416));
     entities.push_back(new Troll(2740,2860 - 48,416));
/*
Gold positions:
1
====
52-416
500-384
1424-224
1556-224
1682-224       
====
25
====
698-416
812-416
====
50
====
1078-352
2134-416
2512-342
2710-342
2890
====
100
====
1946-256
3118-416
====
*/
     entities.push_back(new Coin(1, 52, 416));
     entities.push_back(new Coin(1,500,384));
     entities.push_back(new Coin(1,1424,224));
     entities.push_back(new Coin(1,1556,224));
     entities.push_back(new Coin(1,1682,224));
     entities.push_back(new Coin(25,698,416));
     entities.push_back(new Coin(25,812,416));
     entities.push_back(new Coin(50,1078,352));
     entities.push_back(new Coin(50,2134,416));
     entities.push_back(new Coin(50,2512,342));
     entities.push_back(new Coin(50,2710,342));
     entities.push_back(new Coin(50,2890,342));
     entities.push_back(new Coin(100,1946,256));
     entities.push_back(new Coin(100,3118,416));
     rest(1000);
     GameLoop();
     return 0;
}
END_OF_MAIN();
