segment code 

index_offsFn:		equ		0x10	;//Offset of first file name
index_numFiles:		equ		28		;//How many files - 28
index_lenFn:		equ		0x50	;//Length of file name

index_offsRes:		equ		0x8D4	;//Offset of first resource name
index_lenRes:		equ		0x16	;//Length of resource including name
index_lenResName:	equ		0xC		;//Length of resource name only

index_idxFileByte:	equ		index_lenResName+0
index_idxAlgoByte:	equ		index_lenResName+1
index_idxOffset:	equ		index_lenResName+2
index_idxLen1:		equ		index_lenResName+6
index_idxLen2:		equ		index_lenResName+8

..start: 
	push	ds
	
	mov		ax,data 
	mov		ds,ax 
	
	pop		ax
	mov		[PSP],ax
	
	mov		ax,stack 
	mov		ss,ax 
	mov		sp,stacktop

	;Copy from PSP command line params to data:argv
	mov		ds,[PSP]
	push	data
	pop		es
	mov		si,81h
	mov		di,argv
	.loop:
	lodsb
	cmp		al,0xD
	jne		.notyet
	mov		al,0	;null terminator
	.notyet:
	stosb
	jne		.loop
	
	;Restore data segment
	mov		ax,data
	mov 	ds,ax
	
	;Parse command line arguments
	mov		si,argv
	mov		di,resource
	mov		bx,resourceMax
	call	parseArgv
	mov		di,strOutFilename
	mov		bx,strOutFilenameMax
	call	parseArgv
	;Check strOutFilename
	mov		al,[strOutFilename]
	or		al,al
	jnz		.outok
	.usage:
		mov		ax,strUsage
		call	printASCIIZ
		jmp		die
	.outok:
	;Check resource
	mov		al,[resource]
	or		al,al
	jz		.usage
	
	;Change zeroes for spaces in resource name
	mov		cx,index_lenResName
	mov		si,resource
	mov		di,resource
	.spaceloop:
		lodsb
		cmp		al,0
		jne		.notnull
			mov		al,' '
		.notnull:
		stosb
		loop		.spaceloop
	
	;Print that we are ready to read _INDEX
	mov		ax,strReadIndex
	call	printASCIIZ
	
	;Open _INDEX
	mov		ax,str_INDEX
	mov		bx,strFilename
	call	strcpy
	mov		ax,3d00h
	mov		dx,strFilename
	int		21h
	jnc		noerror
	
	;Print error message
	mov		dx,shit
	mov		ah,9 
	int		0x21
	jmp		die
	
noerror:
	;Store file handle
	mov		[fd],ax
	
	;Read file
	mov		cx,0xFFFF		;65535 bytes
	mov		bx,[fd]			;File handle
	mov 	ax,bufIndex
	mov		ds,ax			;to bufIndex...
	mov		dx,00h			;to bufIndex:0000
	mov		ah,3Fh
	int		21h
	jnc		noerror2
	
	;Print error message
	mov		dx,shit2
	mov		ah,9 
	int		0x21
	jmp		die
	
noerror2:
	;Restore data segment
	mov		bx,data
	mov 	ds,bx
	
	;Save size of bufIndex
	mov		[sizIndex],ax
	
	;Close file
	mov		bx,[fd]
	mov		ah,3Eh
	int		21h
	
	;Print number of bytes read
	mov		dx,strNumBytes
	mov		ah,9 
	int		0x21
	mov		ax,[sizIndex]
	call	printDigits
	call	printNewLine
	
	;Look for resource
	mov		cx,0
	mov		bx,index_offsRes
	mov		ax,bufIndex
	mov		es,ax
	.resloop:
		mov	si,bx
		mov	di,0
		.charloop:
			mov	dl,[di+resource]
			cmp dl,[es:si]
			jne .notequal
				inc si
				inc di
				cmp di,index_lenResName
				je .resloop_end
				jmp .charloop
		.notequal:
		inc	cx
		add bx,index_lenRes
		cmp bx,[sizIndex]
		jb	.resloop
		mov ax,1
		cmp ax,0;Set ZF to false
	.resloop_end:
	je .found
		;Print error message
		mov		dx,strResNotFound
		mov		ah,9 
		int		0x21
		jmp		die
	.found:
	mov		[resNumber],cx
	mov		[resOffset],cx
	;Offset is left at BX
	
	;Print offset
	push	bx
	mov		dx,strResFound
	mov		ah,9 
	int		0x21
	mov		ax,bx
	call	printDigits
	call 	printNewLine
	pop		bx
	
	;Copy resData
	cld
	mov		cx,index_lenRes
	mov		ax,bufIndex
	mov		ds,ax
	mov		ax,data
	mov		es,ax
	mov		si,bx
	mov		di,resData
	;copy CX bytes from ds:si to es:di
	rep		movsb
	;restore DS
	mov		ax,data
	mov		ds,ax
	
	;Print resData
	mov		ax,strData
	call	printASCIIZ
	mov		si,resData
	.printres_loop:
		lodsb
		call	printHexByte
		call	printSpace
		cmp		si,resData+index_lenRes
		jb		.printres_loop
	call printNewLine
	
	;Copy filename
	mov		ah,0
	mov		al,[resData+index_idxFileByte]
	dec		al
	mov		bl,index_lenFn
	mul		bl
	add		ax,index_offsFn
	cld
	mov		si,ax
	mov		cx,8
	mov		ax,bufIndex
	mov		ds,ax
	mov		ax,data
	mov		es,ax
	mov		di,strFilename
	rep		movsb
	mov		ax,data
	mov		ds,ax
	
	;Print filename
	mov		ax,strFile
	call	printASCIIZ
	mov		ax,strFilename
	call	printASCIIZ
	call	printNewLine
	
	;Open file
	mov		ax,3d00h
	mov		dx,strFilename
	int		21h
	jnc		.noerror
		;Print error message
		push	ax
		mov		ax,strErrOpen
		call	printASCIIZ
		pop		ax
		call	printHexByte
		jmp		die
	.noerror:
	
	;Store file handle
	mov		[fd],ax
	
	;FSEEK
	mov		cx,[resData+index_idxOffset+2]
	mov		dx,[resData+index_idxOffset+0]
	mov		al,00h
	mov		ah,42h
	mov		bx,[fd]
	int		21h
	jnc		.seeked
		mov		ax,strCantSeek
		call	printASCIIZ
		jmp		die
	.seeked:
	
	;Read file
	mov		cx,word [resData+index_idxLen1+0]
	mov		bx,[fd]			;File handle
	mov 	ax,bufRes
	mov		ds,ax			;to bufRes...
	mov		dx,00h			;to bufRes:0000
	mov		ah,3Fh
	int		21h
	jnc		.noerror2
		;Print error message
		mov		dx,shit2
		mov		ah,9 
		int		0x21
		jmp		die
	.noerror2:
	;Restore data segment
	mov		bx,data
	mov 	ds,bx
	
	;Check bytes read
	cmp		ax,word [resData+index_idxLen1+0]
	je		.lengood
		mov		ax,strLenBad
		call	printASCIIZ
		jmp		die
	.lengood:

printbufres:
	;Print a few bufRes bytes
	mov		ax,strResData
	call	printASCIIZ
	mov		ax,bufRes
	mov		ds,ax
	mov		si,0
	mov		ax,0
	.printres_loop:
		lodsb
		call	printHexByte
		call	printSpace
		cmp		si,0x10
		jb		.printres_loop
	call printNewLine
	mov		ax,data
	mov		ds,ax
	
	;Close file
	mov		bx,[fd]
	mov		ah,3Eh
	int		21h
	
	mov		ax,strCurrSeg
	call	printASCIIZ
	mov		ax,cs
	call	printHexWord
	call	printNewLine
	mov		ax,strDecompSeg
	call	printASCIIZ
	mov		ax,seg026
	call	printHexWord
	call	printNewLine
	mov		ax,strCallPos
	call	printASCIIZ
	mov		ax,callpos
	call	printHexWord
	call	printNewLine
	
	;Decompress
	;mov 	ax,strDecompressing
	;call	printASCIIZ
	;Wait for a key press
	;.wait:
	;	mov		ah,0Bh
	;	int		21h
	;	cmp		al,00h
	;	je .wait
	;mov 	ax,strGo
	;call	printASCIIZ
	;Set up regs
	mov		al,[resData+index_idxAlgoByte]	;AL = bmapdeaduk.misteryByte (AX is simply left with highbyte of 86F6)
	mov		bx,[resData+index_idxLen2]		;BX = bmapdeaduk.word2 (decompressed length?)
	mov		cx,[resData+index_idxLen1]		;CX = bmapdeaduk.length/word1
	mov		si,0							;SI = 0
	mov		di,0							;DI = 0
	push	ax
	mov		ax,bufDecompressed
	mov		es,ax							;ES = 86F6 (dst?)
	mov		ax,bufRes
	mov		ds,ax							;DS = 726F (src?)
	pop		ax
callpos:
	jmp far sub_47F07
decompressed:
	
	mov		ax,data
	mov		ds,ax
	mov		ax,strDecompSuccess
	call	printASCIIZ
	
	;Create output file
	mov		ax,strOutFilename
	mov		bx,strFilename
	call	strcpy
	mov		ah,3Ch
	mov		cx,1<<5	;Archive
	mov		dx,strFilename
	int		21h
	jnc		.filecreated
		mov	ax,strErrCreate
		.errprint:
		call printASCIIZ
		mov	ax,strFilename
		call printASCIIZ
		call printNewLine
		jmp die
	.filecreated:
	;Now open it
	mov		ah,3Dh
	mov		al,0b001	;Write
	mov		dx,strFilename
	int		21h
	jnc		.opened
		mov	ax,strErrOpenOut
		jmp	.errprint
	.opened:
	mov		[fd],ax
	;Write to file
	mov		bx,[fd]
	mov		cx,[resData+index_idxLen2]
	mov		dx,0
	mov		ax,bufDecompressed
	mov		ds,ax
	mov		ah,40h
	int		21h
	jnc		.written
		push	ax
		mov		ax,data
		mov		ds,ax
		mov		ax,strErrorCode
		call 	printASCIIZ
		pop		ax
		call	printHexWord
		call	printNewLine
		mov	ax,strErrWrite
		jmp .errprint
	.written:
	
	;Print success
	mov		ax,data
	mov		ds,ax
	mov		ax,strWritten
	call 	printASCIIZ
	mov		ax,strFilename
	call	printASCIIZ
	
die:
	;Terminate program
	mov		ax, 4c00h
	int		21h

;DS:SI=source
;ES:DI=dest
;BX=max value of dest	
parseArgv:
	;Clear dest memory
	push	di
	mov		al,0
	.clearloop:
		cmp		di,bx
		jae		.cleared
			stosb	
		jmp .clearloop
	.cleared:
	pop		di
	;Always leave space for null terminator
	dec bx
	;actually parse
	.loop:
		;Load byte
		lodsb
		;Check for null terminator
		cmp		al,0
		je		.loop2
		;Check for delimiter
		cmp		al,' '
		je		.loop
	.loop2:
		;Check for space left
		cmp		di,bx
		jae		.truncate
			stosb	
		.truncate:
		;Check for null terminator
		cmp		al,0
		je		.null
		lodsb
		;Check for delimiter
		cmp		al,' '
		jne		.loop2
	ret
	.null:
	;Leave si at null terminator
	dec		si
	ret
	
;strcpy from AX to BX
strcpy:
	push	es
	push	si
	push	di
	push	cx
	mov		cx,ds
	mov		es,cx
	mov		si,ax
	mov		di,bx
	.loop:
		lodsb
		cmp al,0
		stosb
		jne .loop
	pop		cx
	pop		di
	pop		si
	pop		es
	ret
	
printASCIIZ:
	push	si
	push	dx
	mov		si,ax
	.loop:
		lodsb
		cmp al,0
		je .end
			mov		dl,al
			mov 	ah,02h
			int 	21h
			jmp .loop
	.end:
	pop		dx
	pop		si
	ret
	
printSpace:
	mov 	dl,' '
	mov 	ah,02h
	int 	21h
	ret
	
printNewLine:
	mov 	dl,13
	mov 	ah,02h
	int 	21h
	mov 	dl,10
	mov 	ah,02h
	int 	21h
	ret

printHexWord:
	push	ax
	shr		ax,8
	call printHexByte
	pop		ax
printHexByte:
	push	ax
	shr		ax,4
	call .printHexDigit
	pop		ax
	.printHexDigit:
		and		ax,0xF
		add		ax,'0'
		cmp		ax,'9'+1
		jb		.less
			sub	ax,'9'+1
			add ax,'A'
		.less:
		mov 	dl,al
		mov 	ah,02h
		int 	21h
		ret
	
printDigits:
	call itoa
	add byte [strDigits+0],'0'
	add byte [strDigits+1],'0'
	add byte [strDigits+2],'0'
	add byte [strDigits+3],'0'
	add byte [strDigits+4],'0'
	add byte [strDigits+5],'0'
	mov		dx,strDigits
	mov		ah,9 
	int		0x21
	sub byte [strDigits+0],'0'
	sub byte [strDigits+1],'0'
	sub byte [strDigits+2],'0'
	sub byte [strDigits+3],'0'
	sub byte [strDigits+4],'0'
	sub byte [strDigits+5],'0'
	ret
	
itoa:
	;Clear digits
	mov si,0
	.clear_loop:
		mov byte [strDigits+si],0
		inc si
		cmp si,6
		jl .clear_loop
	
	;Use BH as bit counter
	mov bh,0
	
	;Loop over all 16bits of AX
	.bitloop:
		;Rotate AX left, if the eaten leftmost bit was 1, add 1 to the decimal
		rol ax,1
		jnc .nocarry
			inc byte [strDigits+5]
	.nocarry:
		;Increment bitcounter
		inc bh
		cmp bh,16
		jge .bitloop_end
			;Perform this for every bit of AX but the last:
			;Double the decimal
			mov si,0
			.sub4loop:
				shl byte [strDigits+si],1
				inc si
				cmp si,6
				jl .sub4loop
			call .sub3
			jmp .bitloop
	.bitloop_end:
	;No call needed - just fall through
	;call .sub3
	;ret
	.sub3:
	;Loop over every digit
	mov si,5
	.sub3loop:
		;If >10...
		cmp byte [strDigits+si],10
		jl .below10
			;...subtract 10 and increment next digit (i.e. carry over)
			mov bl,byte [strDigits+si]
			sub bl,10
			mov byte [strDigits+si],bl
			inc byte [strDigits-1+si]
	.below10:
		dec si
		jnz .sub3loop
	ret


	
%include "b17.asm"
	
segment bufIndex
	resb 0xFFF0
segment bufRes
	resb 0xFFF0
segment bufDecompressed
	resb 0xFFF0
segment data
hello:
	db	'hello, world', 13, 10, '$'
shit:
	db	'cant open shit file', 13, 10, '$'
shit2:
	db	'cant READ shit file', 13, 10, '$'
strResNotFound:
	db	'cant find fucking resource', 13, 10, '$'
strResFound:
	db	'Found resource at offset:$'
strNumBytes:
	db 'Number of bytes read:$'
	;db '$'
strData:			db 'Data:',0
strFile:			db 'File:',0
strCantSeek:		db 'Cant fseek, fuck',0
strLenBad:			db 'Incorrect bytes read, fuck',0
strErrOpen:			db 'Error opening resource file:',0
strResData:			db 'First 16 bytes of resource:',13,10,0
strDecompressing:	db 'Press any key to begin decompression...',13,10,0
strGo:				db 'GO!',13,10,0
strCurrSeg:			db 'Current code segment is:        ',0
strDecompSeg:		db 'Decompressor code segment is:   ',0
strCallPos:			db 'Decompressor call position is:  ',0
strDecompSuccess:	db 'Successfully decompressed?',13,10,0
strOutFilename:		resb 8+1+3+1
strOutFilenameMax:
strErrCreate:		db 'Cant create fucking file: ',0
strErrOpenOut:		db 'Cant open the fucking output file: ',0
strErrWrite:		db 'Shat itself writing to file: ',0
strErrorCode:		db 'Error code: ',0
strWritten:			db 'Written to file: ',0
strReadIndex:		db 'Reading index...',13,10,0
strUsage:			db 'Usage:',13,10,'    xtract [resource name] [output file]',0
str_INDEX:			db '_INDEX',0
PSP:
	dw 0
fd:
	dw 0
sizIndex:
	dw 0
resource:
	resb index_lenResName+1
resourceMax:
strDigits:
	db 0,0,0,0,0,0,'$'
strFilename:
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0
resNumber:	dw	0
resOffset:	dw	0
resData:
	resb index_lenRes
argv:
	resb 256
segment stack stack 
	resb 0xFFF0
stacktop:
