use16

segment code 

fracbits:		equ		15

org 100h
	;Find a seg 64k above our own
	mov		bp,cs
	lea		ax,[bp+4096]
	mov		es,ax
	
	;Enter mode 13h
	mov		ax,13h
	int		10h
	
	;Prepare to palette upload
	mov		dx,3C8h
	xor		al,al
	out		dx,al
	
	xor		ebx,ebx
	.colloop:
		mov		si,palCoeffs		;Move SI to A for Red
		inc		ebx
			.rgbloop:
			;Calc	A*x²
			mov		eax,ebx			;Load X
			imul	ebx				;Calc X^2
			imul	dword [si]		;Calc A*X^2
			push	eax				;Push result
			
			;Calc	B*x
			mov		eax,ebx			;Load X
			imul	dword [si+4]	;Calc B*X
			
			;Calc A*x²+B*x+C
			add		eax,dword [si+8];Add C
			pop		ecx
			add		eax, ecx		;Add A*X^2
			
			shr		eax,fracbits	;Discard fractional part of fixed point
			
			add		si,12			;Move SI to next A coeff
			
			mov		dx,3C9h
			out		dx,al			;Upload colour component to VGA
			
			cmp		si,palCoeffsEnd	;If all coeffs were used then this colour is done
			jb		.rgbloop
		
		or		bh,bh
		jz		.colloop
	
	.frame:
	;Fill an invisible line below the screen with random values 128...255
	mov		di,320*200
	push	di
	mov		cx,320
	.fill:
		call	randomByte
		or		al,1<<7
		stosb
		loop	.fill
	
	;Set DS to point to the double buffer as well
	push	es
	pop		ds
	
	xor		di,di
	pop		cx			;CX=320*200
	.pixel:
		;Update pixels in a "random" order
		add		di,51051
		cmp		di,320*200
		jnb		.pixel
		
		;Find address of a pixel a line below, and maybe 1 pixel to either side
		call	randomByte
		mov		dl,3
		mul		dl
		shr		ax,8
		lea		si,[di+319]
		add		si,ax
		
		;Get pixel, cool it down by a 0...1 random value
		call	randomByte
		mov		dl,al
		lodsb
		and		dx,15
		sub		dx,4
		sub		ax,dx
		jns		.notneg
			xor		al,al
		.notneg:
		
		;Store new pixel
		stosb
		loop 	.pixel
	
	;Transfer double buffer segment to VGA memory
	push	0xA000
	pop		es			;ES=VGA
	xor		si,si
	xor		di,di
	mov		cx,320*200
	cld
	rep		movsb
	push	ds			
	pop		es			;ES=double buffer
	
	;Check for keypress
	mov		ah,0Bh
	int		21h
	or		al,al
	jz		.frame
die:
	;Restore text mode
	mov		ax,03h
	int		10h
	;Quit
	ret

randomByte:
	;RNG subroutine of Lehmer kind
	mov		eax,851723965
	mul		dword [cs:rng]
	mov		[cs:rng],eax
	shr		eax,24
	ret

	palCoeffs:
		;	;A		B		C
		dd	-31,15116,	72876	;R
		dd	27,	103,	251127	;G
		dd	28,	-2835,	291624	;B
	palCoeffsEnd:
	rng:			dd	1

