function Player(n){
	this.n = n;
	this.color = n + 2;
	this.alive = false;
	this.angle = 0;
	this.health = 10;
	
	this.Update = function(){
		if(!this.alive){
			if(buttons[this.n] & BUTTON_START)
			{
				this.alive = true;
				this.x = [80, 80, 240, 240][this.n];
				this.y = [50, 150, 50, 150][this.n];
				this.health = 10;
			}
			return;
		}
		
		this.x += dpad[this.n].x;
		this.y += dpad[this.n].y;
		if(Math.abs(dpad[this.n].x) + Math.abs(dpad[this.n].y) != 0) this.angle = Math.atan2(dpad[this.n].y, dpad[this.n].x);
		
		if(buttons[this.n] & (~oldButtons[this.n]) & BUTTON_A) bullets.push(new Bullet(this));
		
		if(this.health <= 0) this.alive = false;
	}
	
	this.Draw = function(){
		if(!this.alive){
			TextOut(screen, "Player " + this.n + " press start", [0, 0, 160, 160][this.n], [0, 192, 0, 192][this.n], this.color);
		}
		else{
			RectFill(screen, this.x - this.health, this.y - this.health, this.x + this.health, this.y + this.health, this.color);
		}
	}
}

function Bullet(p){
	this.x = p.x;
	this.y = p.y;
	this.color = p.color;
	this.angle = p.angle;
	this.alive = true;
	
	this.Update = function(){
		this.x += Math.cos(this.angle) * Bullet.speed;
		this.y += Math.sin(this.angle) * Bullet.speed;
		
		for(var i = 0; i < players.length; i++){
			var pl = players[i];
			if(pl.color == this.color) continue;
			if((Math.abs(pl.x - this.x) < Bullet.size + pl.health) && (Math.abs(pl.y - this.y) < Bullet.size + pl.health)){
				pl.health -= Bullet.damage;
				this.alive = false;
			}
		}
		if((Math.abs((screen.w / 2) - this.x) > Bullet.size + (screen.w / 2)) || (Math.abs((screen.h / 2) - this.y) > Bullet.size + (screen.h / 2))) this.alive = false;
	}
	
	this.Draw = function(){
		CircleFill(screen, this.x, this.y, Bullet.size, this.color);
	}
}
Bullet.size = 3;
Bullet.damage = 3;
Bullet.speed = 5;

players = [];
bullets = [];
for(var i = 0; i < 4; i++) players.push(new Player(i));

oldButtons = [0, 0, 0, 0];

function Loop(){
	ClearToColor(screen, 1);
	
	for(var i = 0; i < 4; i++){
		players[i].Update();
		players[i].Draw();
	}
	
	for(var i = 0; i < bullets.length; i++){
		bullets[i].Update();
		bullets[i].Draw();
	}
	bullets = bullets.filter(function(e){return e.alive});
	
	oldButtons = buttons.slice();
}