function LoadStage(filename){
	var json = ReadTextFile(filename);
	if(json) json = JSON.parse(json);
	else return false;
	
	function CreateFilter(name){
		return function(l){
			return l.name == name;
		}
	}
	
	var wallLayer = json.layers.filter(CreateFilter("Walls"))[0];
	var pickLayer = json.layers.filter(CreateFilter("Pickups"))[0];
	var spawnLayer = json.layers.filter(CreateFilter("Spawns"))[0];
	if(!wallLayer || !pickLayer || !spawnLayer) return false;
	
	mapWalls = {
		width: json.width,
		height: json.height,
		data: new Uint16Array(wallLayer.data)
	};
	pickupsData = pickLayer.data;
	numberOfDots = 0;
	for(var i = 0; i < pickupsData.length; i++){
		if(pickupsData[i]) numberOfDots++;
	}
	mapPickups = {
		width: json.width,
		height: json.height
	};
	
	spawns = {};
	var spawnNames = ["PacMan", "Blinky", "Pinky", "Inky", "Clyde"];
	for(var i = 0; i < spawnNames.length; i++){
		var s = spawnLayer.objects.filter(CreateFilter(spawnNames[i]))[0];
		if(!s) return false;
		spawns[spawnNames[i]] = {
			x: s.x + s.width / 2,
			y: s.y + s.height / 2
		};
	}
	
	pickupProperties = json.tilesets[0].tileproperties;
	
	return true;
}

function SpawnGhost(n){
	var g = ghosts[n];
	var s = spawns[g.name];
	g.x = s.x;
	g.y = s.y;
	g.dir = s.dir;
	g.live = true;
	g.housed = s.housed;
}

if(!LoadStage("stage.json")) Cout("error");
tileset = CreateSpriteSheet(LoadBitmap("stage_tileset.pcx"), 8, 8);
ghostSheet = CreateSpriteSheet(LoadBitmap("ghosts.pcx"), 16, 16);
pacSheet = CreateSpriteSheet(LoadBitmap("pacman.pcx"), 16, 16);
field = CreateBitmap(28 * 8, 31 * 8);

spawns.Blinky.dir = 1;
spawns.Inky.dir = 0;
spawns.Pinky.dir = 3;
spawns.Clyde.dir = 2;
spawns.Blinky.housed = false;
spawns.Inky.housed = true;
spawns.Pinky.housed = true;
spawns.Clyde.housed = true;
ghosts = [{name: "Blinky", frame0: 0}, {name: "Inky", frame0: 16}, {name: "Pinky", frame0: 8}, {name: "Clyde", frame0: 24}];
pacman = {
	x: 0,
	y: 0
};
dirAngle = [0, 0, 0x40, 0x40].map(IntToFix);
dirFlip = [0, FLIP_H, FLIP_H, 0];

frame = 0;

function WrapX(x){
	return (x + 224) % 224;
}

function WrapY(y){
	return (y + 248) % 248;
}

function GetPointTile(x, y){
	var c = WrapX(x) >> 3;
	var r = WrapY(y) >> 3;
	return c + r * 28;
}

function CheckPos(x, y){
	return mapWalls.data[GetPointTile(x, y)];
}

function MoveB(e){
	var a, b;
	
	switch(e.dir){
		case 0:
			a = !CheckPos(e.x + 4, e.y - 4);
			b = !CheckPos(e.x + 4, e.y + 3);
			if(a && b) e.x++;
			break;
		case 1:
			a = !CheckPos(e.x - 5, e.y - 4);
			b = !CheckPos(e.x - 5, e.y + 3);
			if(a && b) e.x--;
			break;
		case 2:
			a = !CheckPos(e.x - 4, e.y - 5);
			b = !CheckPos(e.x + 3, e.y - 5);
			if(a && b) e.y--;
			break;
		case 3:
			a = !CheckPos(e.x - 4, e.y + 4);
			b = !CheckPos(e.x + 3, e.y + 4);
			if(a && b) e.y++;
			break;
	}
	e.turning = false;
	e.stuck = !a && !b;
}

function MoveA(e){
	e.x = WrapX(e.x);
	e.y = WrapY(e.y);
	
	var a, b;
	
	e.turning = true;
	
	if(e.nextDir == e.dir){
		MoveB(e);
		return;
	}
	
	switch(e.nextDir){
		case 0:
			a = !CheckPos(e.x + 4, e.y - 4);
			b = !CheckPos(e.x + 4, e.y + 3);
			if(a || b) e.x++;
			if(a && b) e.dir = e.nextDir;
			else if(a) e.y--;
			else if(b) e.y++;
			else MoveB(e);
			break;
		case 1:
			a = !CheckPos(e.x - 5, e.y - 4);
			b = !CheckPos(e.x - 5, e.y + 3);
			if(a || b) e.x--;
			if(a && b) e.dir = e.nextDir;
			else if(a) e.y--;
			else if(b) e.y++;
			else MoveB(e);
			break;
		case 2:
			a = !CheckPos(e.x - 4, e.y - 5);
			b = !CheckPos(e.x + 3, e.y - 5);
			if(a || b) e.y--;
			if(a && b) e.dir = e.nextDir;
			else if(a) e.x--;
			else if(b) e.x++;
			else MoveB(e);
			break;
		case 3:
			a = !CheckPos(e.x - 4, e.y + 4);
			b = !CheckPos(e.x + 3, e.y + 4);
			if(a || b) e.y++;
			if(a && b) e.dir = e.nextDir;
			else if(a) e.x--;
			else if(b) e.x++;
			else MoveB(e);
			break;
	}
}

function EatPos(x, y){
	var t = GetPointTile(x, y);
	var p = mapPickups.data[t];
	if(p){
		if(pickupProperties.hasOwnProperty(p) && pickupProperties[p].isPP){
		}
		mapPickups.data[t] = 0;
		dotsLeft--;
	}
}

function MoveGhost(g){
	g.x = WrapX(g.x);
	g.y = WrapY(g.y);
	
	if(g.housed){
		MoveB(g);
		if(g.stuck) g.dir += [1, -1, 1, -1][g.dir];
		return;
	}
	
	var tx = g.x & 248;
	var ty = g.y & 248;
	var u = CheckPos(tx, ty - 8);
	var d = CheckPos(tx, ty + 8);
	var r = CheckPos(tx + 8, ty);
	var l = CheckPos(tx - 8, ty);
	
	g.x += [1, -1, 0, 0][g.dir];
	g.y += [0, 0, -1, 1][g.dir];
	
	if(tx == g.x - 4 && ty == g.y - 4){
		var i;
		var v = (Math.random() * 4) % 4;
		var n;
		for(i = 0; [r, l, u, d][i ^ v] || (i ^ v) == g.dir + [1, -1, 1, -1][g.dir]; i++){}
		g.dir = i ^ v;
	}
}

function UpdateAll(){
	for(var i = 0; i < 4; i++){
		var g = ghosts[i];
		MoveGhost(g);
	}
	
	if(!pacman.turning || pacman.stuck){
		if(dpad[0].x < 0) pacman.nextDir = 1;
		if(dpad[0].x > 0) pacman.nextDir = 0;
		if(dpad[0].y < 0) pacman.nextDir = 2;
		if(dpad[0].y > 0) pacman.nextDir = 3;
	}
	
	MoveA(pacman);
	EatPos(pacman.x - 1, pacman.y - 1);
	EatPos(pacman.x, pacman.y - 1);
	EatPos(pacman.x - 1, pacman.y);
	EatPos(pacman.x, pacman.y);
	
	if(!dotsLeft) InitLevel(0);
}

function DrawAll(){
	for(var i = 0; i < 4; i++){
		var g = ghosts[i];
		if(!g.live) continue;
		
		DrawSprite(field, ghostSheet, g.x - 8, g.y - 8, g.frame0 + g.dir * 2 + ((frame / 5) & 1));
	}
	
	DrawTransformSprite(field, pacSheet, SPRITE_ROTATE | SPRITE_FLIP, pacman.x - 8, pacman.y - 8, pacman.dir >= 0 ? ((frame / 5) & 1) : 2, dirAngle[pacman.dir >= 0 ? pacman.dir : 0], dirFlip[pacman.dir >= 0 ? pacman.dir : 0]);
}

function InitLevel(n){
	for(var i = 0; i < 4; i++) SpawnGhost(i);
	pacman.x = spawns.PacMan.x;
	pacman.y = spawns.PacMan.y;
	pacman.dir = pacman.nextDir = -1;
	mapPickups.data = new Uint16Array(pickupsData);
	dotsLeft = numberOfDots;
}

InitLevel(0);

function Loop(){
	if(Key(KEY_ESC)) Quit();
	
	ClearToColor(field, 0);
	DrawTileLayer(field, mapWalls, tileset, 1, 0, 0, 28, 31, 0, 0);
	DrawTileLayer(field, mapPickups, tileset, 1, 0, 0, 28, 31, 0, 0);
	DrawAll();
	UpdateAll();
	DrawBitmap(screen, field, 0, 24);
	
	frame++;
}