frame = 0;
oldButtons = [0, 0, 0, 0];
debug = false;
render = true;
clearScreen = true;
ship = {
 x: screen.w / 2,
 y: screen.h / 2,
 dx: 0,
 dy: 0,
 angle: 0,
 alive: false,
 radius: 4,
 accel: 0.1,
 turnSpeed: 0.1,
 friction: 0.005
};
laserSound = LoadSample("laser.wav");
teleSound = LoadSample("tele.wav");
explosionSounds = [LoadSample("expl1.wav"), LoadSample("expl2.wav"), LoadSample("expl3.wav")];
laserBitmap = LoadBitmap("laser.pcx");
bulletSpritesheet = CreateSpriteSheet(laserBitmap, 25, 25);
shipSprite = CreateSpriteSheet(LoadBitmap("ship.pcx"), 25, 25);
asteroidSpritesheet = CreateSpriteSheet(LoadBitmap("astroid3.pcx"), 50, 55);
SetPalette(LastBitmapPalette());
bg = LoadBitmap("bg.pcx");
bulletAnimSpeed = 3;
bulletLifetime = 45;
bulletSpeed = 5;
bulletRadius = 2;
asteroidAnimLength = asteroidSpritesheet.numberOfFrames / 3;
asteroidAnimSpeed = [4.5, 3.5, 3];
asteroidSpeed = [1, 1.75, 1.9];
asteroidRadius = [24, 24 * 0.66, 24 * 0.66 * 0.66];
maxAsteroids = 10 * 8;
maxBullets = 3;
asteroids = [];
bullets = [];
asteroidSprites = new Int32Array(maxAsteroids * 3);
for(var i = 0; i < maxAsteroids * 3; i += 3) asteroidSprites[i + 2] = -1;
bulletSprites = new Int32Array(maxBullets * 4);
for(var i = 0; i < maxBullets * 4; i += 4) bulletSprites[i + 2] = -1;
bulletIndex = 0;
asteroidIndex = 0;
function PlayExplosion(){
 PlaySample(explosionSounds[Math.floor(explosionSounds.length * Math.random())], 175, 128, 900 + Math.random() * 100, 0);
}
function XCompare(a, b){
 return (b.x + b.radius < a.x + a.radius) ? 1 : (b.x + b.radius == a.x + a.radius) ? 0 : -1;
}
function CreateAsteroid(g, x, y){
 var moveAngle = Math.random() * 999;
 var spd = 0.75 + Math.random() * 0.25;
 var a = {
  generation: g,
  x: x,
  y: y,
  dx: Math.cos(moveAngle) * asteroidSpeed[g] * spd,
  dy: Math.sin(moveAngle) * asteroidSpeed[g] * spd,
  angle: FloatToFix(Math.random() * 256),
  flips: (Math.random() > 0.5 ? FLIP_V : 0) | (Math.random() > 0.5 ? FLIP_H : 0),
  time: Math.random() * 999,
  animSpeed: asteroidAnimSpeed[g],
  type: Math.random() > 0.5 ? 1 : 0,
  radius: asteroidRadius[g],
  spr: ((asteroidIndex++) % maxAsteroids) * 3
 };
 return a;
}
function SpawnAsteroid(){
 a = CreateAsteroid(0, Math.random() * screen.w, Math.random() * screen.h);
 while((Math.abs(ship.x - a.x) < (ship.radius + a.radius) && Math.abs(ship.y - a.y) < (ship.radius + a.radius))){
  a.x = Math.random() * screen.w;
  a.y = Math.random() * screen.h;
 }
 asteroids.push(a);
}
function DestroyShip(){
 if(!ship.alive) return;
 if(ship.blinkTime) return;
 PlayExplosion();
 ship.alive = false;
 ship.frame = -1;
}
function SpawnShip(){
 ship.alive = true;
 ship.x = screen.w / 2;
 ship.y = screen.h / 2;
 ship.dx = ship.dy = 0;
}
function SpawnBullet(){
 PlaySample(laserSound, 150, 128, 990 + Math.random() * 20, 0);
 var b;
 if(bullets.length >= maxBullets){
  bulletSprites[bullets.shift().spr + 2] = -1;
 }
 bullets.push(b = {
  x: ship.x,
  y: ship.y,
  time: 0,
  dx: Math.cos(ship.angle) * bulletSpeed,
  dy: Math.sin(ship.angle) * bulletSpeed,
  angle: FloatToFix(256 * ship.angle / (Math.PI * 2)),
  radius: bulletRadius,
  spr: ((bulletIndex++) % maxBullets) * 4
 });
 bulletSprites[b.spr + 3] = b.angle;
}
function DrawCircle(obj){
 Circle(screen, obj.x, obj.y, obj.radius, 1 + Math.random() * 254);
}
function DestroyAsteroid(i, a){
 asteroidSprites[a.spr + 2] = -1;
 PlayExplosion();
 if(a.generation < 2){
  asteroids[i] = CreateAsteroid(a.generation + 1, a.x, a.y);
  asteroids.push(CreateAsteroid(a.generation + 1, a.x, a.y));
 }
 else{
  asteroids[i] = asteroids[asteroids.length - 1];
  asteroids[asteroids.length - 1] = a;
  asteroids.pop();
 }
 ;
}
;
level = 0;
lives = 4;
SetTextBgColor(0);
SetTextAllign(2);
function Loop(){
 frame++;
 if(asteroids.length == 0){
  for(var i = 0; (i < level + 3) && (i < 6); i++) SpawnAsteroid();
  level++;
  ;
 }
  if(!ship.alive){
   if(buttons[0] & (~oldButtons[0]) & BUTTON_START){
    if(lives > 0) lives--;
    else {
     lives = 4;
     while(asteroids.length) DestroyAsteroid(0, asteroids[0]);
     level = 0;
    }
    ship.blinkTime = 60;
    SpawnShip();
   }
   ship.frame = -1;
  }
  else {
   if(ship.blinkTime) ship.blinkTime--;
   if(buttons[0] & (~oldButtons[0]) & BUTTON_A){
    SpawnBullet();
   }
   if(buttons[0] & (~oldButtons[0]) & BUTTON_B){
    PlaySample(teleSound, 160, 128, 1000, 0);
    ship.x = Math.random() * screen.w;
    ship.y = Math.random() * screen.h;
   }
   ship.frame = (ship.blinkTime >> 2) % 2;
   ship.dx -= Math.cos(ship.angle) * dpad[0].y * ship.accel;
   ship.dy -= Math.sin(ship.angle) * dpad[0].y * ship.accel;
   ship.dx -= ship.dx * ship.friction;
   ship.dy -= ship.dy * ship.friction;
   ship.angle += dpad[0].x * ship.turnSpeed;
   ship.x += ship.dx; ship.y += ship.dy; if(ship.x < 0 - ship.radius) ship.x = 320 + ship.radius; if(ship.y < 0 - ship.radius) ship.y = 200 + ship.radius; if(ship.x > 320 + ship.radius) ship.x = 0 - ship.radius; if(ship.y > 200 + ship.radius) ship.y = 0 - ship.radius;;
  }
  var numBullets = bullets.length;
  for(var i = 0; i < numBullets; i++){
   var b = bullets[i];
   b.x += b.dx; b.y += b.dy; if(b.x < 0 - b.radius) b.x = 320 + b.radius; if(b.y < 0 - b.radius) b.y = 200 + b.radius; if(b.x > 320 + b.radius) b.x = 0 - b.radius; if(b.y > 200 + b.radius) b.y = 0 - b.radius;;
   b.time++;
   if(b.time > bulletLifetime) b.dead = true;
   var numAsteroids = asteroids.length;
   for(j = 0; j < asteroids.length; j++){
    var a = asteroids[j];
    if(((3584 >> (a.x >= 0 ? (a.x >> 5) : 0)) & (1024 >> (b.x >= 0 ? (b.x >> 5) : 0))) && (Math.abs(b.x - a.x) < (b.radius + a.radius) && Math.abs(b.y - a.y) < (b.radius + a.radius))){
     DestroyAsteroid(j, a);
     b.dead = true;
     break;
    }
   }
   bulletSprites[b.spr + 0] = b.x - bulletSpritesheet.width * 0.5;
   bulletSprites[b.spr + 1] = b.y - bulletSpritesheet.height * 0.5;
   bulletSprites[b.spr + 2] = 0;
   if(b.dead){
    bulletSprites[b.spr + 2] = -1;
    bullets[i] = bullets[bullets.length - 1];
    bullets.pop();
    numBullets--;
   }
  }
  ;
  var numAsteroids = asteroids.length;
  var oA = false;
  for(var i = 0; i < numAsteroids; i++){
   var a = asteroids[i];
   a.x += a.dx; a.y += a.dy; if(a.x < 0 - a.radius) a.x = 320 + a.radius; if(a.y < 0 - a.radius) a.y = 200 + a.radius; if(a.x > 320 + a.radius) a.x = 0 - a.radius; if(a.y > 200 + a.radius) a.y = 0 - a.radius;;
   if((Math.abs(a.x - ship.x) < (a.radius + ship.radius) && Math.abs(a.y - ship.y) < (a.radius + ship.radius))){
    DestroyShip();
   }
   asteroidSprites[a.spr + 0] = a.x - asteroidSpritesheet.width * 0.5;
   asteroidSprites[a.spr + 1] = a.y - asteroidSpritesheet.height * 0.5;
   asteroidSprites[a.spr + 2] = (((frame / a.animSpeed) % asteroidAnimLength) | 0) + asteroidAnimLength * a.generation;
   ;
  }
  ;
 if(render) DrawBitmap(screen, bg, 0, 0);
 else ClearToColor(screen, 1);
 if(render){
  DrawSpriteBatch(screen, asteroidSpritesheet, 0, asteroidSprites);
  if(bulletIndex) DrawSpriteBatch(screen, bulletSpritesheet, SPRITE_ROTATE, bulletSprites);
  DrawTransformSprite(screen, shipSprite, SPRITE_ROTATE, ship.x - 12.5, ship.y - 12.5, ship.frame, FloatToFix(256 * ship.angle / (Math.PI * 2)));
 }
 if(debug || !render){
  var stuff = bullets.concat(asteroids);
  stuff.forEach(DrawCircle);
  Triangle(screen, ship.x + Math.cos(ship.angle) * 8, ship.y + Math.sin(ship.angle) * 8, ship.x + Math.cos(ship.angle - 2.5) * 5, ship.y + Math.sin(ship.angle - 2.5) * 5, ship.x + Math.cos(ship.angle + 2.5) * 5, ship.y + Math.sin(ship.angle + 2.5) * 5, 1 + Math.random() * 254);
 }
 if(debug) TextOut(screen, "FPS: " + fps, 0, 0, 128);
 if((!lives) && (!ship.alive)) TextOut(screen, "GAME OVER", 160, 96, 128);
 oldButtons = buttons.slice();
}
