__author__ = 'bromix'

from .directory_item import DirectoryItem
from .. import constants


class SearchItem(DirectoryItem):
    def __init__(self, context, alt_name=None, image=None, fanart=None, location=False):
        name = alt_name
        if not name:
            name = context.localize(constants.localize.SEARCH)

        if image is None:
            image = context.create_resource_path('media/search.png')

        params = dict()
        if location:
            params = {'location': location}

        DirectoryItem.__init__(self, name, context.create_uri([constants.paths.SEARCH, 'list'], params=params), image=image)
        if fanart:
            self.set_fanart(fanart)
        else:
            self.set_fanart(context.get_fanart())
