/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.xiondoc.xdom;

import com.kreative.xiondoc.xdom.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumberRange
implements Serializable,
Comparable<VersionNumberRange> {
    private static final long serialVersionUID = 1L;
    private static final Pattern RANGE_PATTERN = Pattern.compile("(>=|>|=>|\u2265)([0-9A-Za-z.]+)(<=|<|=<|\u2264)([0-9A-Za-z.]+)");
    private static final Pattern START_PATTERN = Pattern.compile("(>=|>|=>|\u2265)([0-9A-Za-z.]+)");
    private static final Pattern END_PATTERN = Pattern.compile("(<=|<|=<|\u2264)([0-9A-Za-z.]+)");
    private static final Pattern SINGLE_PATTERN = Pattern.compile("[0-9A-Za-z.]+");
    private VersionNumber start;
    private boolean startInclusive;
    private VersionNumber end;
    private boolean endInclusive;

    public VersionNumberRange(VersionNumber versionNumber) {
        this.start = versionNumber;
        this.startInclusive = true;
        this.end = versionNumber;
        this.endInclusive = true;
    }

    public VersionNumberRange(VersionNumber versionNumber, VersionNumber versionNumber2) {
        this.start = versionNumber;
        this.startInclusive = true;
        this.end = versionNumber2;
        this.endInclusive = true;
    }

    public VersionNumberRange(VersionNumber versionNumber, boolean bl, VersionNumber versionNumber2, boolean bl2) {
        this.start = versionNumber;
        this.startInclusive = bl;
        this.end = versionNumber2;
        this.endInclusive = bl2;
    }

    public VersionNumberRange(String string) {
        string = string.replaceAll("\\s+", "");
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (matcher.matches()) {
            this.start = new VersionNumber(matcher.group(2));
            this.startInclusive = matcher.group(1).contains("=") || matcher.group(1).contains("\u2265");
            this.end = new VersionNumber(matcher.group(4));
            this.endInclusive = matcher.group(3).contains("=") || matcher.group(3).contains("\u2264");
        } else {
            matcher = START_PATTERN.matcher(string);
            if (matcher.matches()) {
                this.start = new VersionNumber(matcher.group(2));
                this.startInclusive = matcher.group(1).contains("=") || matcher.group(1).contains("\u2265");
                this.end = null;
                this.endInclusive = true;
            } else {
                matcher = END_PATTERN.matcher(string);
                if (matcher.matches()) {
                    this.start = null;
                    this.startInclusive = true;
                    this.end = new VersionNumber(matcher.group(2));
                    this.endInclusive = matcher.group(1).contains("=") || matcher.group(1).contains("\u2264");
                } else {
                    matcher = SINGLE_PATTERN.matcher(string);
                    if (matcher.matches()) {
                        this.start = this.end = new VersionNumber(matcher.group());
                        this.endInclusive = true;
                        this.startInclusive = true;
                    } else {
                        this.end = null;
                        this.start = null;
                        this.endInclusive = true;
                        this.startInclusive = true;
                    }
                }
            }
        }
    }

    public String toString() {
        if (this.start != null && this.end != null && this.start.equals(this.end)) {
            return this.start.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.start != null) {
            stringBuffer.append(this.startInclusive ? ">=" : ">");
            stringBuffer.append(this.start.toString());
        }
        if (this.end != null) {
            stringBuffer.append(this.endInclusive ? "<=" : "<");
            stringBuffer.append(this.end.toString());
        }
        return stringBuffer.toString();
    }

    public String toEnglishString() {
        if (this.start == null && this.end == null) {
            return "any version";
        }
        if (this.end == null) {
            if (this.startInclusive) {
                return this.start.toString() + " or above";
            }
            return "above " + this.start.toString();
        }
        if (this.start == null) {
            if (this.endInclusive) {
                return this.end.toString() + " or below";
            }
            return "below " + this.end.toString();
        }
        if (this.startInclusive && this.endInclusive) {
            if (this.start.compareTo(this.end) == 0) {
                return this.start.toString() + " only";
            }
            return this.start.toString() + " through " + this.end.toString();
        }
        if (this.endInclusive) {
            return this.end.toString() + " or below but above " + this.start.toString();
        }
        if (this.startInclusive) {
            return this.start.toString() + " or above but below " + this.end.toString();
        }
        return "above " + this.start.toString() + " but below " + this.end.toString();
    }

    public boolean contains(VersionNumber versionNumber) {
        if (this.start == null && this.end == null) {
            return true;
        }
        if (this.end == null) {
            int n = versionNumber.compareTo(this.start);
            return n > 0 || n == 0 && this.startInclusive;
        }
        if (this.start == null) {
            int n = versionNumber.compareTo(this.end);
            return n < 0 || n == 0 && this.endInclusive;
        }
        int n = versionNumber.compareTo(this.start);
        int n2 = versionNumber.compareTo(this.end);
        return (n > 0 || n == 0 && this.startInclusive) && (n2 < 0 || n2 == 0 && this.endInclusive);
    }

    public boolean contains(VersionNumberRange versionNumberRange) {
        if (this.start == null && this.end == null) {
            return true;
        }
        if (this.end == null) {
            if (versionNumberRange.start == null) {
                return false;
            }
            int n = versionNumberRange.start.compareTo(this.start);
            return n > 0 || n == 0 && (this.startInclusive || !versionNumberRange.startInclusive);
        }
        if (this.start == null) {
            if (versionNumberRange.end == null) {
                return false;
            }
            int n = versionNumberRange.end.compareTo(this.end);
            return n < 0 || n == 0 && (this.endInclusive || !versionNumberRange.endInclusive);
        }
        if (versionNumberRange.start == null || versionNumberRange.end == null) {
            return false;
        }
        int n = versionNumberRange.start.compareTo(this.start);
        int n2 = versionNumberRange.end.compareTo(this.end);
        return !(n <= 0 && (n != 0 || !this.startInclusive && versionNumberRange.startInclusive) || n2 >= 0 && (n2 != 0 || !this.endInclusive && versionNumberRange.endInclusive));
    }

    public boolean intersects(VersionNumberRange versionNumberRange) {
        if (this.start == null && this.end == null) {
            return true;
        }
        if (this.end == null) {
            if (versionNumberRange.end == null) {
                return true;
            }
            int n = versionNumberRange.end.compareTo(this.start);
            return n > 0 || n == 0 && this.startInclusive && versionNumberRange.endInclusive;
        }
        if (this.start == null) {
            if (versionNumberRange.start == null) {
                return true;
            }
            int n = versionNumberRange.start.compareTo(this.end);
            return n < 0 || n == 0 && this.endInclusive && versionNumberRange.startInclusive;
        }
        if (versionNumberRange.start == null || versionNumberRange.end == null) {
            return versionNumberRange.intersects(this);
        }
        int n = versionNumberRange.end.compareTo(this.start);
        int n2 = versionNumberRange.start.compareTo(this.end);
        return (n > 0 || n == 0 && this.startInclusive && versionNumberRange.endInclusive) && (n2 < 0 || n2 == 0 && this.endInclusive && versionNumberRange.startInclusive);
    }

    @Override
    public int compareTo(VersionNumberRange versionNumberRange) {
        int n;
        if (this.start != null && versionNumberRange.start != null) {
            n = this.start.compareTo(versionNumberRange.start);
            if (n != 0) {
                return n;
            }
            if (this.startInclusive && !versionNumberRange.startInclusive) {
                return -1;
            }
            if (versionNumberRange.startInclusive && !this.startInclusive) {
                return 1;
            }
        } else {
            if (versionNumberRange.start != null) {
                return -1;
            }
            if (this.start != null) {
                return 1;
            }
        }
        if (this.end != null && versionNumberRange.end != null) {
            n = this.end.compareTo(versionNumberRange.end);
            if (n != 0) {
                return n;
            }
            if (this.endInclusive && !versionNumberRange.endInclusive) {
                return 1;
            }
            if (versionNumberRange.endInclusive && !this.endInclusive) {
                return -1;
            }
        } else {
            if (versionNumberRange.end != null) {
                return 1;
            }
            if (this.end != null) {
                return -1;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof VersionNumberRange) {
            VersionNumberRange versionNumberRange = (VersionNumberRange)object;
            return (this.start == null ? versionNumberRange.start == null : (versionNumberRange.start == null ? this.start == null : this.start.equals(versionNumberRange.start) && this.startInclusive == versionNumberRange.startInclusive)) && (this.end == null ? versionNumberRange.end == null : (versionNumberRange.end == null ? this.end == null : this.end.equals(versionNumberRange.end) && this.endInclusive == versionNumberRange.endInclusive));
        }
        return false;
    }

    public int hashCode() {
        return (this.start == null ? 0 : this.start.hashCode() ^ (this.startInclusive ? 0 : -65536)) ^ (this.end == null ? 0 : this.end.hashCode() ^ (this.endInclusive ? 0 : 65535));
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[]{"1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "2.0", "3.0"};
        VersionNumber[] versionNumberArray = new VersionNumber[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            versionNumberArray[i] = new VersionNumber(stringArray2[i]);
        }
        for (VersionNumber object : versionNumberArray) {
            System.out.print(object.toString() + "\t");
        }
        System.out.println("DESCRIPTION");
        for (String string : stringArray) {
            Vector<VersionNumberRange> vector = new Vector<VersionNumberRange>();
            Scanner scanner = new Scanner(new File(string), "UTF-8");
            while (scanner.hasNextLine()) {
                vector.add(new VersionNumberRange(scanner.nextLine()));
            }
            scanner.close();
            Collections.sort(vector);
            for (VersionNumberRange versionNumberRange : vector) {
                for (VersionNumber versionNumber : versionNumberArray) {
                    System.out.print(versionNumberRange.contains(versionNumber) + "\t");
                }
                System.out.println(versionNumberRange.toString() + " -> " + versionNumberRange.toEnglishString());
            }
        }
    }
}

