/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.XNModule;
import com.kreative.openxion.XNParseError;
import com.kreative.openxion.XNParser;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNEmptyExpression;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.ast.XNNumberExpression;
import com.kreative.openxion.ast.XNStringExpression;
import com.kreative.openxion.audio.NoteParser;
import com.kreative.openxion.audio.XNAudioManager;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNAudioModule
extends XNModule {
    private static final long serialVersionUID = 33L;
    public static final String MODULE_NAME = "OpenXION Audio Module";
    public static final String MODULE_VERSION = "1.4";
    private static XNAudioModule instance = null;
    private XNAudioManager mgr;
    private String dialingPort;
    private long dialingTime;
    private float dialingVolume;
    private float toneVolume;
    private static final XNModule.CommandParser p_dial = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            HashSet<String> hashSet = new HashSet<String>();
            if (collection != null) {
                hashSet.addAll(collection);
            }
            hashSet.add("with");
            Vector<XNExpression> vector = new Vector<XNExpression>();
            vector.add(xNParser.getListExpression(hashSet));
            if (xNParser.lookToken(1).toString().equalsIgnoreCase("with")) {
                if (xNParser.lookToken(2).toString().equalsIgnoreCase("modem")) {
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 2));
                    if (xNParser.lookListExpression(1, collection)) {
                        vector.add(xNParser.getListExpression(collection));
                    }
                } else {
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                    vector.add(xNParser.getListExpression(collection));
                }
            }
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNAudioModule.myDescribeCommand(string, list);
        }
    };
    private static final XNModule.CommandParser p_play = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            Vector<XNExpression> vector;
            block3: {
                block2: {
                    vector = new Vector<XNExpression>();
                    vector.add(xNParser.getListExpression(collection));
                    if (!xNParser.lookToken(1).toString().equalsIgnoreCase("tempo")) break block2;
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                    vector.add(xNParser.getListExpression(collection));
                    vector.add(xNParser.getListExpression(collection));
                    while (xNParser.lookListExpression(1, collection)) {
                        vector.add(xNParser.getListExpression(collection));
                    }
                    break block3;
                }
                if (!xNParser.lookListExpression(1, collection)) break block3;
                vector.add(XNAudioModule.createTokenExpression(xNParser, "tempo"));
                vector.add(new XNNumberExpression(new XNToken(2, "120", xNParser.getSource(), 0, 0, 0, 0)));
                vector.add(xNParser.getListExpression(collection));
                while (xNParser.lookListExpression(1, collection)) {
                    vector.add(xNParser.getListExpression(collection));
                }
            }
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNAudioModule.myDescribeCommand(string, list);
        }
    };
    private static final XNModule.CommandParser p_speak = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            HashSet<String> hashSet = new HashSet<String>();
            if (collection != null) {
                hashSet.addAll(collection);
            }
            hashSet.add("with");
            Vector<XNExpression> vector = new Vector<XNExpression>();
            vector.add(xNParser.getListExpression(hashSet));
            if (xNParser.lookToken(1).toString().equalsIgnoreCase("with")) {
                if (xNParser.lookToken(2).toString().equalsIgnoreCase("voice")) {
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 2));
                    vector.add(xNParser.getListExpression(collection));
                } else if ((xNParser.lookToken(2).toString().equalsIgnoreCase("male") || xNParser.lookToken(2).toString().equalsIgnoreCase("female") || xNParser.lookToken(2).toString().equalsIgnoreCase("neuter")) && xNParser.lookToken(3).toString().equalsIgnoreCase("voice")) {
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                }
            }
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNAudioModule.myDescribeCommand(string, list);
        }
    };
    private static final XNModule.CommandParser p_stop = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            Vector<XNExpression> vector = new Vector<XNExpression>();
            if (!(xNParser.lookToken(1).toString().equalsIgnoreCase("sound") || xNParser.lookToken(1).toString().equalsIgnoreCase("speech") || xNParser.lookToken(1).toString().equalsIgnoreCase("tone"))) {
                throw new XNParseError("sound, speech, or tone", xNParser.getToken());
            }
            vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNAudioModule.myDescribeCommand(string, list);
        }
    };
    private static final XNModule.CommandParser p_tone = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            Vector<XNExpression> vector = new Vector<XNExpression>();
            vector.add(xNParser.getListExpression(collection));
            if (xNParser.lookToken(1).toString().equalsIgnoreCase("for")) {
                vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                vector.add(xNParser.getListExpression(collection));
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("milliseconds") | xNParser.lookToken(1).toString().equalsIgnoreCase("millisecond") | xNParser.lookToken(1).toString().equalsIgnoreCase("millisecs") | xNParser.lookToken(1).toString().equalsIgnoreCase("millisec") | xNParser.lookToken(1).toString().equalsIgnoreCase("millis") | xNParser.lookToken(1).toString().equalsIgnoreCase("milli") | xNParser.lookToken(1).toString().equalsIgnoreCase("seconds") | xNParser.lookToken(1).toString().equalsIgnoreCase("second") | xNParser.lookToken(1).toString().equalsIgnoreCase("secs") | xNParser.lookToken(1).toString().equalsIgnoreCase("sec") | xNParser.lookToken(1).toString().equalsIgnoreCase("ticks") | xNParser.lookToken(1).toString().equalsIgnoreCase("tick") | xNParser.lookToken(1).toString().equalsIgnoreCase("minutes") | xNParser.lookToken(1).toString().equalsIgnoreCase("minute") | xNParser.lookToken(1).toString().equalsIgnoreCase("mins") | xNParser.lookToken(1).toString().equalsIgnoreCase("min") | xNParser.lookToken(1).toString().equalsIgnoreCase("hours") | xNParser.lookToken(1).toString().equalsIgnoreCase("hour")) {
                    vector.add(XNAudioModule.getTokenExpression(xNParser, 1));
                } else {
                    vector.add(XNAudioModule.createTokenExpression(xNParser, "ticks"));
                }
            }
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNAudioModule.myDescribeCommand(string, list);
        }
    };
    private final XNModule.Command c_dial = new XNModule.Command(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            if (list == null || list.size() == 0 || list.size() > 3) {
                throw new XNScriptError("Can't understand arguments to dial");
            }
            if (list.size() > 1) {
                if (!XNAudioModule.this.mgr.supportsModemDial()) {
                    return new XOMString("Dial not supported on this system");
                }
                String string2 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
                String string3 = list.size() > 2 ? xNInterpreter.evaluateExpression(list.get(2)).toTextString(xNContext) : "ATDT";
                if (!xNContext.allow(XNSecurityKey.TELEPHONY, "Modem Command", string3, "Number", string2)) throw new XNScriptError("Security settings do not allow dial");
                XNAudioModule.this.mgr.getModemDialer().dial(XNAudioModule.this.dialingPort, string3, string2, 1000L, XNAudioModule.this.dialingTime);
                return null;
            } else {
                if (!XNAudioModule.this.mgr.supportsAudioDial()) {
                    return new XOMString("Dial not supported on this system");
                }
                String string4 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
                XNAudioModule.this.mgr.getAudioDialer().dial(string4, 250L, XNAudioModule.this.dialingVolume);
                XNAudioModule.this.mgr.getAudioDialer().finishDialing();
            }
            return null;
        }
    };
    private final XNModule.Command c_play = new XNModule.Command(){

        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            if (list == null || list.size() == 0 || list.size() == 2 || list.size() == 3) {
                throw new XNScriptError("Can't understand arguments to play");
            }
            if (!XNAudioModule.this.mgr.supportsPlay()) {
                return new XOMString("Play not supported on this system");
            }
            if (list.size() == 1) {
                String string2 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
                if (string2.equalsIgnoreCase("stop")) {
                    XNAudioModule.this.mgr.getPlayer().stopPlaying();
                } else {
                    XNAudioModule.this.mgr.getPlayer().play(string2);
                }
            } else {
                String string3 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
                float f = (float)((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xNInterpreter.evaluateExpression(list.get(2)).asPrimitive(xNContext), true)).toDouble();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 3; i < list.size(); ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(xNInterpreter.evaluateExpression(list.get(i)).toTextString(xNContext).trim());
                }
                XNAudioModule.this.mgr.getPlayer().play(string3, f, new NoteParser().parseNotes(stringBuffer.toString()));
            }
            return null;
        }
    };
    private final XNModule.Command c_speak = new XNModule.Command(){

        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            String string2;
            if (list == null || list.size() == 0 || list.size() == 2 || list.size() > 4) {
                throw new XNScriptError("Can't understand arguments to speak");
            }
            if (!XNAudioModule.this.mgr.supportsSpeak()) {
                return new XOMString("Speak not supported on this system");
            }
            String string3 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
            string2 = list.size() == 3 ? xNInterpreter.evaluateExpression(list.get(2)).toTextString(xNContext) : (list.size() == 4 ? ((string2 = xNInterpreter.evaluateExpression(list.get(2)).toTextString(xNContext)).equalsIgnoreCase("male") ? XNAudioModule.this.mgr.getSpeaker().getMaleVoice() : (string2.equalsIgnoreCase("female") ? XNAudioModule.this.mgr.getSpeaker().getFemaleVoice() : (string2.equalsIgnoreCase("neuter") ? XNAudioModule.this.mgr.getSpeaker().getNeuterVoice() : XNAudioModule.this.mgr.getSpeaker().getDefaultVoice()))) : XNAudioModule.this.mgr.getSpeaker().getDefaultVoice());
            XNAudioModule.this.mgr.getSpeaker().speak(string2, string3);
            return null;
        }
    };
    private final XNModule.Command c_stop = new XNModule.Command(){

        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            if (list == null || list.size() != 1) {
                throw new XNScriptError("Can't understand arguments to stop");
            }
            String string2 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
            if (string2.equalsIgnoreCase("sound")) {
                if (XNAudioModule.this.mgr.supportsPlay()) {
                    for (int i = 0; i < XNAudioModule.this.mgr.getPlayerChannels(); ++i) {
                        XNAudioModule.this.mgr.getPlayer(i).stopPlaying();
                    }
                }
                return null;
            }
            if (string2.equalsIgnoreCase("speech")) {
                if (XNAudioModule.this.mgr.supportsSpeak()) {
                    XNAudioModule.this.mgr.getSpeaker().stopSpeaking();
                }
                return null;
            }
            if (string2.equalsIgnoreCase("tone")) {
                if (XNAudioModule.this.mgr.supportsTone()) {
                    for (int i = 0; i < XNAudioModule.this.mgr.getTonerChannels(); ++i) {
                        XNAudioModule.this.mgr.getToner(i).stopToning();
                    }
                }
                return null;
            }
            throw new XNScriptError("Can't understand arguments to stop");
        }
    };
    private final XNModule.Command c_tone = new XNModule.Command(){

        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            if (list == null || list.size() == 0 || list.size() > 4) {
                throw new XNScriptError("Can't understand arguments to tone");
            }
            float f = (float)((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xNInterpreter.evaluateExpression(list.get(0)).asPrimitive(xNContext), true)).toDouble();
            if (list.size() > 2) {
                double d = ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xNInterpreter.evaluateExpression(list.get(2)), true)).toDouble();
                String string2 = list.size() > 3 ? xNInterpreter.evaluateExpression(list.get(3)).toTextString(xNContext) : "ticks";
                d = (string2 = string2.toLowerCase()).startsWith("sec") ? (d *= 1000.0) : (string2.startsWith("milli") ? (d *= 1.0) : (string2.startsWith("hour") ? (d *= 3600000.0) : (string2.startsWith("min") ? (d *= 60000.0) : (d *= 16.666666666666668))));
                XNAudioModule.this.mgr.getToner().tone((long)d, XNAudioModule.this.toneVolume, f);
            } else {
                XNAudioModule.this.mgr.getToner().tone(1000L, XNAudioModule.this.toneVolume, f);
            }
            return null;
        }
    };
    private final XNModule.Function f_serialPorts = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow serialPorts");
            }
            if (XNAudioModule.this.mgr.supportsModemDial()) {
                String[] stringArray;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : stringArray = XNAudioModule.this.mgr.getModemDialer().getSerialPorts()) {
                    stringBuffer.append(xNContext.getLineEnding());
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.delete(0, xNContext.getLineEnding().length());
                }
                return new XOMString(stringBuffer.toString());
            }
            return XOMEmpty.EMPTY;
        }
    };
    private final XNModule.Function f_sound = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsPlay()) {
                if (XNAudioModule.this.mgr.getPlayer().isPlaying()) {
                    return new XOMString(XNAudioModule.this.mgr.getPlayer().getInstrumentPlayed());
                }
                return new XOMString("done");
            }
            return new XOMString("done");
        }
    };
    private final XNModule.Function f_sounds = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsPlay()) {
                String[] stringArray;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : stringArray = XNAudioModule.this.mgr.getPlayer().getInstruments()) {
                    stringBuffer.append(xNContext.getLineEnding());
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.delete(0, xNContext.getLineEnding().length());
                }
                return new XOMString(stringBuffer.toString());
            }
            return XOMEmpty.EMPTY;
        }
    };
    private final XNModule.Function f_speech = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsSpeak()) {
                if (XNAudioModule.this.mgr.getSpeaker().isSpeaking()) {
                    return new XOMString(XNAudioModule.this.mgr.getSpeaker().getPhraseSpoken());
                }
                return new XOMString("done");
            }
            return new XOMString("done");
        }
    };
    private final XNModule.Function f_tone = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsTone()) {
                if (XNAudioModule.this.mgr.getToner().isToning()) {
                    return new XOMNumber(Float.valueOf(XNAudioModule.this.mgr.getToner().getFrequencyToned()));
                }
                return new XOMString("done");
            }
            return new XOMString("done");
        }
    };
    private final XNModule.Function f_voice = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsSpeak()) {
                if (XNAudioModule.this.mgr.getSpeaker().isSpeaking()) {
                    return new XOMString(XNAudioModule.this.mgr.getSpeaker().getVoiceSpoken());
                }
                return new XOMString("done");
            }
            return new XOMString("done");
        }
    };
    private final XNModule.Function f_voices = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNAudioModule.assertEmptyParameter(string, xOMVariant);
            if (XNAudioModule.this.mgr.supportsSpeak()) {
                String[] stringArray;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : stringArray = XNAudioModule.this.mgr.getSpeaker().getVoices()) {
                    stringBuffer.append(xNContext.getLineEnding());
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.delete(0, xNContext.getLineEnding().length());
                }
                return new XOMString(stringBuffer.toString());
            }
            return XOMEmpty.EMPTY;
        }
    };
    private final XNModule.Property p_dialingVolume = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (XNAudioModule.this.mgr.supportsAudioDial()) {
                return new XOMNumber(Float.valueOf(XNAudioModule.this.dialingVolume * 7.0f / XNAudioModule.this.mgr.getAudioDialer().getMaximumAmplitude()));
            }
            return XOMNumber.ZERO;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (XNAudioModule.this.mgr.supportsAudioDial()) {
                XNAudioModule.this.dialingVolume = (float)((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble() * XNAudioModule.this.mgr.getAudioDialer().getMaximumAmplitude() / 7.0f;
            }
        }
    };
    private final XNModule.Property p_dialingTime = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (XNAudioModule.this.mgr.supportsModemDial()) {
                return new XOMInteger(XNAudioModule.this.dialingTime * 60L / 1000L);
            }
            return XOMInteger.ZERO;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (XNAudioModule.this.mgr.supportsModemDial()) {
                XNAudioModule.this.dialingTime = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toLong() * 1000L / 60L;
            }
        }
    };
    private final XNModule.Property p_dialingPort = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (!xNContext.allow(XNSecurityKey.TELEPHONY, "Property", string)) {
                throw new XNScriptError("Security settings do not allow dialingPort");
            }
            if (XNAudioModule.this.mgr.supportsModemDial()) {
                return new XOMString(XNAudioModule.this.dialingPort);
            }
            return XOMEmpty.EMPTY;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (!xNContext.allow(XNSecurityKey.TELEPHONY, "Property", string)) {
                throw new XNScriptError("Security settings do not allow dialingPort");
            }
            if (XNAudioModule.this.mgr.supportsModemDial()) {
                XNAudioModule.this.dialingPort = xOMVariant.toTextString(xNContext);
            }
        }
    };
    private final XNModule.Property p_soundChannel = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (XNAudioModule.this.mgr.supportsPlay()) {
                return new XOMInteger(XNAudioModule.this.mgr.getPlayerChannel() + 1);
            }
            return XOMInteger.ZERO;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (XNAudioModule.this.mgr.supportsPlay()) {
                XNAudioModule.this.mgr.setPlayerChannel(((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toInt() - 1);
            }
        }
    };
    private final XNModule.Property p_toneVolume = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (XNAudioModule.this.mgr.supportsTone()) {
                return new XOMNumber(Float.valueOf(XNAudioModule.this.toneVolume * 7.0f / XNAudioModule.this.mgr.getToner().getMaximumAmplitude()));
            }
            return XOMNumber.ZERO;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (XNAudioModule.this.mgr.supportsTone()) {
                XNAudioModule.this.toneVolume = (float)((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toDouble() * XNAudioModule.this.mgr.getToner().getMaximumAmplitude() / 7.0f;
            }
        }
    };
    private final XNModule.Property p_toneChannel = new XNModule.Property(){

        public boolean canGetProperty(XNContext xNContext, String string) {
            return true;
        }

        public boolean canSetProperty(XNContext xNContext, String string) {
            return true;
        }

        public XOMVariant getProperty(XNContext xNContext, XNModifier xNModifier, String string) {
            if (XNAudioModule.this.mgr.supportsTone()) {
                return new XOMInteger(XNAudioModule.this.mgr.getTonerChannel() + 1);
            }
            return XOMInteger.ZERO;
        }

        public void setProperty(XNContext xNContext, String string, XOMVariant xOMVariant) {
            if (XNAudioModule.this.mgr.supportsTone()) {
                XNAudioModule.this.mgr.setTonerChannel(((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toInt() - 1);
            }
        }
    };

    public static final synchronized XNAudioModule instance() {
        if (instance == null) {
            instance = new XNAudioModule(XNAudioManager.instance());
        }
        return instance;
    }

    private XNAudioModule(XNAudioManager xNAudioManager) {
        this.mgr = xNAudioManager;
        this.dialingPort = xNAudioManager.supportsModemDial() && xNAudioManager.getModemDialer().getSerialPorts().length > 0 ? xNAudioManager.getModemDialer().getSerialPorts()[0] : "";
        this.dialingTime = 3000L;
        this.dialingVolume = xNAudioManager.supportsAudioDial() ? xNAudioManager.getAudioDialer().getMaximumAmplitude() : 0.0f;
        this.toneVolume = xNAudioManager.supportsTone() ? xNAudioManager.getToner().getMaximumAmplitude() : 0.0f;
        this.commandParsers.put("dial", p_dial);
        this.commandParsers.put("play", p_play);
        this.commandParsers.put("speak", p_speak);
        this.commandParsers.put("stop", p_stop);
        this.commandParsers.put("tone", p_tone);
        this.commands.put("dial", this.c_dial);
        this.commands.put("play", this.c_play);
        this.commands.put("speak", this.c_speak);
        this.commands.put("stop", this.c_stop);
        this.commands.put("tone", this.c_tone);
        this.functions.put("serialports", this.f_serialPorts);
        this.functions.put("sound", this.f_sound);
        this.functions.put("sounds", this.f_sounds);
        this.functions.put("speech", this.f_speech);
        this.functions.put("tone", this.f_tone);
        this.functions.put("voice", this.f_voice);
        this.functions.put("voices", this.f_voices);
        this.properties.put("dialingport", this.p_dialingPort);
        this.properties.put("dialingtime", this.p_dialingTime);
        this.properties.put("dialingvolume", this.p_dialingVolume);
        this.properties.put("soundchannel", this.p_soundChannel);
        this.properties.put("tonechannel", this.p_toneChannel);
        this.properties.put("tonevolume", this.p_toneVolume);
        this.versions.put("audiomodule", new XNModule.Version(MODULE_NAME, MODULE_VERSION));
    }

    public XNAudioManager getAudioManager() {
        return this.mgr;
    }

    public void setAudioManager(XNAudioManager xNAudioManager) {
        this.mgr = xNAudioManager;
    }

    public String toString() {
        return "XNAudioModule";
    }

    private static XNExpression getTokenExpression(XNParser xNParser, int n) {
        if (n < 1) {
            return new XNEmptyExpression(xNParser.getSource(), 0, 0);
        }
        XNToken xNToken = xNParser.getToken();
        --n;
        while (n > 0) {
            XNToken xNToken2 = xNParser.getToken();
            --n;
            XNToken xNToken3 = new XNToken(xNToken.kind, xNToken.image + " " + xNToken2.image, xNToken.source, xNToken.beginLine, xNToken.beginColumn, xNToken2.endLine, xNToken2.endColumn);
            xNToken3.specialToken = xNToken.specialToken;
            xNToken3.next = xNToken2.next;
            xNToken = xNToken3;
        }
        return new XNStringExpression(xNToken);
    }

    private static XNExpression createTokenExpression(XNParser xNParser, String string) {
        if (string == null || string.trim().length() == 0) {
            return new XNEmptyExpression(xNParser.getSource(), 0, 0);
        }
        return new XNStringExpression(new XNToken(3, string, xNParser.getSource(), 0, 0, 0, 0));
    }

    private static String myDescribeCommand(String string, List<XNExpression> list) {
        String string2 = "";
        for (XNExpression xNExpression : list) {
            if (xNExpression instanceof XNEmptyExpression) {
                XNEmptyExpression xNEmptyExpression = (XNEmptyExpression)xNExpression;
                if (xNEmptyExpression.getBeginCol() == 0 && xNEmptyExpression.getBeginLine() == 0) continue;
                string2 = string2 + " " + xNExpression.toString();
                continue;
            }
            string2 = string2 + " " + xNExpression.toString();
        }
        return string2.trim();
    }

    private static void assertEmptyParameter(String string, XOMVariant xOMVariant) {
        if (xOMVariant != null && !(xOMVariant instanceof XOMEmpty)) {
            throw new XNScriptError("Can't understand arguments to " + string);
        }
    }
}

