/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.XNModule;
import com.kreative.openxion.XNParseError;
import com.kreative.openxion.XNParser;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNEmptyExpression;
import com.kreative.openxion.ast.XNExpression;
import com.kreative.openxion.ast.XNModifier;
import com.kreative.openxion.ast.XNStringExpression;
import com.kreative.openxion.binpack.DataField;
import com.kreative.openxion.binpack.DataFormatParser;
import com.kreative.openxion.binpack.DataReader;
import com.kreative.openxion.binpack.DataWriter;
import com.kreative.openxion.io.XOMURLIOManager;
import com.kreative.openxion.tr.Matchor;
import com.kreative.openxion.tr.Multiplexor;
import com.kreative.openxion.tr.TrPattern;
import com.kreative.openxion.tr.Transformor;
import com.kreative.openxion.util.Base64;
import com.kreative.openxion.util.EndlessInputStream;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBinary;
import com.kreative.openxion.xom.inst.XOMBoolean;
import com.kreative.openxion.xom.inst.XOMColor;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMDate;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMEmpty;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMBinaryType;
import com.kreative.openxion.xom.type.XOMBooleanType;
import com.kreative.openxion.xom.type.XOMClipboardType;
import com.kreative.openxion.xom.type.XOMColorType;
import com.kreative.openxion.xom.type.XOMComplexType;
import com.kreative.openxion.xom.type.XOMDateType;
import com.kreative.openxion.xom.type.XOMDictionaryType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import com.kreative.openxion.xom.type.XOMURLType;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XNExtendedModule
extends XNModule {
    private static final long serialVersionUID = 3L;
    public static final String MODULE_NAME = "OpenXION Extended Module";
    public static final String MODULE_VERSION = "1.4";
    private static XNExtendedModule instance = null;
    private static final XNModule.CommandParser p_sql = new XNModule.CommandParser(){

        @Override
        public List<XNExpression> parseCommand(String string, XNParser xNParser, Collection<String> collection) {
            String string2 = xNParser.lookToken(1).toString().equalsIgnoreCase("connect") || xNParser.lookToken(1).toString().equalsIgnoreCase("disconnect") || xNParser.lookToken(1).toString().equalsIgnoreCase("prepare") || xNParser.lookToken(1).toString().equalsIgnoreCase("execute") ? XNExtendedModule.getTokenExpression(xNParser, 1).toString().toLowerCase() : "direct";
            Vector<XNExpression> vector = new Vector<XNExpression>();
            vector.add(XNExtendedModule.createTokenExpression(xNParser, string2));
            if (string2.equalsIgnoreCase("connect")) {
                HashSet<String> hashSet = new HashSet<String>();
                if (collection != null) {
                    hashSet.addAll(collection);
                }
                hashSet.add("with");
                vector.add(XNExtendedModule.getTokenExpression(xNParser, "to"));
                vector.add(xNParser.getListExpression(hashSet));
                while (xNParser.lookToken(1).toString().equalsIgnoreCase("with") && (xNParser.lookToken(2).toString().equalsIgnoreCase("driver") || xNParser.lookToken(2).toString().equalsIgnoreCase("username") || xNParser.lookToken(2).toString().equalsIgnoreCase("password"))) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, 2));
                    vector.add(xNParser.getListExpression(hashSet));
                }
            } else if (string2.equalsIgnoreCase("disconnect")) {
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("from")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "from"));
                    vector.add(xNParser.getListExpression(collection));
                }
            } else if (string2.equalsIgnoreCase("prepare")) {
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("execute")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "execute"));
                } else if (xNParser.lookToken(1).toString().equalsIgnoreCase("set")) {
                    HashSet<String> hashSet = new HashSet<String>();
                    if (collection != null) {
                        hashSet.addAll(collection);
                    }
                    hashSet.add("to");
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "set"));
                    vector.add(xNParser.getListExpression(hashSet));
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "to"));
                    vector.add(xNParser.getListExpression(collection));
                } else if (xNParser.lookToken(1).toString().equalsIgnoreCase("statement")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "statement"));
                    vector.add(xNParser.getListExpression(collection));
                } else {
                    vector.add(XNExtendedModule.createTokenExpression(xNParser, "statement"));
                    vector.add(xNParser.getListExpression(collection));
                }
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("using") && xNParser.lookToken(2).toString().equalsIgnoreCase("connection")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, 2));
                    vector.add(xNParser.getListExpression(collection));
                }
            } else if (string2.equalsIgnoreCase("execute")) {
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("prepared")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, "prepared"));
                } else {
                    vector.add(xNParser.getListExpression(collection));
                }
                if (xNParser.lookToken(1).toString().equalsIgnoreCase("using") && xNParser.lookToken(2).toString().equalsIgnoreCase("connection")) {
                    vector.add(XNExtendedModule.getTokenExpression(xNParser, 2));
                    vector.add(xNParser.getListExpression(collection));
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    if (xNParser.lookEOL(1) || !xNParser.isNotKeyword(1, collection)) {
                        vector.add(new XNStringExpression(new XNToken(1, XIONUtil.quote(stringBuffer.toString().trim()), xNParser.getSource(), 0, 0, 0, 0)));
                        break;
                    }
                    if (xNParser.lookToken(1).toString().equalsIgnoreCase("using") && xNParser.lookToken(2).toString().equalsIgnoreCase("connection")) {
                        vector.add(new XNStringExpression(new XNToken(1, XIONUtil.quote(stringBuffer.toString().trim()), xNParser.getSource(), 0, 0, 0, 0)));
                        vector.add(XNExtendedModule.getTokenExpression(xNParser, 2));
                        vector.add(xNParser.getListExpression(collection));
                        break;
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(xNParser.getToken().toString());
                }
            }
            return vector;
        }

        @Override
        public String describeCommand(String string, List<XNExpression> list) {
            return XNExtendedModule.myDescribeCommand(string, list);
        }
    };
    private static final XNModule.Command c_sql = new XNModule.Command(){
        private Map<String, Connection> connections = new HashMap<String, Connection>();
        private Map<String, PreparedStatement> prepareds = new HashMap<String, PreparedStatement>();
        private String lastConnection = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XOMVariant executeCommand(XNInterpreter xNInterpreter, XNContext xNContext, String string, List<XNExpression> list) {
            if (list == null || list.size() == 0) {
                throw new XNScriptError("Can't understand arguments to sql");
            }
            String string2 = xNInterpreter.evaluateExpression(list.get(0)).toTextString(xNContext);
            if (string2.equalsIgnoreCase("connect")) {
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                int n = 1;
                while (n + 1 < list.size()) {
                    String string7 = xNInterpreter.evaluateExpression(list.get(n)).toTextString(xNContext);
                    String string8 = xNInterpreter.evaluateExpression(list.get(n + 1)).toTextString(xNContext);
                    if (string7.equalsIgnoreCase("to")) {
                        string3 = string8;
                    } else if (string7.equalsIgnoreCase("with driver")) {
                        string4 = string8;
                    } else if (string7.equalsIgnoreCase("with username")) {
                        string5 = string8;
                    } else {
                        if (!string7.equalsIgnoreCase("with password")) throw new XNScriptError("Can't understand arguments to sql: " + string7);
                        string6 = string8;
                    }
                    n += 2;
                }
                if (string3 == null) {
                    throw new XNScriptError("Can't understand arguments to sql");
                }
                if (this.connections.containsKey(string3)) {
                    throw new XNScriptError("SQL connection \"" + string3 + "\" is already open");
                }
                if (string4 != null) {
                    try {
                        Class.forName(string4);
                    }
                    catch (Exception exception) {
                        throw new XNScriptError("SQL driver \"" + string4 + "\" not found");
                    }
                }
                try {
                    Connection connection = string5 == null && string6 == null ? DriverManager.getConnection("jdbc:" + string3) : DriverManager.getConnection("jdbc:" + string3, string5 == null ? "" : string5, string6 == null ? "" : string6);
                    this.connections.put(string3, connection);
                    this.lastConnection = string3;
                    return null;
                }
                catch (SQLException sQLException) {
                    throw new XNScriptError("SQL error: " + sQLException.getMessage());
                }
            }
            if (string2.equalsIgnoreCase("disconnect")) {
                String string9 = null;
                int n = 1;
                while (n + 1 < list.size()) {
                    String string10 = xNInterpreter.evaluateExpression(list.get(n)).toTextString(xNContext);
                    String string11 = xNInterpreter.evaluateExpression(list.get(n + 1)).toTextString(xNContext);
                    if (!string10.equalsIgnoreCase("from")) {
                        throw new XNScriptError("Can't understand arguments to sql");
                    }
                    string9 = string11;
                    n += 2;
                }
                if (string9 == null) {
                    string9 = this.lastConnection;
                }
                if (string9 == null || !this.connections.containsKey(string9)) {
                    throw new XNScriptError("SQL connection not open");
                }
                try {
                    if (this.prepareds.containsKey(string9)) {
                        this.prepareds.get(string9).close();
                    }
                    this.connections.get(string9).close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.lastConnection.equals(string9)) {
                    this.lastConnection = null;
                }
                this.prepareds.remove(string9);
                this.connections.remove(string9);
                return null;
            }
            if (string2.equalsIgnoreCase("prepare")) {
                if (list.size() <= 1) throw new XNScriptError("Can't understand arguments to sql");
                string2 = xNInterpreter.evaluateExpression(list.get(1)).toTextString(xNContext);
                if (string2.equalsIgnoreCase("execute")) {
                    String string12 = null;
                    if (list.size() > 3) {
                        string12 = xNInterpreter.evaluateExpression(list.get(3)).toTextString(xNContext);
                    }
                    if (string12 == null) {
                        string12 = this.lastConnection;
                    }
                    if (string12 == null || !this.connections.containsKey(string12)) {
                        throw new XNScriptError("SQL connection not open");
                    }
                    if (!this.prepareds.containsKey(string12)) {
                        throw new XNScriptError("Can't sql prepare execute until after sql prepare statement");
                    }
                    try {
                        PreparedStatement preparedStatement = this.prepareds.get(string12);
                        if (preparedStatement.execute()) {
                            ResultSet resultSet = preparedStatement.getResultSet();
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            char c = xNContext.getRowDelimiter();
                            char c2 = xNContext.getColumnDelimiter();
                            StringBuffer stringBuffer = new StringBuffer();
                            int n = 0;
                            while (resultSet.next()) {
                                StringBuffer stringBuffer2 = new StringBuffer();
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    stringBuffer2.append(c2);
                                    stringBuffer2.append(resultSet.getString(i).replace(Character.toString(c2), ""));
                                }
                                if (stringBuffer2.length() > 0) {
                                    stringBuffer2.deleteCharAt(0);
                                }
                                stringBuffer.append(c);
                                stringBuffer.append(stringBuffer2.toString().replace(Character.toString(c), ""));
                                ++n;
                            }
                            if (stringBuffer.length() > 0) {
                                stringBuffer.deleteCharAt(0);
                            }
                            this.lastConnection = string12;
                            xNContext.getVariableMap("it").setVariable(xNContext, "it", new XOMString(stringBuffer.toString()));
                            return new XOMInteger(n);
                        }
                        this.lastConnection = string12;
                        return new XOMInteger(preparedStatement.getUpdateCount());
                    }
                    catch (SQLException sQLException) {
                        throw new XNScriptError("SQL error: " + sQLException.getMessage());
                    }
                }
                if (string2.equalsIgnoreCase("set")) {
                    int n = 0;
                    String string13 = null;
                    String string14 = null;
                    if (list.size() > 2) {
                        XOMVariant xOMVariant = xNInterpreter.evaluateExpression(list.get(2)).asPrimitive(xNContext);
                        XOMInteger xOMInteger = (XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                        n = xOMInteger.toInt();
                    }
                    if (list.size() > 4) {
                        string13 = xNInterpreter.evaluateExpression(list.get(4)).toTextString(xNContext);
                    }
                    if (list.size() > 6) {
                        string14 = xNInterpreter.evaluateExpression(list.get(6)).toTextString(xNContext);
                    }
                    if (n < 1 || string13 == null) {
                        throw new XNScriptError("Can't understand arguments to sql");
                    }
                    if (string14 == null) {
                        string14 = this.lastConnection;
                    }
                    if (string14 == null || !this.connections.containsKey(string14)) {
                        throw new XNScriptError("SQL connection not open");
                    }
                    if (!this.prepareds.containsKey(string14)) {
                        throw new XNScriptError("Can't sql prepare set until after sql prepare statement");
                    }
                    try {
                        this.prepareds.get(string14).setString(n, string13);
                        this.lastConnection = string14;
                        return null;
                    }
                    catch (SQLException sQLException) {
                        throw new XNScriptError("SQL error: " + sQLException.getMessage());
                    }
                } else {
                    String string15 = null;
                    String string16 = null;
                    if (list.size() > 2) {
                        string15 = xNInterpreter.evaluateExpression(list.get(2)).toTextString(xNContext);
                    }
                    if (list.size() > 4) {
                        string16 = xNInterpreter.evaluateExpression(list.get(4)).toTextString(xNContext);
                    }
                    if (string15 == null) {
                        throw new XNScriptError("Can't understand arguments to sql");
                    }
                    if (string16 == null) {
                        string16 = this.lastConnection;
                    }
                    if (string16 == null || !this.connections.containsKey(string16)) {
                        throw new XNScriptError("SQL connection not open");
                    }
                    try {
                        if (this.prepareds.containsKey(string16)) {
                            this.prepareds.get(string16).close();
                            this.prepareds.remove(string16);
                        }
                        Connection connection = this.connections.get(string16);
                        this.prepareds.put(string16, connection.prepareStatement(string15));
                        this.lastConnection = string16;
                        return null;
                    }
                    catch (SQLException sQLException) {
                        throw new XNScriptError("SQL error: " + sQLException.getMessage());
                    }
                }
            } else {
                String string17 = null;
                String string18 = null;
                if (list.size() > 1) {
                    string17 = xNInterpreter.evaluateExpression(list.get(1)).toTextString(xNContext);
                }
                if (list.size() > 3) {
                    string18 = xNInterpreter.evaluateExpression(list.get(3)).toTextString(xNContext);
                }
                if (string17 == null) {
                    throw new XNScriptError("Can't understand arguments to sql");
                }
                if (string18 == null) {
                    string18 = this.lastConnection;
                }
                if (string18 == null || !this.connections.containsKey(string18)) {
                    throw new XNScriptError("SQL connection not open");
                }
                try {
                    Connection connection = this.connections.get(string18);
                    if (string17.trim().equalsIgnoreCase("prepared")) {
                        if (!this.prepareds.containsKey(string18)) {
                            throw new XNScriptError("Can't sql execute prepared until after sql prepare statement");
                        }
                        PreparedStatement preparedStatement = this.prepareds.get(string18);
                        if (preparedStatement.execute()) {
                            ResultSet resultSet = preparedStatement.getResultSet();
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            char c = xNContext.getRowDelimiter();
                            char c3 = xNContext.getColumnDelimiter();
                            StringBuffer stringBuffer = new StringBuffer();
                            int n = 0;
                            while (resultSet.next()) {
                                StringBuffer stringBuffer3 = new StringBuffer();
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    stringBuffer3.append(c3);
                                    stringBuffer3.append(resultSet.getString(i).replace(Character.toString(c3), ""));
                                }
                                if (stringBuffer3.length() > 0) {
                                    stringBuffer3.deleteCharAt(0);
                                }
                                stringBuffer.append(c);
                                stringBuffer.append(stringBuffer3.toString().replace(Character.toString(c), ""));
                                ++n;
                            }
                            if (stringBuffer.length() > 0) {
                                stringBuffer.deleteCharAt(0);
                            }
                            this.lastConnection = string18;
                            xNContext.getVariableMap("it").setVariable(xNContext, "it", new XOMString(stringBuffer.toString()));
                            return new XOMInteger(n);
                        }
                        this.lastConnection = string18;
                        return new XOMInteger(preparedStatement.getUpdateCount());
                    }
                    Statement statement = connection.createStatement();
                    if (statement.execute(string17)) {
                        ResultSet resultSet = statement.getResultSet();
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        char c = xNContext.getRowDelimiter();
                        char c4 = xNContext.getColumnDelimiter();
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = 0;
                        while (resultSet.next()) {
                            StringBuffer stringBuffer4 = new StringBuffer();
                            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                stringBuffer4.append(c4);
                                stringBuffer4.append(resultSet.getString(i).replace(Character.toString(c4), ""));
                            }
                            if (stringBuffer4.length() > 0) {
                                stringBuffer4.deleteCharAt(0);
                            }
                            stringBuffer.append(c);
                            stringBuffer.append(stringBuffer4.toString().replace(Character.toString(c), ""));
                            ++n;
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.deleteCharAt(0);
                        }
                        this.lastConnection = string18;
                        xNContext.getVariableMap("it").setVariable(xNContext, "it", new XOMString(stringBuffer.toString()));
                        return new XOMInteger(n);
                    }
                    this.lastConnection = string18;
                    return new XOMInteger(statement.getUpdateCount());
                }
                catch (SQLException sQLException) {
                    throw new XNScriptError("SQL error: " + sQLException.getMessage());
                }
            }
        }
    };
    private static final XNModule.Function f_atob = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 1, 2, true);
            String string2 = list.size() > 1 ? ((XOMVariant)list.get(1)).toTextString(xNContext) : "base64";
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.equalsIgnoreCase("b64") || string2.equalsIgnoreCase("base64")) {
                return new XOMBinary(Base64.decodeBase64(string3));
            }
            if (string2.equalsIgnoreCase("uu") || string2.equalsIgnoreCase("uud") || string2.equalsIgnoreCase("uudecode")) {
                return new XOMBinary(Base64.decodeUU(string3));
            }
            if (string2.equalsIgnoreCase("xx") || string2.equalsIgnoreCase("xxd") || string2.equalsIgnoreCase("xxdecode")) {
                return new XOMBinary(Base64.decodeXX(string3));
            }
            if (string2.equalsIgnoreCase("hqx") || string2.equalsIgnoreCase("binhex")) {
                return new XOMBinary(Base64.decodeBinHex(string3));
            }
            if (string2.equalsIgnoreCase("a85") || string2.equalsIgnoreCase("ascii85")) {
                return new XOMBinary(Base64.decodeASCII85(string3));
            }
            if (string2.equalsIgnoreCase("k85") || string2.equalsIgnoreCase("kreative85")) {
                return new XOMBinary(Base64.decodeKreative85(string3));
            }
            if (string2.equalsIgnoreCase("l85") || string2.equalsIgnoreCase("legacy85")) {
                return new XOMBinary(Base64.decodeLegacy85(string3));
            }
            return XOMEmpty.EMPTY;
        }
    };
    private static final XNModule.Function f_bitmingle = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            BigInteger bigInteger;
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            BigInteger bigInteger2 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(0), true)).toBigInteger();
            BigInteger bigInteger3 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(1), true)).toBigInteger();
            if (bigInteger2 == null || bigInteger3 == null) {
                return XOMInteger.NaN;
            }
            if (bigInteger2.signum() < 0 && bigInteger3.signum() < 0) {
                bigInteger = BigInteger.ONE.negate();
            } else {
                if (bigInteger2.signum() < 0 || bigInteger3.signum() < 0) {
                    return XOMInteger.NaN;
                }
                bigInteger = BigInteger.ZERO;
            }
            int n = Math.max(bigInteger2.bitLength(), bigInteger3.bitLength());
            for (int i = 0; i <= n; ++i) {
                bigInteger = bigInteger3.testBit(i) ? bigInteger.setBit(i + i) : bigInteger.clearBit(i + i);
                bigInteger = bigInteger2.testBit(i) ? bigInteger.setBit(i + i + 1) : bigInteger.clearBit(i + i + 1);
            }
            return new XOMInteger(bigInteger);
        }
    };
    private static final XNModule.Function f_bitselect = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(0), true)).toBigInteger();
            BigInteger bigInteger2 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(1), true)).toBigInteger();
            if (bigInteger == null || bigInteger2 == null) {
                return XOMInteger.NaN;
            }
            BigInteger bigInteger3 = bigInteger.signum() < 0 && bigInteger2.signum() < 0 ? BigInteger.ONE.negate() : BigInteger.ZERO;
            int n = 0;
            int n2 = Math.max(bigInteger.bitLength(), bigInteger2.bitLength());
            for (int i = 0; i <= n2; ++i) {
                if (!bigInteger2.testBit(i)) continue;
                bigInteger3 = bigInteger.testBit(i) ? bigInteger3.setBit(n) : bigInteger3.clearBit(n);
                ++n;
            }
            return new XOMInteger(bigInteger3);
        }
    };
    private static final XNModule.Function f_btoa = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 1, 2, true);
            String string2 = list.size() > 1 ? ((XOMVariant)list.get(1)).toTextString(xNContext) : "base64";
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(0))).toByteArray();
            if (string2.equalsIgnoreCase("b64") || string2.equalsIgnoreCase("base64")) {
                return new XOMString(Base64.encodeBase64(byArray));
            }
            if (string2.equalsIgnoreCase("uu") || string2.equalsIgnoreCase("uue") || string2.equalsIgnoreCase("uuencode")) {
                return new XOMString(Base64.encodeUU(byArray));
            }
            if (string2.equalsIgnoreCase("xx") || string2.equalsIgnoreCase("xxe") || string2.equalsIgnoreCase("xxencode")) {
                return new XOMString(Base64.encodeXX(byArray));
            }
            if (string2.equalsIgnoreCase("hqx") || string2.equalsIgnoreCase("binhex")) {
                return new XOMString(Base64.encodeBinHex(byArray));
            }
            if (string2.equalsIgnoreCase("a85") || string2.equalsIgnoreCase("ascii85")) {
                return new XOMString(Base64.encodeASCII85(byArray));
            }
            if (string2.equalsIgnoreCase("k85") || string2.equalsIgnoreCase("kreative85")) {
                return new XOMString(Base64.encodeKreative85(byArray));
            }
            if (string2.equalsIgnoreCase("l85") || string2.equalsIgnoreCase("legacy85")) {
                return new XOMString(Base64.encodeLegacy85(byArray));
            }
            return XOMEmpty.EMPTY;
        }
    };
    private static final XNModule.Function f_getenv = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to getenv");
            }
            String string2 = xOMVariant.toTextString(xNContext);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string, "Variable", string2)) {
                throw new XNScriptError("Security settings do not allow getenv");
            }
            if (string2.length() == 0) {
                Set<String> set = System.getenv().keySet();
                Vector<String> vector = new Vector<String>();
                vector.addAll(set);
                Collections.sort(vector, String.CASE_INSENSITIVE_ORDER);
                Vector<XOMString> vector2 = new Vector<XOMString>();
                for (String string3 : vector) {
                    vector2.add(new XOMString(string3));
                }
                return new XOMList(vector2);
            }
            String string4 = System.getenv(string2);
            return string4 == null ? XOMString.EMPTY_STRING : new XOMString(string4);
        }
    };
    private static final XNModule.Function f_heapspace = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNExtendedModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow heapSpace");
            }
            return new XOMInteger(Runtime.getRuntime().freeMemory());
        }
    };
    private static final XNModule.Function f_htmldecode = new XNModule.Function(){
        private Map<String, Character> entityMap = null;

        private Map<String, Character> entityMap() {
            if (this.entityMap == null) {
                this.entityMap = new HashMap<String, Character>();
                this.entityMap.put("amp", Character.valueOf('&'));
                this.entityMap.put("lt", Character.valueOf('<'));
                this.entityMap.put("gt", Character.valueOf('>'));
                this.entityMap.put("quot", Character.valueOf('\"'));
                this.entityMap.put("apos", Character.valueOf('\''));
                this.entityMap.put("nbsp", Character.valueOf('\u00a0'));
                this.entityMap.put("iexcl", Character.valueOf('\u00a1'));
                this.entityMap.put("cent", Character.valueOf('\u00a2'));
                this.entityMap.put("pound", Character.valueOf('\u00a3'));
                this.entityMap.put("curren", Character.valueOf('\u00a4'));
                this.entityMap.put("yen", Character.valueOf('\u00a5'));
                this.entityMap.put("brvbar", Character.valueOf('\u00a6'));
                this.entityMap.put("sect", Character.valueOf('\u00a7'));
                this.entityMap.put("uml", Character.valueOf('\u00a8'));
                this.entityMap.put("copy", Character.valueOf('\u00a9'));
                this.entityMap.put("ordf", Character.valueOf('\u00aa'));
                this.entityMap.put("laquo", Character.valueOf('\u00ab'));
                this.entityMap.put("not", Character.valueOf('\u00ac'));
                this.entityMap.put("shy", Character.valueOf('\u00ad'));
                this.entityMap.put("reg", Character.valueOf('\u00ae'));
                this.entityMap.put("macr", Character.valueOf('\u00af'));
                this.entityMap.put("deg", Character.valueOf('\u00b0'));
                this.entityMap.put("plusmn", Character.valueOf('\u00b1'));
                this.entityMap.put("sup2", Character.valueOf('\u00b2'));
                this.entityMap.put("sup3", Character.valueOf('\u00b3'));
                this.entityMap.put("acute", Character.valueOf('\u00b4'));
                this.entityMap.put("micro", Character.valueOf('\u00b5'));
                this.entityMap.put("para", Character.valueOf('\u00b6'));
                this.entityMap.put("middot", Character.valueOf('\u00b7'));
                this.entityMap.put("cedil", Character.valueOf('\u00b8'));
                this.entityMap.put("sup1", Character.valueOf('\u00b9'));
                this.entityMap.put("ordm", Character.valueOf('\u00ba'));
                this.entityMap.put("raquo", Character.valueOf('\u00bb'));
                this.entityMap.put("frac14", Character.valueOf('\u00bc'));
                this.entityMap.put("frac12", Character.valueOf('\u00bd'));
                this.entityMap.put("frac34", Character.valueOf('\u00be'));
                this.entityMap.put("iquest", Character.valueOf('\u00bf'));
                this.entityMap.put("Agrave", Character.valueOf('\u00c0'));
                this.entityMap.put("Aacute", Character.valueOf('\u00c1'));
                this.entityMap.put("Acirc", Character.valueOf('\u00c2'));
                this.entityMap.put("Atilde", Character.valueOf('\u00c3'));
                this.entityMap.put("Auml", Character.valueOf('\u00c4'));
                this.entityMap.put("Aring", Character.valueOf('\u00c5'));
                this.entityMap.put("AElig", Character.valueOf('\u00c6'));
                this.entityMap.put("Ccedil", Character.valueOf('\u00c7'));
                this.entityMap.put("Egrave", Character.valueOf('\u00c8'));
                this.entityMap.put("Eacute", Character.valueOf('\u00c9'));
                this.entityMap.put("Ecirc", Character.valueOf('\u00ca'));
                this.entityMap.put("Euml", Character.valueOf('\u00cb'));
                this.entityMap.put("Igrave", Character.valueOf('\u00cc'));
                this.entityMap.put("Iacute", Character.valueOf('\u00cd'));
                this.entityMap.put("Icirc", Character.valueOf('\u00ce'));
                this.entityMap.put("Iuml", Character.valueOf('\u00cf'));
                this.entityMap.put("ETH", Character.valueOf('\u00d0'));
                this.entityMap.put("Ntilde", Character.valueOf('\u00d1'));
                this.entityMap.put("Ograve", Character.valueOf('\u00d2'));
                this.entityMap.put("Oacute", Character.valueOf('\u00d3'));
                this.entityMap.put("Ocirc", Character.valueOf('\u00d4'));
                this.entityMap.put("Otilde", Character.valueOf('\u00d5'));
                this.entityMap.put("Ouml", Character.valueOf('\u00d6'));
                this.entityMap.put("times", Character.valueOf('\u00d7'));
                this.entityMap.put("Oslash", Character.valueOf('\u00d8'));
                this.entityMap.put("Ugrave", Character.valueOf('\u00d9'));
                this.entityMap.put("Uacute", Character.valueOf('\u00da'));
                this.entityMap.put("Ucirc", Character.valueOf('\u00db'));
                this.entityMap.put("Uuml", Character.valueOf('\u00dc'));
                this.entityMap.put("Yacute", Character.valueOf('\u00dd'));
                this.entityMap.put("THORN", Character.valueOf('\u00de'));
                this.entityMap.put("szlig", Character.valueOf('\u00df'));
                this.entityMap.put("agrave", Character.valueOf('\u00e0'));
                this.entityMap.put("aacute", Character.valueOf('\u00e1'));
                this.entityMap.put("acirc", Character.valueOf('\u00e2'));
                this.entityMap.put("atilde", Character.valueOf('\u00e3'));
                this.entityMap.put("auml", Character.valueOf('\u00e4'));
                this.entityMap.put("aring", Character.valueOf('\u00e5'));
                this.entityMap.put("aelig", Character.valueOf('\u00e6'));
                this.entityMap.put("ccedil", Character.valueOf('\u00e7'));
                this.entityMap.put("egrave", Character.valueOf('\u00e8'));
                this.entityMap.put("eacute", Character.valueOf('\u00e9'));
                this.entityMap.put("ecirc", Character.valueOf('\u00ea'));
                this.entityMap.put("euml", Character.valueOf('\u00eb'));
                this.entityMap.put("igrave", Character.valueOf('\u00ec'));
                this.entityMap.put("iacute", Character.valueOf('\u00ed'));
                this.entityMap.put("icirc", Character.valueOf('\u00ee'));
                this.entityMap.put("iuml", Character.valueOf('\u00ef'));
                this.entityMap.put("eth", Character.valueOf('\u00f0'));
                this.entityMap.put("ntilde", Character.valueOf('\u00f1'));
                this.entityMap.put("ograve", Character.valueOf('\u00f2'));
                this.entityMap.put("oacute", Character.valueOf('\u00f3'));
                this.entityMap.put("ocirc", Character.valueOf('\u00f4'));
                this.entityMap.put("otilde", Character.valueOf('\u00f5'));
                this.entityMap.put("ouml", Character.valueOf('\u00f6'));
                this.entityMap.put("divide", Character.valueOf('\u00f7'));
                this.entityMap.put("oslash", Character.valueOf('\u00f8'));
                this.entityMap.put("ugrave", Character.valueOf('\u00f9'));
                this.entityMap.put("uacute", Character.valueOf('\u00fa'));
                this.entityMap.put("ucirc", Character.valueOf('\u00fb'));
                this.entityMap.put("uuml", Character.valueOf('\u00fc'));
                this.entityMap.put("yacute", Character.valueOf('\u00fd'));
                this.entityMap.put("thorn", Character.valueOf('\u00fe'));
                this.entityMap.put("yuml", Character.valueOf('\u00ff'));
                this.entityMap.put("OElig", Character.valueOf('\u0152'));
                this.entityMap.put("oelig", Character.valueOf('\u0153'));
                this.entityMap.put("Scaron", Character.valueOf('\u0160'));
                this.entityMap.put("scaron", Character.valueOf('\u0161'));
                this.entityMap.put("Yuml", Character.valueOf('\u0178'));
                this.entityMap.put("fnof", Character.valueOf('\u0192'));
                this.entityMap.put("circ", Character.valueOf('\u02c6'));
                this.entityMap.put("tilde", Character.valueOf('\u02dc'));
                this.entityMap.put("Alpha", Character.valueOf('\u0391'));
                this.entityMap.put("Beta", Character.valueOf('\u0392'));
                this.entityMap.put("Gamma", Character.valueOf('\u0393'));
                this.entityMap.put("Delta", Character.valueOf('\u0394'));
                this.entityMap.put("Epsilon", Character.valueOf('\u0395'));
                this.entityMap.put("Zeta", Character.valueOf('\u0396'));
                this.entityMap.put("Eta", Character.valueOf('\u0397'));
                this.entityMap.put("Theta", Character.valueOf('\u0398'));
                this.entityMap.put("Iota", Character.valueOf('\u0399'));
                this.entityMap.put("Kappa", Character.valueOf('\u039a'));
                this.entityMap.put("Lambda", Character.valueOf('\u039b'));
                this.entityMap.put("Mu", Character.valueOf('\u039c'));
                this.entityMap.put("Nu", Character.valueOf('\u039d'));
                this.entityMap.put("Xi", Character.valueOf('\u039e'));
                this.entityMap.put("Omicron", Character.valueOf('\u039f'));
                this.entityMap.put("Pi", Character.valueOf('\u03a0'));
                this.entityMap.put("Rho", Character.valueOf('\u03a1'));
                this.entityMap.put("Sigma", Character.valueOf('\u03a3'));
                this.entityMap.put("Tau", Character.valueOf('\u03a4'));
                this.entityMap.put("Upsilon", Character.valueOf('\u03a5'));
                this.entityMap.put("Phi", Character.valueOf('\u03a6'));
                this.entityMap.put("Chi", Character.valueOf('\u03a7'));
                this.entityMap.put("Psi", Character.valueOf('\u03a8'));
                this.entityMap.put("Omega", Character.valueOf('\u03a9'));
                this.entityMap.put("alpha", Character.valueOf('\u03b1'));
                this.entityMap.put("beta", Character.valueOf('\u03b2'));
                this.entityMap.put("gamma", Character.valueOf('\u03b3'));
                this.entityMap.put("delta", Character.valueOf('\u03b4'));
                this.entityMap.put("epsilon", Character.valueOf('\u03b5'));
                this.entityMap.put("zeta", Character.valueOf('\u03b6'));
                this.entityMap.put("eta", Character.valueOf('\u03b7'));
                this.entityMap.put("theta", Character.valueOf('\u03b8'));
                this.entityMap.put("iota", Character.valueOf('\u03b9'));
                this.entityMap.put("kappa", Character.valueOf('\u03ba'));
                this.entityMap.put("lambda", Character.valueOf('\u03bb'));
                this.entityMap.put("mu", Character.valueOf('\u03bc'));
                this.entityMap.put("nu", Character.valueOf('\u03bd'));
                this.entityMap.put("xi", Character.valueOf('\u03be'));
                this.entityMap.put("omicron", Character.valueOf('\u03bf'));
                this.entityMap.put("pi", Character.valueOf('\u03c0'));
                this.entityMap.put("rho", Character.valueOf('\u03c1'));
                this.entityMap.put("sigmaf", Character.valueOf('\u03c2'));
                this.entityMap.put("sigma", Character.valueOf('\u03c3'));
                this.entityMap.put("tau", Character.valueOf('\u03c4'));
                this.entityMap.put("upsilon", Character.valueOf('\u03c5'));
                this.entityMap.put("phi", Character.valueOf('\u03c6'));
                this.entityMap.put("chi", Character.valueOf('\u03c7'));
                this.entityMap.put("psi", Character.valueOf('\u03c8'));
                this.entityMap.put("omega", Character.valueOf('\u03c9'));
                this.entityMap.put("thetasym", Character.valueOf('\u03d1'));
                this.entityMap.put("upsih", Character.valueOf('\u03d2'));
                this.entityMap.put("piv", Character.valueOf('\u03d6'));
                this.entityMap.put("ensp", Character.valueOf('\u2002'));
                this.entityMap.put("emsp", Character.valueOf('\u2003'));
                this.entityMap.put("thinsp", Character.valueOf('\u2009'));
                this.entityMap.put("zwnj", Character.valueOf('\u200c'));
                this.entityMap.put("zwj", Character.valueOf('\u200d'));
                this.entityMap.put("lrm", Character.valueOf('\u200e'));
                this.entityMap.put("rlm", Character.valueOf('\u200f'));
                this.entityMap.put("ndash", Character.valueOf('\u2013'));
                this.entityMap.put("mdash", Character.valueOf('\u2014'));
                this.entityMap.put("lsquo", Character.valueOf('\u2018'));
                this.entityMap.put("rsquo", Character.valueOf('\u2019'));
                this.entityMap.put("sbquo", Character.valueOf('\u201a'));
                this.entityMap.put("ldquo", Character.valueOf('\u201c'));
                this.entityMap.put("rdquo", Character.valueOf('\u201d'));
                this.entityMap.put("bdquo", Character.valueOf('\u201e'));
                this.entityMap.put("dagger", Character.valueOf('\u2020'));
                this.entityMap.put("Dagger", Character.valueOf('\u2021'));
                this.entityMap.put("bull", Character.valueOf('\u2022'));
                this.entityMap.put("hellip", Character.valueOf('\u2026'));
                this.entityMap.put("permil", Character.valueOf('\u2030'));
                this.entityMap.put("prime", Character.valueOf('\u2032'));
                this.entityMap.put("Prime", Character.valueOf('\u2033'));
                this.entityMap.put("lsaquo", Character.valueOf('\u2039'));
                this.entityMap.put("rsaquo", Character.valueOf('\u203a'));
                this.entityMap.put("oline", Character.valueOf('\u203e'));
                this.entityMap.put("frasl", Character.valueOf('\u2044'));
                this.entityMap.put("euro", Character.valueOf('\u20ac'));
                this.entityMap.put("image", Character.valueOf('\u2111'));
                this.entityMap.put("weierp", Character.valueOf('\u2118'));
                this.entityMap.put("real", Character.valueOf('\u211c'));
                this.entityMap.put("trade", Character.valueOf('\u2122'));
                this.entityMap.put("alefsym", Character.valueOf('\u2135'));
                this.entityMap.put("larr", Character.valueOf('\u2190'));
                this.entityMap.put("uarr", Character.valueOf('\u2191'));
                this.entityMap.put("rarr", Character.valueOf('\u2192'));
                this.entityMap.put("darr", Character.valueOf('\u2193'));
                this.entityMap.put("harr", Character.valueOf('\u2194'));
                this.entityMap.put("crarr", Character.valueOf('\u21b5'));
                this.entityMap.put("lArr", Character.valueOf('\u21d0'));
                this.entityMap.put("uArr", Character.valueOf('\u21d1'));
                this.entityMap.put("rArr", Character.valueOf('\u21d2'));
                this.entityMap.put("dArr", Character.valueOf('\u21d3'));
                this.entityMap.put("hArr", Character.valueOf('\u21d4'));
                this.entityMap.put("forall", Character.valueOf('\u2200'));
                this.entityMap.put("part", Character.valueOf('\u2202'));
                this.entityMap.put("exist", Character.valueOf('\u2203'));
                this.entityMap.put("empty", Character.valueOf('\u2205'));
                this.entityMap.put("nabla", Character.valueOf('\u2207'));
                this.entityMap.put("isin", Character.valueOf('\u2208'));
                this.entityMap.put("notin", Character.valueOf('\u2209'));
                this.entityMap.put("ni", Character.valueOf('\u220b'));
                this.entityMap.put("prod", Character.valueOf('\u220f'));
                this.entityMap.put("sum", Character.valueOf('\u2211'));
                this.entityMap.put("minus", Character.valueOf('\u2212'));
                this.entityMap.put("lowast", Character.valueOf('\u2217'));
                this.entityMap.put("radic", Character.valueOf('\u221a'));
                this.entityMap.put("prop", Character.valueOf('\u221d'));
                this.entityMap.put("infin", Character.valueOf('\u221e'));
                this.entityMap.put("ang", Character.valueOf('\u2220'));
                this.entityMap.put("and", Character.valueOf('\u2227'));
                this.entityMap.put("or", Character.valueOf('\u2228'));
                this.entityMap.put("cap", Character.valueOf('\u2229'));
                this.entityMap.put("cup", Character.valueOf('\u222a'));
                this.entityMap.put("int", Character.valueOf('\u222b'));
                this.entityMap.put("there4", Character.valueOf('\u2234'));
                this.entityMap.put("sim", Character.valueOf('\u223c'));
                this.entityMap.put("cong", Character.valueOf('\u2245'));
                this.entityMap.put("asymp", Character.valueOf('\u2248'));
                this.entityMap.put("ne", Character.valueOf('\u2260'));
                this.entityMap.put("equiv", Character.valueOf('\u2261'));
                this.entityMap.put("le", Character.valueOf('\u2264'));
                this.entityMap.put("ge", Character.valueOf('\u2265'));
                this.entityMap.put("sub", Character.valueOf('\u2282'));
                this.entityMap.put("sup", Character.valueOf('\u2283'));
                this.entityMap.put("nsub", Character.valueOf('\u2284'));
                this.entityMap.put("sube", Character.valueOf('\u2286'));
                this.entityMap.put("supe", Character.valueOf('\u2287'));
                this.entityMap.put("oplus", Character.valueOf('\u2295'));
                this.entityMap.put("otimes", Character.valueOf('\u2297'));
                this.entityMap.put("perp", Character.valueOf('\u22a5'));
                this.entityMap.put("sdot", Character.valueOf('\u22c5'));
                this.entityMap.put("lceil", Character.valueOf('\u2308'));
                this.entityMap.put("rceil", Character.valueOf('\u2309'));
                this.entityMap.put("lfloor", Character.valueOf('\u230a'));
                this.entityMap.put("rfloor", Character.valueOf('\u230b'));
                this.entityMap.put("lang", Character.valueOf('\u2329'));
                this.entityMap.put("rang", Character.valueOf('\u232a'));
                this.entityMap.put("loz", Character.valueOf('\u25ca'));
                this.entityMap.put("spades", Character.valueOf('\u2660'));
                this.entityMap.put("clubs", Character.valueOf('\u2663'));
                this.entityMap.put("hearts", Character.valueOf('\u2665'));
                this.entityMap.put("diams", Character.valueOf('\u2666'));
            }
            return this.entityMap;
        }

        @Override
        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to htmldecode");
            }
            String string2 = xOMVariant.toTextString(xNContext);
            StringBuffer stringBuffer = new StringBuffer();
            while (string2.length() > 0) {
                String string3;
                int n = string2.indexOf(38);
                if (n < 0) {
                    stringBuffer.append(string2);
                    string2 = "";
                    break;
                }
                stringBuffer.append(string2.substring(0, n));
                string2 = string2.substring(n);
                int n2 = string2.indexOf(59);
                int n3 = string2.indexOf(38, 1);
                if (n2 < 0) {
                    stringBuffer.append(string2);
                    string2 = "";
                    break;
                }
                if (n3 >= 0 && n3 < n2) {
                    stringBuffer.append(string2.substring(0, n3));
                    string2 = string2.substring(n3);
                    continue;
                }
                String string4 = string2.substring(0, n2 + 1);
                string2 = string2.substring(n2 + 1);
                if (string4.toLowerCase().startsWith("&#x")) {
                    string3 = string4.substring(3, string4.length() - 1);
                    try {
                        stringBuffer.append(Character.toChars(Integer.parseInt(string3, 16)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string4);
                    }
                    continue;
                }
                if (string4.startsWith("&#")) {
                    string3 = string4.substring(2, string4.length() - 1);
                    try {
                        stringBuffer.append(Character.toChars(Integer.parseInt(string3)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string4);
                    }
                    continue;
                }
                string3 = string4.substring(1, string4.length() - 1);
                if (this.entityMap().containsKey(string3)) {
                    stringBuffer.append(this.entityMap().get(string3).charValue());
                    continue;
                }
                stringBuffer.append(string4);
            }
            return new XOMString(stringBuffer.toString());
        }
    };
    private static final XNModule.Function f_htmlencode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to htmlencode");
            }
            String string2 = xOMVariant.toTextString(xNContext);
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
            StringBuffer stringBuffer = new StringBuffer();
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&#39;");
                        break;
                    }
                    case '\u00a0': {
                        stringBuffer.append("&nbsp;");
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f') {
                            stringBuffer.append("&#" + c + ";");
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
                c = stringCharacterIterator.next();
            }
            return new XOMString(stringBuffer.toString());
        }
    };
    private static final XNModule.Function f_javaname = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNExtendedModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow javaName");
            }
            return new XOMString(System.getProperty("java.runtime.name"));
        }
    };
    private static final XNModule.Function f_javaversion = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNExtendedModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow javaVersion");
            }
            return new XOMString(System.getProperty("java.runtime.version"));
        }
    };
    private static final XNModule.Function f_pack = new XNModule.Function(){

        @Override
        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            byte[] byArray;
            List<DataField> list;
            List list2 = XNExtendedModule.listParameter(xNContext, string, xOMVariant, true);
            if (list2.size() < 1) {
                throw new XNScriptError("Can't understand arguments to " + string);
            }
            try {
                list = new DataFormatParser(new StringReader(((XOMVariant)list2.get(0)).toTextString(xNContext))).parseAuto();
            }
            catch (Exception exception) {
                throw new XNScriptError("Invalid format string: " + exception.getMessage());
            }
            List<Object> list3 = this.XOMtoNative(list, list2.subList(1, list2.size()), xNContext);
            try {
                byArray = new DataWriter(list).pack(list3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XNScriptError("Expected numeric value here");
            }
            catch (Exception exception) {
                throw new XNScriptError(exception.getMessage());
            }
            return new XOMBinary(byArray);
        }

        private List<Object> XOMtoNative(List<DataField> list, List<? extends XOMVariant> list2, XNContext xNContext) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<? extends XOMVariant> iterator = list2.iterator();
            for (DataField dataField : list) {
                if (!dataField.type().returns()) continue;
                XOMEmpty xOMEmpty = iterator.hasNext() ? iterator.next() : XOMEmpty.EMPTY;
                arrayList.add(this.XOMtoNativeWithCount(dataField, xOMEmpty, xNContext));
            }
            return arrayList;
        }

        private Object XOMtoNativeWithCount(DataField dataField, XOMVariant xOMVariant, XNContext xNContext) {
            if (dataField.count() == null || dataField.type().usesCustomCount()) {
                return this.XOMtoNativeWithoutCount(dataField, xOMVariant, xNContext);
            }
            List<? extends XOMVariant> list = xOMVariant.toPrimitiveList(xNContext);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (XOMVariant xOMVariant2 : list) {
                arrayList.add(this.XOMtoNativeWithoutCount(dataField, xOMVariant2, xNContext));
            }
            return arrayList;
        }

        private Object XOMtoNativeWithoutCount(DataField dataField, XOMVariant xOMVariant, XNContext xNContext) {
            switch (dataField.type()) {
                case BOOLEAN: {
                    return ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                }
                case ENUM: {
                    return xOMVariant.toTextString(xNContext);
                }
                case BITFIELD: {
                    return Arrays.asList(xOMVariant.toTextString(xNContext).split("\\s*,\\s*"));
                }
                case BINT: {
                    return xOMVariant.toTextString(xNContext);
                }
                case OINT: {
                    return xOMVariant.toTextString(xNContext);
                }
                case HINT: {
                    return xOMVariant.toTextString(xNContext);
                }
                case UINT: {
                    return ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                }
                case SINT: {
                    return ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                }
                case UFIXED: {
                    return ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigDecimal();
                }
                case SFIXED: {
                    return ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigDecimal();
                }
                case FLOAT: {
                    return ((XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toNumber();
                }
                case COMPLEX: {
                    return ((XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toNumbers();
                }
                case CHAR: {
                    return xOMVariant.toTextString(xNContext);
                }
                case PSTRING: {
                    return xOMVariant.toTextString(xNContext);
                }
                case CSTRING: {
                    return xOMVariant.toTextString(xNContext);
                }
                case DATE: {
                    return ((XOMDate)XOMDateType.instance.makeInstanceFrom(xNContext, xOMVariant)).toCalendar();
                }
                case COLOR: {
                    return ((XOMColor)XOMColorType.instance.makeInstanceFrom(xNContext, xOMVariant)).toRGBAFloatArray();
                }
                case BINARY: {
                    return ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, xOMVariant)).toByteArray();
                }
                case STRUCT: {
                    List list = (List)dataField.elaboration();
                    return this.XOMtoNative(list, xOMVariant.toPrimitiveList(xNContext), xNContext);
                }
            }
            throw new XNScriptError("Unknown data type: " + dataField.type().toString());
        }
    };
    private static final XNModule.Function f_regcountfields = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMInteger.ZERO;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            return new XOMInteger(string2.split(string3).length);
        }
    };
    private static final XNModule.Function f_regexplode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMString.EMPTY_STRING;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String[] stringArray = string2.split(string3);
            Vector<XOMString> vector = new Vector<XOMString>();
            for (String string4 : stringArray) {
                vector.add(new XOMString(string4));
            }
            return new XOMList(vector);
        }
    };
    private static final XNModule.Function f_reginstr = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matcher matcher = Pattern.compile(string3).matcher(string2);
            if (matcher.find()) {
                return new XOMInteger(matcher.start() + 1);
            }
            return XOMInteger.ZERO;
        }
    };
    private static final XNModule.Function f_regmatch = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            String string2;
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            return string3.matches(string2 = ((XOMVariant)list.get(1)).toTextString(xNContext)) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
        }
    };
    private static final XNModule.Function f_regnthfield = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMString.EMPTY_STRING;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String[] stringArray = string2.split(string3);
            int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(2), true)).toInt();
            if (n < 1 || n > stringArray.length) {
                return XOMString.EMPTY_STRING;
            }
            return new XOMString(stringArray[n - 1]);
        }
    };
    private static final XNModule.Function f_regoffset = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            Matcher matcher = Pattern.compile(string3).matcher(string2);
            if (matcher.find()) {
                return new XOMInteger(matcher.start() + 1);
            }
            return XOMInteger.ZERO;
        }
    };
    private static final XNModule.Function f_regreplace = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string4 = ((XOMVariant)list.get(2)).toTextString(xNContext);
            return new XOMString(string2.replaceFirst(string3, string4));
        }
    };
    private static final XNModule.Function f_regreplaceall = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string4 = ((XOMVariant)list.get(2)).toTextString(xNContext);
            return new XOMString(string2.replaceAll(string3, string4));
        }
    };
    private static final XNModule.Function f_regrinstr = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matcher matcher = Pattern.compile(string3).matcher(string2);
            int n = 0;
            while (matcher.find()) {
                n = matcher.start() + 1;
            }
            return new XOMInteger(n);
        }
    };
    private static final XNModule.Function f_trcountfields = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMInteger.ZERO;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            return new XOMInteger(matchor.split(string2).length);
        }
    };
    private static final XNModule.Function f_trexplode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMString.EMPTY_STRING;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            String[] stringArray = matchor.split(string2);
            Vector<XOMString> vector = new Vector<XOMString>();
            for (String string4 : stringArray) {
                vector.add(new XOMString(string4));
            }
            return new XOMList(vector);
        }
    };
    private static final XNModule.Function f_trinstr = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            return new XOMInteger(matchor.findIn(string2) + 1);
        }
    };
    private static final XNModule.Function f_trmatch = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            return matchor.matchesAll(string2) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
        }
    };
    private static final XNModule.Function f_trnthfield = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            if (string2.length() == 0) {
                return XOMString.EMPTY_STRING;
            }
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            String[] stringArray = matchor.split(string2);
            int n = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(2), true)).toInt();
            if (n < 1 || n > stringArray.length) {
                return XOMString.EMPTY_STRING;
            }
            return new XOMString(stringArray[n - 1]);
        }
    };
    private static final XNModule.Function f_troffset = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            return new XOMInteger(matchor.findIn(string2) + 1);
        }
    };
    private static final XNModule.Function f_trreplace = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            Transformor transformor;
            String string2;
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, 4, true);
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string4 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string5 = ((XOMVariant)list.get(2)).toTextString(xNContext);
            String string6 = string2 = list.size() > 3 ? ((XOMVariant)list.get(3)).toTextString(xNContext) : "";
            if (string4.startsWith("-")) {
                boolean bl = string4.contains("c");
                boolean bl2 = string4.contains("d");
                boolean bl3 = string4.contains("s");
                if (bl2) {
                    if (bl3) {
                        if (list.size() != 4) {
                            throw new XNScriptError("Can't understand arguments to " + string);
                        }
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        TrPattern trPattern2 = TrPattern.compile(string2, false);
                        transformor = new Multiplexor(trPattern.deletor(), trPattern2.squeezor());
                    } else {
                        if (list.size() != 3) {
                            throw new XNScriptError("Can't understand arguments to " + string);
                        }
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        transformor = trPattern.deletor();
                    }
                } else if (bl3) {
                    if (list.size() == 3) {
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        transformor = trPattern.squeezor();
                    } else {
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        TrPattern trPattern3 = TrPattern.compile(string2, false);
                        transformor = new Multiplexor(TrPattern.translator(trPattern, trPattern3), trPattern3.squeezor());
                    }
                } else {
                    if (list.size() != 4) {
                        throw new XNScriptError("Can't understand arguments to " + string);
                    }
                    TrPattern trPattern = TrPattern.compile(string5, bl);
                    TrPattern trPattern4 = TrPattern.compile(string2, false);
                    transformor = TrPattern.translator(trPattern, trPattern4);
                }
            } else {
                if (list.size() != 3) {
                    throw new XNScriptError("Can't understand arguments to " + string);
                }
                TrPattern trPattern = TrPattern.compile(string4, false);
                TrPattern trPattern5 = TrPattern.compile(string5, false);
                transformor = TrPattern.translator(trPattern, trPattern5);
            }
            return new XOMString(transformor.transformFirst(string3));
        }
    };
    private static final XNModule.Function f_trreplaceall = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            Transformor transformor;
            String string2;
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 3, 4, true);
            String string3 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string4 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            String string5 = ((XOMVariant)list.get(2)).toTextString(xNContext);
            String string6 = string2 = list.size() > 3 ? ((XOMVariant)list.get(3)).toTextString(xNContext) : "";
            if (string4.startsWith("-")) {
                boolean bl = string4.contains("c");
                boolean bl2 = string4.contains("d");
                boolean bl3 = string4.contains("s");
                if (bl2) {
                    if (bl3) {
                        if (list.size() != 4) {
                            throw new XNScriptError("Can't understand arguments to " + string);
                        }
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        TrPattern trPattern2 = TrPattern.compile(string2, false);
                        transformor = new Multiplexor(trPattern.deletor(), trPattern2.squeezor());
                    } else {
                        if (list.size() != 3) {
                            throw new XNScriptError("Can't understand arguments to " + string);
                        }
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        transformor = trPattern.deletor();
                    }
                } else if (bl3) {
                    if (list.size() == 3) {
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        transformor = trPattern.squeezor();
                    } else {
                        TrPattern trPattern = TrPattern.compile(string5, bl);
                        TrPattern trPattern3 = TrPattern.compile(string2, false);
                        transformor = new Multiplexor(TrPattern.translator(trPattern, trPattern3), trPattern3.squeezor());
                    }
                } else {
                    if (list.size() != 4) {
                        throw new XNScriptError("Can't understand arguments to " + string);
                    }
                    TrPattern trPattern = TrPattern.compile(string5, bl);
                    TrPattern trPattern4 = TrPattern.compile(string2, false);
                    transformor = TrPattern.translator(trPattern, trPattern4);
                }
            } else {
                if (list.size() != 3) {
                    throw new XNScriptError("Can't understand arguments to " + string);
                }
                TrPattern trPattern = TrPattern.compile(string4, false);
                TrPattern trPattern5 = TrPattern.compile(string5, false);
                transformor = TrPattern.translator(trPattern, trPattern5);
            }
            return new XOMString(transformor.transformAll(string3));
        }
    };
    private static final XNModule.Function f_trrinstr = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            String string3 = ((XOMVariant)list.get(1)).toTextString(xNContext);
            Matchor matchor = TrPattern.compile(string3, false).matchor();
            return new XOMInteger(matchor.findLastIn(string2) + 1);
        }
    };
    private static final XNModule.Function f_unpack = new XNModule.Function(){

        @Override
        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List<Object> list;
            List<DataField> list2;
            List list3 = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 2, true);
            try {
                list2 = new DataFormatParser(new StringReader(((XOMVariant)list3.get(0)).toTextString(xNContext))).parseAuto();
            }
            catch (Exception exception) {
                throw new XNScriptError("Invalid format string: " + exception.getMessage());
            }
            byte[] byArray = ((XOMBinary)XOMBinaryType.instance.makeInstanceFrom(xNContext, (XOMVariant)list3.get(1))).toByteArray();
            try {
                list = new DataReader(list2).unpack(new EndlessInputStream(new ByteArrayInputStream(byArray)), (long)byArray.length);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XNScriptError("Expected number here");
            }
            catch (EOFException eOFException) {
                throw new XNScriptError("Not enough data to unpack");
            }
            catch (Exception exception) {
                throw new XNScriptError(exception.getMessage());
            }
            return new XOMList(this.nativeToXOM(list2, list, xNContext));
        }

        private List<XOMVariant> nativeToXOM(List<DataField> list, List<Object> list2, XNContext xNContext) {
            ArrayList<XOMVariant> arrayList = new ArrayList<XOMVariant>();
            Iterator<Object> iterator = list2.iterator();
            for (DataField dataField : list) {
                if (!dataField.type().returns()) continue;
                Object object = iterator.hasNext() ? iterator.next() : null;
                arrayList.add(this.nativeToXOMwithCount(dataField, object, xNContext));
            }
            return arrayList;
        }

        private XOMVariant nativeToXOMwithCount(DataField dataField, Object object, XNContext xNContext) {
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2;
            if (dataField.count() == null || dataField.type().usesCustomCount()) {
                return this.nativeToXOMwithoutCount(dataField, object, xNContext);
            }
            if (object instanceof List) {
                arrayList2 = (ArrayList<Object>)object;
            } else {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
                arrayList2 = arrayList;
            }
            arrayList = new ArrayList();
            for (Object e : arrayList2) {
                arrayList.add(this.nativeToXOMwithoutCount(dataField, e, xNContext));
            }
            return new XOMList(arrayList);
        }

        private XOMVariant nativeToXOMwithoutCount(DataField dataField, Object object, XNContext xNContext) {
            switch (dataField.type()) {
                case BOOLEAN: {
                    return (Boolean)object != false ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                case ENUM: {
                    return new XOMString(object.toString());
                }
                case BITFIELD: {
                    List list = (List)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Object e : list) {
                        stringBuffer.append(e.toString());
                        stringBuffer.append(',');
                    }
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                    return new XOMString(stringBuffer.toString());
                }
                case BINT: {
                    return new XOMString(object.toString());
                }
                case OINT: {
                    return new XOMString(object.toString());
                }
                case HINT: {
                    return new XOMString(object.toString());
                }
                case UINT: {
                    return new XOMInteger((Number)object);
                }
                case SINT: {
                    return new XOMInteger((Number)object);
                }
                case UFIXED: {
                    return new XOMNumber((Number)object);
                }
                case SFIXED: {
                    return new XOMNumber((Number)object);
                }
                case FLOAT: {
                    return new XOMNumber((Number)object);
                }
                case COMPLEX: {
                    return new XOMComplex(new XOMNumber(((Number[])object)[0]), new XOMNumber(((Number[])object)[1]));
                }
                case CHAR: {
                    return new XOMString(object.toString());
                }
                case PSTRING: {
                    return new XOMString(object.toString());
                }
                case CSTRING: {
                    return new XOMString(object.toString());
                }
                case DATE: {
                    return new XOMDate((GregorianCalendar)object);
                }
                case COLOR: {
                    return new XOMColor((float[])object);
                }
                case BINARY: {
                    return new XOMBinary((byte[])object);
                }
                case STRUCT: {
                    ArrayList<Object> arrayList;
                    List list = (List)dataField.elaboration();
                    if (object instanceof List) {
                        arrayList = (ArrayList<Object>)object;
                    } else {
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        arrayList2.add(object);
                        arrayList = arrayList2;
                    }
                    return new XOMList(this.nativeToXOM(list, arrayList, xNContext));
                }
            }
            throw new XNScriptError("Unknown data type: " + dataField.type().toString());
        }
    };
    private static final XNModule.Function f_urldecode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to urldecode");
            }
            try {
                return new XOMString(URLDecoder.decode(xOMVariant.toTextString(xNContext), xNContext.getTextEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new XOMString(URLDecoder.decode(xOMVariant.toTextString(xNContext)));
            }
        }
    };
    private static final XNModule.Function f_urlencode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to urlencode");
            }
            try {
                return new XOMString(URLEncoder.encode(xOMVariant.toTextString(xNContext), xNContext.getTextEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new XOMString(URLEncoder.encode(xOMVariant.toTextString(xNContext)));
            }
        }
    };
    private static final XNModule.Function f_urlquerydecode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null) {
                throw new XNScriptError("Can't understand arguments to urlquerydecode");
            }
            String string2 = xOMVariant.toTextString(xNContext);
            Map<String, XOMVariant> map = XIONUtil.urlQueryDecode(xNContext, string2, xNContext.getTextEncoding());
            return new XOMDictionary(map);
        }
    };
    private static final XNModule.Function f_urlqueryencode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            if (xOMVariant == null || !XOMDictionaryType.instance.canMakeInstanceFrom(xNContext, xOMVariant)) {
                throw new XNScriptError("Can't understand arguments to urlqueryencode");
            }
            XOMDictionary xOMDictionary = XOMDictionaryType.instance.makeInstanceFrom(xNContext, xOMVariant);
            String string2 = XIONUtil.urlQueryEncode(xNContext, xOMDictionary.toMap(), xNContext.getTextEncoding());
            return new XOMString(string2);
        }
    };
    private static final XNModule.Function f_vmname = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNExtendedModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow vmName");
            }
            return new XOMString(System.getProperty("java.vm.name"));
        }
    };
    private static final XNModule.Function f_vmversion = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            XNExtendedModule.assertEmptyParameter(string, xOMVariant);
            if (!xNContext.allow(XNSecurityKey.SYSTEM_INFO, "Function", string)) {
                throw new XNScriptError("Security settings do not allow vmVersion");
            }
            return new XOMString(System.getProperty("java.vm.version"));
        }
    };
    private static final XNModule.Function f_ygndecode = new XNModule.Function(){
        private final Pattern XPATT = Pattern.compile("^=X([0-9A-F]+)=");
        private final Pattern BPATT = Pattern.compile("^(=B=)*=([ABQ])=");
        private final Pattern LPATT = Pattern.compile("^=([A-Z])=");

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 1, 2, true);
            boolean bl = list.size() > 1 ? ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(1))).toBoolean() : false;
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            StringBuffer stringBuffer = new StringBuffer();
            while (string2.length() > 0) {
                int n = string2.indexOf(61);
                if (n < 0) {
                    stringBuffer.append(string2);
                    string2 = "";
                    break;
                }
                stringBuffer.append(string2.substring(0, n));
                string2 = string2.substring(n);
                Matcher matcher = this.XPATT.matcher(string2);
                if (matcher.find() && matcher.start() == 0) {
                    String string3 = matcher.group(1);
                    string2 = string2.substring(matcher.end());
                    stringBuffer.append(Character.toChars(Integer.parseInt(string3, 16)));
                    continue;
                }
                if (bl && (matcher = this.BPATT.matcher(string2)).find() && matcher.start() == 0) {
                    char c = matcher.group(2).charAt(0);
                    string2 = string2.substring(matcher.end());
                    switch (c) {
                        case 'B': {
                            stringBuffer.append('\\');
                            break;
                        }
                        case 'A': {
                            stringBuffer.append('\'');
                            break;
                        }
                        case 'Q': {
                            stringBuffer.append('\"');
                        }
                    }
                    continue;
                }
                matcher = this.LPATT.matcher(string2);
                if (matcher.find() && matcher.start() == 0) {
                    char c = matcher.group(1).charAt(0);
                    string2 = string2.substring(matcher.end());
                    switch (c) {
                        case 'B': {
                            stringBuffer.append('\\');
                            break;
                        }
                        case 'A': {
                            stringBuffer.append('\'');
                            break;
                        }
                        case 'Q': {
                            stringBuffer.append('\"');
                            break;
                        }
                        case 'E': {
                            stringBuffer.append('=');
                            break;
                        }
                        case 'P': {
                            stringBuffer.append('%');
                            break;
                        }
                        case 'U': {
                            stringBuffer.append('_');
                            break;
                        }
                        case 'H': {
                            stringBuffer.append('?');
                            break;
                        }
                        case 'S': {
                            stringBuffer.append('*');
                            break;
                        }
                        case 'L': {
                            stringBuffer.append('<');
                            break;
                        }
                        case 'G': {
                            stringBuffer.append('>');
                            break;
                        }
                        case 'M': {
                            stringBuffer.append('&');
                            break;
                        }
                        case 'X': {
                            stringBuffer.append('!');
                            break;
                        }
                        case 'O': {
                            stringBuffer.append('#');
                            break;
                        }
                        case 'D': {
                            stringBuffer.append('$');
                            break;
                        }
                        case 'N': {
                            stringBuffer.append('+');
                            break;
                        }
                        case 'F': {
                            stringBuffer.append('/');
                            break;
                        }
                        case 'C': {
                            stringBuffer.append(':');
                            break;
                        }
                        case 'K': {
                            stringBuffer.append(';');
                            break;
                        }
                        case 'I': {
                            stringBuffer.append('[');
                            break;
                        }
                        case 'J': {
                            stringBuffer.append(']');
                            break;
                        }
                        case 'R': {
                            stringBuffer.append('^');
                            break;
                        }
                        case 'W': {
                            stringBuffer.append('`');
                            break;
                        }
                        case 'Y': {
                            stringBuffer.append('{');
                            break;
                        }
                        case 'V': {
                            stringBuffer.append('|');
                            break;
                        }
                        case 'Z': {
                            stringBuffer.append('}');
                            break;
                        }
                        case 'T': {
                            stringBuffer.append('~');
                        }
                    }
                    continue;
                }
                stringBuffer.append(string2.substring(0, 1));
                string2 = string2.substring(1);
            }
            return new XOMString(stringBuffer.toString());
        }
    };
    private static final XNModule.Function f_ygnencode = new XNModule.Function(){

        public XOMVariant evaluateFunction(XNContext xNContext, String string, XNModifier xNModifier, XOMVariant xOMVariant) {
            List list = XNExtendedModule.listParameter(xNContext, string, xOMVariant, 1, 3, true);
            boolean bl = list.size() > 2 ? ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(2))).toBoolean() : false;
            int n = list.size() > 1 ? ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, (XOMVariant)list.get(1), true)).toInt() : 0;
            String string2 = ((XOMVariant)list.get(0)).toTextString(xNContext);
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
            StringBuffer stringBuffer = new StringBuffer();
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                if (bl && c == '\\') {
                    while (c == '\\') {
                        c = stringCharacterIterator.next();
                    }
                    if (c == '\uffff') {
                        stringBuffer.append("=B=");
                        break;
                    }
                    if (c != '\'' && c != '\"') {
                        stringBuffer.append("=B=");
                    }
                }
                switch (c) {
                    case '\\': {
                        stringBuffer.append("=B=");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("=A=");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("=Q=");
                        break;
                    }
                    case '=': {
                        stringBuffer.append("=E=");
                        break;
                    }
                    case '%': {
                        if (n >= 0) {
                            stringBuffer.append("=P=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '_': {
                        if (n >= 0) {
                            stringBuffer.append("=U=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '?': {
                        if (n >= 0) {
                            stringBuffer.append("=H=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '*': {
                        if (n >= 0) {
                            stringBuffer.append("=S=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '<': {
                        if (n >= 1) {
                            stringBuffer.append("=L=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '>': {
                        if (n >= 1) {
                            stringBuffer.append("=G=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '&': {
                        if (n >= 1) {
                            stringBuffer.append("=M=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '!': {
                        if (n >= 2) {
                            stringBuffer.append("=X=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '#': {
                        if (n >= 2) {
                            stringBuffer.append("=O=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '$': {
                        if (n >= 2) {
                            stringBuffer.append("=D=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '+': {
                        if (n >= 2) {
                            stringBuffer.append("=N=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '/': {
                        if (n >= 2) {
                            stringBuffer.append("=F=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case ':': {
                        if (n >= 2) {
                            stringBuffer.append("=C=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case ';': {
                        if (n >= 2) {
                            stringBuffer.append("=K=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '[': {
                        if (n >= 2) {
                            stringBuffer.append("=I=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case ']': {
                        if (n >= 2) {
                            stringBuffer.append("=J=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '^': {
                        if (n >= 2) {
                            stringBuffer.append("=R=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '`': {
                        if (n >= 2) {
                            stringBuffer.append("=W=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '{': {
                        if (n >= 2) {
                            stringBuffer.append("=Y=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '|': {
                        if (n >= 2) {
                            stringBuffer.append("=V=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '}': {
                        if (n >= 2) {
                            stringBuffer.append("=Z=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '~': {
                        if (n >= 2) {
                            stringBuffer.append("=T=");
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        if (n >= 3 && (c < ' ' || c >= '\u007f')) {
                            stringBuffer.append("=X");
                            stringBuffer.append(Integer.toHexString(c).toUpperCase());
                            stringBuffer.append("=");
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
                c = stringCharacterIterator.next();
            }
            return new XOMString(stringBuffer.toString());
        }
    };
    private static final XNModule.ExternalLanguage e_applescript = new XNModule.ExternalLanguage(){

        public XOMVariant execute(String string) {
            String[] stringArray = string.split("\n|\r\n|\r|\u2028|\u2029");
            String[] stringArray2 = new String[stringArray.length * 2 + 1];
            stringArray2[0] = "osascript";
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i * 2 + 1] = "-e";
                stringArray2[i * 2 + 2] = stringArray[i];
            }
            try {
                String string2 = XIONUtil.captureProcessOutput(stringArray2);
                if (string2.endsWith("\r\n")) {
                    string2 = string2.substring(0, string2.length() - 2);
                } else if (string2.endsWith("\n") || string2.endsWith("\r")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return new XOMString(string2);
            }
            catch (IOException iOException) {
                throw new XNScriptError("Error running AppleScript: " + iOException.getMessage());
            }
        }
    };
    private static final XNModule.ExternalLanguage e_vbscript = new XNModule.ExternalLanguage(){

        public XOMVariant execute(String string) {
            File file;
            try {
                file = File.createTempFile("XNExt-", ".vbs");
            }
            catch (IOException iOException) {
                file = new File("XNExt-" + System.currentTimeMillis() + ".vbs");
                file.deleteOnExit();
            }
            try {
                String[] stringArray = string.split("\n|\r\n|\r|\u2028|\u2029");
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
                for (String string2 : stringArray) {
                    printWriter.println(string2);
                }
                printWriter.close();
                Object object = XIONUtil.captureProcessOutput(new String[]{"cmd", "/c", "start", "\"X\"", file.getAbsolutePath()});
                if (((String)object).endsWith("\r\n")) {
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                } else if (((String)object).endsWith("\n") || ((String)object).endsWith("\r")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                return new XOMString((String)object);
            }
            catch (IOException iOException) {
                throw new XNScriptError("Error running Windows Scripting Host: " + iOException.getMessage());
            }
        }
    };
    private static final XNModule.ExternalLanguage e_bash = new InterpreterLauncher("bash", "sh");
    private static final XNModule.ExternalLanguage e_perl = new InterpreterLauncher("perl", "pl");
    private static final XNModule.ExternalLanguage e_php = new InterpreterLauncher("php", "php");
    private static final XNModule.ExternalLanguage e_python = new InterpreterLauncher("python", "py");
    private static final XNModule.ExternalLanguage e_ruby = new InterpreterLauncher("ruby", "rb");

    public static final synchronized XNExtendedModule instance() {
        if (instance == null) {
            instance = new XNExtendedModule();
        }
        return instance;
    }

    private XNExtendedModule() {
        this.dataTypes.put("clipboard", XOMClipboardType.instance);
        this.dataTypes.put("clipboards", XOMClipboardType.listInstance);
        this.dataTypes.put("url", XOMURLType.instance);
        this.dataTypes.put("urls", XOMURLType.listInstance);
        this.commandParsers.put("sql", p_sql);
        this.commands.put("sql", c_sql);
        this.functions.put("atob", f_atob);
        this.functions.put("bitmingle", f_bitmingle);
        this.functions.put("bitselect", f_bitselect);
        this.functions.put("btoa", f_btoa);
        this.functions.put("getenv", f_getenv);
        this.functions.put("heapspace", f_heapspace);
        this.functions.put("htmldecode", f_htmldecode);
        this.functions.put("htmlencode", f_htmlencode);
        this.functions.put("javaname", f_javaname);
        this.functions.put("javaversion", f_javaversion);
        this.functions.put("pack", f_pack);
        this.functions.put("regcountfields", f_regcountfields);
        this.functions.put("regexplode", f_regexplode);
        this.functions.put("reginstr", f_reginstr);
        this.functions.put("regmatch", f_regmatch);
        this.functions.put("regnthfield", f_regnthfield);
        this.functions.put("regoffset", f_regoffset);
        this.functions.put("regreplace", f_regreplace);
        this.functions.put("regreplaceall", f_regreplaceall);
        this.functions.put("regrinstr", f_regrinstr);
        this.functions.put("trcountfields", f_trcountfields);
        this.functions.put("trexplode", f_trexplode);
        this.functions.put("trinstr", f_trinstr);
        this.functions.put("trmatch", f_trmatch);
        this.functions.put("trnthfield", f_trnthfield);
        this.functions.put("troffset", f_troffset);
        this.functions.put("trreplace", f_trreplace);
        this.functions.put("trreplaceall", f_trreplaceall);
        this.functions.put("trrinstr", f_trrinstr);
        this.functions.put("unpack", f_unpack);
        this.functions.put("urldecode", f_urldecode);
        this.functions.put("urlencode", f_urlencode);
        this.functions.put("urlquerydecode", f_urlquerydecode);
        this.functions.put("urlqueryencode", f_urlqueryencode);
        this.functions.put("vmname", f_vmname);
        this.functions.put("vmversion", f_vmversion);
        this.functions.put("ygndecode", f_ygndecode);
        this.functions.put("ygnencode", f_ygnencode);
        this.versions.put("extendedmodule", new XNModule.Version(MODULE_NAME, MODULE_VERSION));
        this.versions.put("java", new XNModule.Version(System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
        this.versions.put("javavm", new XNModule.Version(System.getProperty("java.vm.name"), System.getProperty("java.vm.version")));
        this.versions.put("vm", new XNModule.Version(System.getProperty("java.vm.name"), System.getProperty("java.vm.version")));
        this.ioManagers.add(XOMURLIOManager.instance);
        if (XIONUtil.isMacOS()) {
            this.externalLanguages.put("applescript", e_applescript);
        }
        if (XIONUtil.isWindows()) {
            this.externalLanguages.put("vbscript", e_vbscript);
        }
        if (!XIONUtil.isWindows()) {
            this.externalLanguages.put("bash", e_bash);
            this.externalLanguages.put("perl", e_perl);
            this.externalLanguages.put("php", e_php);
            this.externalLanguages.put("python", e_python);
            this.externalLanguages.put("ruby", e_ruby);
        }
    }

    public String toString() {
        return "XNExtendedModule";
    }

    private static XNExpression getTokenExpression(XNParser xNParser, String string) {
        if (xNParser.lookToken((int)1).image.equalsIgnoreCase(string)) {
            return new XNStringExpression(xNParser.getToken());
        }
        throw new XNParseError(string, xNParser.lookToken(1));
    }

    private static XNExpression getTokenExpression(XNParser xNParser, int n) {
        if (n < 1) {
            return new XNEmptyExpression(xNParser.getSource(), 0, 0);
        }
        XNToken xNToken = xNParser.getToken();
        --n;
        while (n > 0) {
            XNToken xNToken2 = xNParser.getToken();
            --n;
            XNToken xNToken3 = new XNToken(xNToken.kind, xNToken.image + " " + xNToken2.image, xNToken.source, xNToken.beginLine, xNToken.beginColumn, xNToken2.endLine, xNToken2.endColumn);
            xNToken3.specialToken = xNToken.specialToken;
            xNToken3.next = xNToken2.next;
            xNToken = xNToken3;
        }
        return new XNStringExpression(xNToken);
    }

    private static XNExpression createTokenExpression(XNParser xNParser, String string) {
        if (string == null || string.trim().length() == 0) {
            return new XNEmptyExpression(xNParser.getSource(), 0, 0);
        }
        return new XNStringExpression(new XNToken(3, string, xNParser.getSource(), 0, 0, 0, 0));
    }

    private static String myDescribeCommand(String string, List<XNExpression> list) {
        String string2 = "";
        for (XNExpression xNExpression : list) {
            if (xNExpression instanceof XNEmptyExpression) {
                XNEmptyExpression xNEmptyExpression = (XNEmptyExpression)xNExpression;
                if (xNEmptyExpression.getBeginCol() == 0 && xNEmptyExpression.getBeginLine() == 0) continue;
                string2 = string2 + " " + xNExpression.toString();
                continue;
            }
            string2 = string2 + " " + xNExpression.toString();
        }
        return string2.trim();
    }

    private static void assertEmptyParameter(String string, XOMVariant xOMVariant) {
        if (xOMVariant != null && !(xOMVariant instanceof XOMEmpty)) {
            throw new XNScriptError("Can't understand arguments to " + string);
        }
    }

    private static List<? extends XOMVariant> listParameter(XNContext xNContext, String string, XOMVariant xOMVariant, boolean bl) {
        Vector vector = xOMVariant == null ? new Vector() : (bl ? xOMVariant.toPrimitiveList(xNContext) : xOMVariant.toVariantList(xNContext));
        return vector;
    }

    private static List<? extends XOMVariant> listParameter(XNContext xNContext, String string, XOMVariant xOMVariant, int n, boolean bl) {
        Vector vector;
        List<Object> list = xOMVariant == null ? new Vector() : (vector = bl ? xOMVariant.toPrimitiveList(xNContext) : xOMVariant.toVariantList(xNContext));
        if (vector.size() != n) {
            throw new XNScriptError("Can't understand arguments to " + string);
        }
        return vector;
    }

    private static List<? extends XOMVariant> listParameter(XNContext xNContext, String string, XOMVariant xOMVariant, int n, int n2, boolean bl) {
        Vector vector;
        List<Object> list = xOMVariant == null ? new Vector() : (vector = bl ? xOMVariant.toPrimitiveList(xNContext) : xOMVariant.toVariantList(xNContext));
        if (vector.size() < n || vector.size() > n2) {
            throw new XNScriptError("Can't understand arguments to " + string);
        }
        return vector;
    }

    private static class InterpreterLauncher
    implements XNModule.ExternalLanguage {
        private String lang;
        private String ext;

        public InterpreterLauncher(String string, String string2) {
            this.lang = string;
            this.ext = string2;
        }

        public XOMVariant execute(String string) {
            File file;
            try {
                file = File.createTempFile("XNExt-", "." + this.ext);
            }
            catch (IOException iOException) {
                file = new File("XNExt-" + System.currentTimeMillis() + "." + this.ext);
                file.deleteOnExit();
            }
            try {
                String[] stringArray = string.split("\n|\r\n|\r|\u2028|\u2029");
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
                for (String string2 : stringArray) {
                    printWriter.println(string2);
                }
                printWriter.close();
                Object object = XIONUtil.captureProcessOutput(new String[]{this.lang, file.getAbsolutePath()});
                if (((String)object).endsWith("\r\n")) {
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                } else if (((String)object).endsWith("\n") || ((String)object).endsWith("\r")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                return new XOMString((String)object);
            }
            catch (IOException iOException) {
                throw new XNScriptError("Error running " + this.lang + ": " + iOException.getMessage());
            }
        }
    }
}

