/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion;

import com.kreative.openxion.XNAudioModule;
import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNExtendedModule;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.XNMessageExtractor;
import com.kreative.openxion.XNModule;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.XNSecurityProfile;
import com.kreative.openxion.XNSecurityValue;
import com.kreative.openxion.XNStandardModule;
import com.kreative.openxion.XNStdInOutUI;
import com.kreative.openxion.XNUI;
import com.kreative.openxion.ast.XNStringExpression;
import com.kreative.openxion.util.XIONUtil;
import com.kreative.openxion.xom.inst.XOMBoolean;
import com.kreative.openxion.xom.inst.XOMDictionary;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMBooleanType;
import com.kreative.openxion.xom.type.XOMDictionaryType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMStringType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;

public class XNMain {
    public static final String XION_NAME = "OpenXION";
    public static final String XION_VERSION = "1.4";

    public static void main(String[] stringArray) {
        XNStdInOutUI xNStdInOutUI = new XNStdInOutUI(true);
        XNContext xNContext = new XNContext(xNStdInOutUI);
        XNMain.readEnviron(xNContext);
        xNContext.loadModule(XNStandardModule.instance());
        xNContext.loadModule(XNExtendedModule.instance());
        xNContext.loadModule(XNAudioModule.instance());
        XNInterpreter xNInterpreter = new XNInterpreter(xNContext);
        if (stringArray.length == 0) {
            XNMain.shell(xNStdInOutUI, xNInterpreter, xNContext, false);
        } else {
            boolean bl = false;
            String string = "UTF-8";
            boolean bl2 = true;
            Option option = Option.SCRIPT_FILE;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            long l = System.currentTimeMillis();
            for (String string2 : stringArray) {
                if (bl2 && string2.startsWith("-")) {
                    if (string2.equals("-i")) {
                        bl = true;
                        XNMain.shell(xNStdInOutUI, xNInterpreter, xNContext, bl3);
                        continue;
                    }
                    if (string2.equals("-f")) {
                        option = Option.SCRIPT_FILE;
                        continue;
                    }
                    if (string2.equals("-e")) {
                        option = Option.EXPRESSION;
                        continue;
                    }
                    if (string2.equals("-c")) {
                        option = Option.STATEMENT;
                        continue;
                    }
                    if (string2.equals("-m")) {
                        option = Option.MODULE;
                        continue;
                    }
                    if (string2.equals("-E")) {
                        option = Option.TEXT_ENCODING;
                        continue;
                    }
                    if (string2.equals("-D")) {
                        option = Option.VARIABLE;
                        continue;
                    }
                    if (string2.equals("-s")) {
                        option = Option.SECURITY_PROFILE;
                        continue;
                    }
                    if (string2.equals("-M")) {
                        option = Option.MESSAGE_FILE;
                        continue;
                    }
                    if (string2.equals("-h") || string2.equals("-help") || string2.equals("--help")) {
                        bl = true;
                        XNMain.help(xNStdInOutUI);
                        continue;
                    }
                    if (string2.equals("-v") || string2.equals("-version") || string2.equals("--version")) {
                        bl = true;
                        XNMain.version(xNStdInOutUI);
                        continue;
                    }
                    if (string2.equals("-V")) {
                        for (Map.Entry iOException : System.getenv().entrySet()) {
                            xNContext.globalVariables().declareVariable(xNContext, (String)iOException.getKey(), XOMStringType.instance, new XOMString((String)iOException.getValue()));
                        }
                        continue;
                    }
                    if (string2.equals("-W")) {
                        XNMain.setCGIVariables(xNContext);
                        continue;
                    }
                    if (string2.equals("-p")) {
                        xNStdInOutUI.setFancyPrompts(false);
                        continue;
                    }
                    if (string2.equals("-P")) {
                        xNStdInOutUI.setFancyPrompts(true);
                        continue;
                    }
                    if (string2.equals("-r")) {
                        xNContext.reset();
                        continue;
                    }
                    if (string2.equals("-R")) {
                        xNContext.resetAll();
                        continue;
                    }
                    if (string2.equals("-S")) {
                        bl3 = true;
                        continue;
                    }
                    if (string2.equals("-T")) {
                        bl4 = true;
                        continue;
                    }
                    if (string2.equals("--")) {
                        bl2 = false;
                        continue;
                    }
                    System.err.println("Unrecognized option: " + string2);
                    continue;
                }
                switch (option) {
                    case SCRIPT_FILE: {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        bl = true;
                        if (bl4) {
                            ++n;
                            boolean bl5 = false;
                            xNStdInOutUI.println("Testing: " + string2 + "...");
                            ByteArrayOutputStream iOException = new ByteArrayOutputStream();
                            object4 = new PrintStream(iOException);
                            xNContext.setUI(new TestUI(xNStdInOutUI, (PrintStream)object4));
                            try {
                                xNContext.reset();
                                xNInterpreter.executeScriptFile(new File(string2), string);
                            }
                            catch (IOException iOException2) {
                                ((PrintStream)object4).println("Could not read script file: " + string2);
                                if (bl3) {
                                    iOException2.printStackTrace();
                                }
                            }
                            catch (XNScriptError xNScriptError) {
                                ((PrintStream)object4).println(xNScriptError.getMessage() + " on line " + xNScriptError.getLine() + " at character " + xNScriptError.getCol());
                                if (bl3) {
                                    xNScriptError.printStackTrace();
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.exit(0);
                            }
                            xNContext.setUI(xNStdInOutUI);
                            object3 = new ByteArrayInputStream(iOException.toByteArray());
                            try {
                                int n4;
                                object2 = Runtime.getRuntime().exec(new String[]{"diff", new File(string2 + ".out").getAbsolutePath(), "-"});
                                object = new byte[8192];
                                while ((n4 = ((InputStream)object3).read((byte[])object)) > 0) {
                                    ((Process)object2).getOutputStream().write((byte[])object, 0, n4);
                                }
                                ((Process)object2).getOutputStream().close();
                                while ((n4 = ((Process)object2).getInputStream().read((byte[])object)) > 0) {
                                    bl5 = true;
                                    System.out.write((byte[])object, 0, n4);
                                }
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                            if (bl5) {
                                ++n3;
                                break;
                            }
                            ++n2;
                            break;
                        }
                        try {
                            xNInterpreter.executeScriptFile(new File(string2), string);
                        }
                        catch (IOException iOException) {
                            System.err.println("Could not read script file: " + string2);
                            if (!bl3) break;
                            iOException.printStackTrace();
                        }
                        catch (XNScriptError xNScriptError) {
                            System.err.println(xNScriptError.getMessage() + " on line " + xNScriptError.getLine() + " at character " + xNScriptError.getCol());
                            if (!bl3) break;
                            xNScriptError.printStackTrace();
                        }
                        break;
                    }
                    case EXPRESSION: {
                        bl = true;
                        try {
                            xNStdInOutUI.println(xNInterpreter.evaluateExpressionString(string2).toTextString(xNContext));
                        }
                        catch (XNScriptError xNScriptError) {
                            System.err.println(xNScriptError.getMessage());
                            if (!bl3) break;
                            xNScriptError.printStackTrace();
                        }
                        break;
                    }
                    case STATEMENT: {
                        bl = true;
                        try {
                            xNInterpreter.executeScriptString(string2);
                        }
                        catch (XNScriptError xNScriptError) {
                            System.err.println(xNScriptError.getMessage());
                            if (!bl3) break;
                            xNScriptError.printStackTrace();
                        }
                        break;
                    }
                    case MODULE: {
                        Object object;
                        Object object4;
                        try {
                            object = Class.forName(string2);
                            Class<XNModule> clazz = ((Class)object).asSubclass(XNModule.class);
                            object4 = clazz.newInstance();
                            xNContext.loadModule((XNModule)object4);
                        }
                        catch (Exception exception) {
                            System.err.println("Could not load module: " + string2);
                            if (!bl3) break;
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case TEXT_ENCODING: {
                        string = string2;
                        break;
                    }
                    case VARIABLE: {
                        Object object = string2.split("=", 2);
                        if (((String[])object).length == 2) {
                            xNContext.globalVariables().declareVariable(xNContext, object[0], XOMStringType.instance, new XOMString(object[1]));
                            break;
                        }
                        System.err.println("Can't understand -D option: " + string2);
                        break;
                    }
                    case SECURITY_PROFILE: {
                        Object object3;
                        Object object4;
                        if (string2.equalsIgnoreCase("allow")) {
                            xNContext.setSecurityProfile(new XNSecurityProfile(XNSecurityValue.ALLOW));
                            break;
                        }
                        if (string2.equalsIgnoreCase("ask")) {
                            xNContext.setSecurityProfile(new XNSecurityProfile(XNSecurityValue.ASK));
                            break;
                        }
                        if (string2.equalsIgnoreCase("deny")) {
                            xNContext.setSecurityProfile(new XNSecurityProfile(XNSecurityValue.DENY));
                            break;
                        }
                        if (string2.matches("[A-Z0-9_]+=[A-Z0-9_]+")) {
                            String[] stringArray2 = string2.split("=", 2);
                            object4 = XNSecurityKey.valueOf(stringArray2[0]);
                            object3 = XNSecurityValue.valueOf(stringArray2[1]);
                            if (object4 != null && object3 != null) {
                                xNContext.getSecurityProfile().put(object4, object3);
                                break;
                            }
                            try {
                                xNContext.getSecurityProfile().read(new Scanner(new File(string2), "UTF-8"));
                            }
                            catch (IOException iOException) {
                                System.err.println("Could not load security profile: " + string2);
                            }
                            break;
                        }
                        try {
                            xNContext.getSecurityProfile().read(new Scanner(new File(string2), "UTF-8"));
                        }
                        catch (IOException iOException) {
                            System.err.println("Could not load security profile: " + string2);
                        }
                        break;
                    }
                    case MESSAGE_FILE: {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        bl = true;
                        try {
                            File file = new File(string2);
                            object4 = XIONUtil.getMessageFile(file);
                            object3 = XIONUtil.getTranslatedMessageFile(file);
                            object2 = XIONUtil.getLocalMessageFile(file);
                            object = new XNMessageExtractor(xNContext, string);
                            Map<String, List<XNStringExpression>> map = ((XNMessageExtractor)object).extractFromFile(file, string);
                            Map<String, String> map2 = XIONUtil.getMessagesFromMessageFile((File)object4, string);
                            Map<String, String> map3 = XIONUtil.getMessagesFromMessageFile((File)object3, string);
                            Map<String, String> map4 = XIONUtil.getMessagesFromMessageFile((File)object2, string);
                            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object4), string), true);
                            PrintWriter printWriter2 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), string), true);
                            PrintWriter printWriter3 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), string), true);
                            for (Map.Entry<String, List<XNStringExpression>> entry : map.entrySet()) {
                                String string3 = entry.getKey();
                                List<XNStringExpression> list = entry.getValue();
                                printWriter.println();
                                printWriter2.println();
                                printWriter3.println();
                                for (XNStringExpression xNStringExpression : list) {
                                    printWriter.println("# " + file.getName() + ", line " + xNStringExpression.getBeginLine() + ":");
                                    printWriter2.println("# " + file.getName() + ", line " + xNStringExpression.getBeginLine() + ":");
                                    printWriter3.println("# " + file.getName() + ", line " + xNStringExpression.getBeginLine() + ":");
                                }
                                printWriter.println(XIONUtil.quote(string3));
                                if (map2.containsKey(string3)) {
                                    printWriter.println(XIONUtil.quote(map2.get(string3)));
                                } else {
                                    printWriter.println("# NOT TRANSLATED");
                                    printWriter.println(XIONUtil.quote(string3));
                                }
                                printWriter2.println(XIONUtil.quote(string3));
                                if (map3.containsKey(string3)) {
                                    printWriter2.println(XIONUtil.quote(map3.get(string3)));
                                } else {
                                    printWriter2.println("# NOT TRANSLATED");
                                    printWriter2.println(XIONUtil.quote(string3));
                                }
                                printWriter3.println(XIONUtil.quote(string3));
                                if (map4.containsKey(string3)) {
                                    printWriter3.println(XIONUtil.quote(map4.get(string3)));
                                    continue;
                                }
                                printWriter3.println("# NOT TRANSLATED");
                                printWriter3.println(XIONUtil.quote(string3));
                            }
                            printWriter.close();
                            printWriter2.close();
                            printWriter3.close();
                            break;
                        }
                        catch (IOException iOException) {
                            System.err.println("Could not create message file: " + string2);
                        }
                    }
                }
                option = Option.SCRIPT_FILE;
            }
            if (n > 0) {
                xNStdInOutUI.println("PASSED: " + n2 + "/" + n + "  FAILED: " + n3 + "/" + n + "  TIME: " + (System.currentTimeMillis() - l) + " ms");
            }
            if (!bl) {
                XNMain.shell(xNStdInOutUI, xNInterpreter, xNContext, bl3);
            }
        }
        XNMain.writeEnviron(xNContext);
        System.exit(0);
    }

    private static void shell(XNStdInOutUI xNStdInOutUI, XNInterpreter xNInterpreter, XNContext xNContext, boolean bl) {
        String string;
        Vector<String> vector = new Vector<String>();
        boolean bl2 = false;
        while ((string = xNStdInOutUI.getCommandLine()) != null) {
            if (string.length() <= 0) continue;
            if (string.equalsIgnoreCase("exit") || string.equalsIgnoreCase("quit")) break;
            if (string.equalsIgnoreCase("help")) {
                XNMain.shellHelp(xNStdInOutUI);
                continue;
            }
            if (string.equalsIgnoreCase("version")) {
                XNMain.version(xNStdInOutUI);
                continue;
            }
            if (string.startsWith("--")) {
                int n;
                Object object;
                String string2;
                String[] stringArray = string.substring(2).trim().split("\\s+", 2);
                String string3 = stringArray[0];
                String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
                if (string3.equalsIgnoreCase("exit") || string3.equalsIgnoreCase("quit")) break;
                if (string3.equalsIgnoreCase("help")) {
                    XNMain.shellHelp(xNStdInOutUI);
                    continue;
                }
                if (string3.equalsIgnoreCase("version")) {
                    XNMain.version(xNStdInOutUI);
                    continue;
                }
                if (string3.equalsIgnoreCase("start")) {
                    bl2 = true;
                    continue;
                }
                if (string3.equalsIgnoreCase("stop")) {
                    bl2 = false;
                    continue;
                }
                if (string3.equalsIgnoreCase("new")) {
                    vector.clear();
                    continue;
                }
                if (string3.equalsIgnoreCase("list")) {
                    if (string2.length() > 0) {
                        object = string2.split("(\\s|,)+");
                        for (String string5 : object) {
                            if (string5.contains("-")) {
                                String[] stringArray2 = string5.split("-", 2);
                                try {
                                    int n2 = Integer.parseInt(stringArray2[0]) - 1;
                                    int n3 = Integer.parseInt(stringArray2[1]) - 1;
                                    for (n = Math.max(0, n2); n <= n3 && n < vector.size(); ++n) {
                                        String string6 = "      " + (n + 1) + ": ";
                                        xNStdInOutUI.println(string6.substring(string6.length() - 8) + (String)vector.get(n));
                                    }
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    continue;
                                }
                            }
                            try {
                                int n4 = Integer.parseInt(string5) - 1;
                                if (n4 < 0 || n4 >= vector.size()) continue;
                                String string7 = "      " + (n4 + 1) + ": ";
                                xNStdInOutUI.println(string7.substring(string7.length() - 8) + (String)vector.get(n4));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        String string8 = "      " + (i + 1) + ": ";
                        xNStdInOutUI.println(string8.substring(string8.length() - 8) + (String)vector.get(i));
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("run")) {
                    object = new StringBuffer();
                    for (String string9 : vector) {
                        ((StringBuffer)object).append(string9 + "\n");
                    }
                    try {
                        xNInterpreter.executeScriptString(((StringBuffer)object).toString());
                        continue;
                    }
                    catch (XNScriptError xNScriptError) {
                        if (bl) {
                            xNScriptError.printStackTrace();
                            break;
                        }
                        xNStdInOutUI.println(xNScriptError.getMessage());
                        break;
                    }
                }
                if (string3.equalsIgnoreCase("load")) {
                    try {
                        object = new File(string2);
                        Scanner scanner = new Scanner((File)object, "UTF-8");
                        vector.clear();
                        while (scanner.hasNextLine()) {
                            vector.add(scanner.nextLine().trim());
                        }
                        scanner.close();
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            iOException.printStackTrace();
                            continue;
                        }
                        xNStdInOutUI.println(iOException.getMessage());
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("save")) {
                    try {
                        object = new File(string2);
                        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"), true);
                        for (String string10 : vector) {
                            printWriter.println(string10);
                        }
                        printWriter.close();
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            iOException.printStackTrace();
                            continue;
                        }
                        xNStdInOutUI.println(iOException.getMessage());
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("add")) {
                    vector.addAll(Arrays.asList(string2.split("\r\n|\r|\n")));
                    continue;
                }
                if (string3.equalsIgnoreCase("insert")) {
                    try {
                        object = string2.split("\\s+", 2);
                        int n5 = Integer.parseInt((String)object[0]) - 1;
                        String string11 = ((Object)object).length > 1 ? object[1] : "";
                        vector.addAll(n5, Arrays.asList(string11.split("\r\n|\r|\n")));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (string3.equalsIgnoreCase("remove")) {
                    if (string2.length() <= 0) continue;
                    object = new TreeSet();
                    String[] stringArray3 = string2.split("(\\s|,)+");
                    for (String string12 : stringArray3) {
                        if (string12.contains("-")) {
                            String[] stringArray4 = string12.split("-", 2);
                            try {
                                int n6 = Integer.parseInt(stringArray4[0]) - 1;
                                n = Integer.parseInt(stringArray4[1]) - 1;
                                for (int i = Math.max(0, n6); i <= n && i < vector.size(); ++i) {
                                    object.add(i);
                                }
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                continue;
                            }
                        }
                        try {
                            int n7 = Integer.parseInt(string12) - 1;
                            if (n7 < 0 || n7 >= vector.size()) continue;
                            object.add(n7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Object[] objectArray = object.toArray(new Integer[0]);
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        vector.remove((Integer)objectArray[i]);
                    }
                    continue;
                }
                if (!string3.equalsIgnoreCase("set")) continue;
                try {
                    object = string2.split("\\s+", 2);
                    int n8 = Integer.parseInt((String)object[0]) - 1;
                    String string13 = ((Object)object).length > 1 ? object[1] : "";
                    vector.remove(n8);
                    vector.addAll(n8, Arrays.asList(string13.split("\r\n|\r|\n")));
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                xNInterpreter.executeScriptString(string);
                if (!bl2) continue;
                vector.addAll(Arrays.asList(string.split("\r\n|\r|\n")));
            }
            catch (XNScriptError xNScriptError) {
                try {
                    xNStdInOutUI.println(xNInterpreter.evaluateExpressionString(string).toTextString(xNContext));
                    if (!bl2) continue;
                    vector.addAll(Arrays.asList(("put " + string).split("\r\n|\r|\n")));
                }
                catch (XNScriptError xNScriptError2) {
                    if (bl) {
                        System.err.println("Attempted as statement:");
                        xNScriptError.printStackTrace();
                        System.err.println("Attempted as expression:");
                        xNScriptError2.printStackTrace();
                        continue;
                    }
                    xNStdInOutUI.println(xNScriptError.getMessage());
                }
            }
        }
    }

    private static void help(XNStdInOutUI xNStdInOutUI) {
        xNStdInOutUI.println("Usage: xion [options] [--] [programfile] [programfile] [...]");
        xNStdInOutUI.println("  -c statement        execute the specified statements");
        xNStdInOutUI.println("  -D var=value        set the value of a global variable");
        xNStdInOutUI.println("  -E encoding         specify the text encoding used to read script files");
        xNStdInOutUI.println("  -e expression       evaluate and print the specified expression");
        xNStdInOutUI.println("  -f programfile      execute the specified script file");
        xNStdInOutUI.println("  -h, --help          print help screen");
        xNStdInOutUI.println("  -i                  start an interactive shell");
        xNStdInOutUI.println("  -M programfile      generate a message file for localization");
        xNStdInOutUI.println("  -m classname        load an XNModule with the specified class name");
        xNStdInOutUI.println("  -P                  use fancy prompts simulating dialog boxes (default)");
        xNStdInOutUI.println("  -p                  use simple, more traditional prompts");
        xNStdInOutUI.println("  -R                  clear runtime state AND unload all modules");
        xNStdInOutUI.println("  -r                  clear runtime state ONLY");
        xNStdInOutUI.println("  -S                  print a stack trace for every exception");
        xNStdInOutUI.println("  -s allow|ask|deny   set security settings to allow|ask|deny every request");
        xNStdInOutUI.println("  -s key=value        set security setting for one kind of request only");
        xNStdInOutUI.println("  -s file             read security settings from file as key=value pairs");
        xNStdInOutUI.println("  -T                  instead of printing output, print file name and");
        xNStdInOutUI.println("                      diff of output against .out file (testing mode)");
        xNStdInOutUI.println("                      (-s allow recommended with this option)");
        xNStdInOutUI.println("  -V                  import environment variables as XION globals");
        xNStdInOutUI.println("  -v, --version       print OpenXION, Java, and OS version numbers");
        xNStdInOutUI.println("  -W                  import CGI environment variables as XION globals");
        xNStdInOutUI.println("  --                  treat remaining arguments as file names");
    }

    private static void shellHelp(XNStdInOutUI xNStdInOutUI) {
        xNStdInOutUI.println("Enter any XION statement to execute it.");
        xNStdInOutUI.println("Enter any XION expression to evaluate it.");
        xNStdInOutUI.println("Or, enter any of the following meta-commands:");
        xNStdInOutUI.println("  --start             start adding entered statements to the script buffer");
        xNStdInOutUI.println("  --stop              stop adding entered statements to the script buffer");
        xNStdInOutUI.println("  --new               clear the script buffer");
        xNStdInOutUI.println("  --list [linenums]   print the contents of the script buffer");
        xNStdInOutUI.println("  --run               execute the script in the script buffer");
        xNStdInOutUI.println("  --load filename     load the contents of a file into the script buffer");
        xNStdInOutUI.println("  --save filename     save the contents of the script buffer to a file");
        xNStdInOutUI.println("  --add statement     add the specified statements to the script buffer");
        xNStdInOutUI.println("  --insert lnum stmt  insert the specified statements at the specified line");
        xNStdInOutUI.println("  --remove linenums   remove the specified lines from the script buffer");
        xNStdInOutUI.println("  --set lnum stmt     replace the specified line with the specified statements");
        xNStdInOutUI.println("  help, --help        print help screen");
        xNStdInOutUI.println("  version, --version  print OpenXION, Java, and OS version numbers");
        xNStdInOutUI.println("  exit, --exit        quit OpenXION");
        xNStdInOutUI.println("  quit, --quit        quit OpenXION");
        xNStdInOutUI.println("End a line of input with a single backslash to continue the current line.");
        xNStdInOutUI.println("End with a double backslash to insert a line break and input the next line.");
    }

    private static void version(XNStdInOutUI xNStdInOutUI) {
        xNStdInOutUI.println("OpenXION 1.4");
        xNStdInOutUI.println(System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"));
        xNStdInOutUI.println(System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        xNStdInOutUI.println(System.getProperty("os.name") + " " + System.getProperty("os.version"));
    }

    private static void setCGIVariables(XNContext xNContext) {
        String string = System.getenv("CONTENT_LENGTH");
        XOMInteger xOMInteger = string == null || string.length() == 0 ? XOMInteger.ZERO : new XOMInteger(Integer.parseInt(string));
        xNContext.globalVariables().declareVariable(xNContext, "contentLength", XOMIntegerType.instance, xOMInteger);
        String string2 = System.getenv("DOCUMENT_ROOT");
        XOMString xOMString = string2 == null ? XOMString.EMPTY_STRING : new XOMString(string2);
        xNContext.globalVariables().declareVariable(xNContext, "documentRoot", XOMStringType.instance, xOMString);
        String string3 = System.getenv("HTTP_COOKIE");
        XOMString xOMString2 = string3 == null ? XOMString.EMPTY_STRING : new XOMString(string3);
        xNContext.globalVariables().declareVariable(xNContext, "httpCookie", XOMStringType.instance, xOMString2);
        String string4 = System.getenv("HTTP_HOST");
        XOMString xOMString3 = string4 == null ? XOMString.EMPTY_STRING : new XOMString(string4);
        xNContext.globalVariables().declareVariable(xNContext, "httpHost", XOMStringType.instance, xOMString3);
        String string5 = System.getenv("HTTP_REFERER");
        XOMString xOMString4 = string5 == null ? XOMString.EMPTY_STRING : new XOMString(string5);
        xNContext.globalVariables().declareVariable(xNContext, "httpReferrer", XOMStringType.instance, xOMString4);
        String string6 = System.getenv("HTTP_USER_AGENT");
        XOMString xOMString5 = string6 == null ? XOMString.EMPTY_STRING : new XOMString(string6);
        xNContext.globalVariables().declareVariable(xNContext, "httpUserAgent", XOMStringType.instance, xOMString5);
        String string7 = System.getenv("HTTPS");
        XOMBoolean xOMBoolean = string7 != null && string7.length() > 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
        xNContext.globalVariables().declareVariable(xNContext, "https", XOMBooleanType.instance, xOMBoolean);
        String string8 = System.getenv("PATH");
        XOMString xOMString6 = string8 == null ? XOMString.EMPTY_STRING : new XOMString(string8);
        xNContext.globalVariables().declareVariable(xNContext, "path", XOMStringType.instance, xOMString6);
        String string9 = System.getenv("PATH_INFO");
        XOMString xOMString7 = string9 == null ? XOMString.EMPTY_STRING : new XOMString(string9);
        xNContext.globalVariables().declareVariable(xNContext, "pathInfo", XOMStringType.instance, xOMString7);
        String string10 = System.getenv("PATH_TRANSLATED");
        XOMString xOMString8 = string10 == null ? XOMString.EMPTY_STRING : new XOMString(string10);
        xNContext.globalVariables().declareVariable(xNContext, "pathTranslated", XOMStringType.instance, xOMString8);
        String string11 = System.getenv("QUERY_STRING");
        XOMString xOMString9 = string11 == null ? XOMString.EMPTY_STRING : new XOMString(string11);
        xNContext.globalVariables().declareVariable(xNContext, "queryString", XOMStringType.instance, xOMString9);
        String string12 = System.getenv("REMOTE_ADDR");
        XOMString xOMString10 = string12 == null ? XOMString.EMPTY_STRING : new XOMString(string12);
        xNContext.globalVariables().declareVariable(xNContext, "remoteAddr", XOMStringType.instance, xOMString10);
        String string13 = System.getenv("REMOTE_HOST");
        XOMString xOMString11 = string13 == null ? XOMString.EMPTY_STRING : new XOMString(string13);
        xNContext.globalVariables().declareVariable(xNContext, "remoteHost", XOMStringType.instance, xOMString11);
        String string14 = System.getenv("REMOTE_PORT");
        XOMInteger xOMInteger2 = string14 == null || string14.length() == 0 ? XOMInteger.ZERO : new XOMInteger(Integer.parseInt(string14));
        xNContext.globalVariables().declareVariable(xNContext, "remotePort", XOMIntegerType.instance, xOMInteger2);
        String string15 = System.getenv("REMOTE_USER");
        XOMString xOMString12 = string15 == null ? XOMString.EMPTY_STRING : new XOMString(string15);
        xNContext.globalVariables().declareVariable(xNContext, "remoteUser", XOMStringType.instance, xOMString12);
        String string16 = System.getenv("REQUEST_METHOD");
        XOMString xOMString13 = string16 == null ? XOMString.EMPTY_STRING : new XOMString(string16);
        xNContext.globalVariables().declareVariable(xNContext, "requestMethod", XOMStringType.instance, xOMString13);
        String string17 = System.getenv("REQUEST_URI");
        XOMString xOMString14 = string17 == null ? XOMString.EMPTY_STRING : new XOMString(string17);
        xNContext.globalVariables().declareVariable(xNContext, "requestURI", XOMStringType.instance, xOMString14);
        String string18 = System.getenv("SCRIPT_FILENAME");
        XOMString xOMString15 = string18 == null ? XOMString.EMPTY_STRING : new XOMString(string18);
        xNContext.globalVariables().declareVariable(xNContext, "scriptFileName", XOMStringType.instance, xOMString15);
        String string19 = System.getenv("SCRIPT_NAME");
        XOMString xOMString16 = string19 == null ? XOMString.EMPTY_STRING : new XOMString(string19);
        xNContext.globalVariables().declareVariable(xNContext, "scriptName", XOMStringType.instance, xOMString16);
        String string20 = System.getenv("SERVER_ADMIN");
        XOMString xOMString17 = string20 == null ? XOMString.EMPTY_STRING : new XOMString(string20);
        xNContext.globalVariables().declareVariable(xNContext, "serverAdmin", XOMStringType.instance, xOMString17);
        String string21 = System.getenv("SERVER_NAME");
        XOMString xOMString18 = string21 == null ? XOMString.EMPTY_STRING : new XOMString(string21);
        xNContext.globalVariables().declareVariable(xNContext, "serverName", XOMStringType.instance, xOMString18);
        String string22 = System.getenv("SERVER_PORT");
        XOMInteger xOMInteger3 = string22 == null || string22.length() == 0 ? XOMInteger.ZERO : new XOMInteger(Integer.parseInt(string22));
        xNContext.globalVariables().declareVariable(xNContext, "serverPort", XOMIntegerType.instance, xOMInteger3);
        String string23 = System.getenv("SERVER_SOFTWARE");
        XOMString xOMString19 = string23 == null ? XOMString.EMPTY_STRING : new XOMString(string23);
        xNContext.globalVariables().declareVariable(xNContext, "serverSoftware", XOMStringType.instance, xOMString19);
        XOMDictionary xOMDictionary = string11 == null ? XOMDictionary.EMPTY_DICTIONARY : new XOMDictionary(XIONUtil.urlQueryDecode(xNContext, string11, xNContext.getTextEncoding()));
        xNContext.globalVariables().declareVariable(xNContext, "get", XOMDictionaryType.instance, xOMDictionary);
        StringBuffer stringBuffer = new StringBuffer();
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextLine()) {
            stringBuffer.append(scanner.nextLine());
        }
        XOMDictionary xOMDictionary2 = new XOMDictionary(XIONUtil.urlQueryDecode(xNContext, stringBuffer.toString(), xNContext.getTextEncoding()));
        xNContext.globalVariables().declareVariable(xNContext, "post", XOMDictionaryType.instance, xOMDictionary2);
    }

    private static File getEnvironFile() {
        String string = System.getProperty("os.name").toUpperCase();
        String string2 = System.getProperty("user.home");
        if (string.contains("MAC OS")) {
            File file = new File(string2);
            if (!(file = new File(file, "Library")).exists()) {
                file.mkdir();
            }
            if (!(file = new File(file, "Preferences")).exists()) {
                file.mkdir();
            }
            return new File(file, "com.kreative.openxion.conf");
        }
        if (string.contains("WINDOWS")) {
            File file = new File(string2);
            if (!(file = new File(file, "Application Data")).exists()) {
                file.mkdir();
            }
            if (!(file = new File(file, XION_NAME)).exists()) {
                file.mkdir();
            }
            return new File(file, "xion.conf");
        }
        File file = new File(string2);
        return new File(file, ".xion.conf");
    }

    private static void readEnviron(XNContext xNContext) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            Scanner scanner = new Scanner(XNMain.getEnvironFile(), "UTF-8");
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                if (string.startsWith("Applications=")) {
                    stringBuffer.append(string.substring(13) + "\n");
                }
                if (string.startsWith("Documents=")) {
                    stringBuffer2.append(string.substring(10) + "\n");
                }
                if (!string.startsWith("Includes=")) continue;
                stringBuffer3.append(string.substring(9) + "\n");
            }
            scanner.close();
            if (stringBuffer.length() > 0) {
                xNContext.setApplicationPaths(stringBuffer.toString());
            }
            if (stringBuffer2.length() > 0) {
                xNContext.setDocumentPaths(stringBuffer2.toString());
            }
            if (stringBuffer3.length() > 0) {
                xNContext.setIncludePaths(stringBuffer3.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeEnviron(XNContext xNContext) {
        try {
            String[] stringArray;
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(XNMain.getEnvironFile()), "UTF-8"), true);
            String string = xNContext.getApplicationPaths();
            String string2 = xNContext.getDocumentPaths();
            String string3 = xNContext.getIncludePaths();
            if (string != null) {
                for (String string4 : stringArray = string.split("\r|\n")) {
                    if (string4.length() <= 0) continue;
                    printWriter.println("Applications=" + string4);
                }
            }
            if (string2 != null) {
                for (String string4 : stringArray = string2.split("\r|\n")) {
                    if (string4.length() <= 0) continue;
                    printWriter.println("Documents=" + string4);
                }
            }
            if (string3 != null) {
                for (String string4 : stringArray = string2.split("\r|\n")) {
                    if (string4.length() <= 0) continue;
                    printWriter.println("Includes=" + string4);
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestUI
    implements XNUI {
        private XNUI ui;
        private PrintWriter put;

        public TestUI(XNUI xNUI, PrintStream printStream) {
            this.ui = xNUI;
            try {
                this.put = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)printStream, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.put = new PrintWriter((Writer)new OutputStreamWriter(printStream), true);
            }
        }

        @Override
        public void put(String string) {
            this.put.println(string);
        }

        @Override
        public String answer(String string, String[] stringArray, int n, int n2) {
            return this.ui.answer(string, stringArray, n, n2);
        }

        @Override
        public File answerDisk(String string, int n, int n2) {
            return this.ui.answerDisk(string, n, n2);
        }

        @Override
        public File answerFile(String string, String[] stringArray, int n, int n2) {
            return this.ui.answerFile(string, stringArray, n, n2);
        }

        @Override
        public File answerFolder(String string, int n, int n2) {
            return this.ui.answerFolder(string, n, n2);
        }

        @Override
        public String answerList(String string, String[] stringArray, int n, int n2) {
            return this.ui.answerList(string, stringArray, n, n2);
        }

        @Override
        public String ask(String string, String string2, int n, int n2) {
            return this.ui.ask(string, string2, n, n2);
        }

        @Override
        public File askFile(String string, String string2, int n, int n2) {
            return this.ui.askFile(string, string2, n, n2);
        }

        @Override
        public File askFolder(String string, String string2, int n, int n2) {
            return this.ui.askFolder(string, string2, n, n2);
        }

        @Override
        public String askPassword(String string, String string2, int n, int n2) {
            return this.ui.askPassword(string, string2, n, n2);
        }

        @Override
        public void beep() {
            this.ui.beep();
        }

        @Override
        public void promptSecurity(XNSecurityKey[] xNSecurityKeyArray, boolean[] blArray, boolean[] blArray2, Map<String, String>[] mapArray) {
            this.ui.promptSecurity(xNSecurityKeyArray, blArray, blArray2, mapArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Option {
        SCRIPT_FILE,
        EXPRESSION,
        STATEMENT,
        MODULE,
        TEXT_ENCODING,
        VARIABLE,
        SECURITY_PROFILE,
        MESSAGE_FILE;

    }
}

