/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.ast;

import com.kreative.openxion.XNToken;
import com.kreative.openxion.ast.XNHandlerParameter;
import com.kreative.openxion.ast.XNStatement;
import java.util.List;

public class XNMessageHandler
extends XNStatement {
    private static final long serialVersionUID = 117L;
    public XNToken messageToken;
    public String name;
    public List<XNHandlerParameter> parameters;
    public List<XNStatement> body;
    public XNToken endMessageToken;

    public int getMessageLine() {
        if (this.messageToken == null) {
            return 0;
        }
        return this.messageToken.beginLine;
    }

    public int getMessageCol() {
        if (this.messageToken == null) {
            return 0;
        }
        return this.messageToken.beginColumn;
    }

    public int getEndMessageLine() {
        if (this.endMessageToken == null) {
            return 0;
        }
        return this.endMessageToken.beginLine;
    }

    public int getEndMessageCol() {
        if (this.endMessageToken == null) {
            return 0;
        }
        return this.endMessageToken.beginColumn;
    }

    protected String toString(String string) {
        String string2 = string + "on " + this.name;
        if (this.parameters != null && this.parameters.size() > 0) {
            for (XNHandlerParameter cloneable : this.parameters) {
                string2 = string2 + " " + cloneable.toString() + ",";
            }
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (this.body != null) {
            for (XNStatement xNStatement : this.body) {
                string2 = string2 + "\n" + xNStatement.toString(string + "\t");
            }
        }
        string2 = string2 + "\n" + string + "end " + this.name;
        return string2;
    }
}

