/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.audio;

import com.kreative.openxion.audio.Note;

public class NoteParser {
    private int step = 0;
    private int octave = 4;
    private int dur = 64;
    private int vel = 127;

    public Note parseNote(String string) {
        int n;
        boolean bl = (string = string.trim().toLowerCase()).contains("r");
        if (bl) {
            string = string.replace("r", "");
        }
        int n2 = 0;
        int n3 = string.length();
        if (!bl) {
            if (n2 < n3) {
                switch (string.charAt(n2)) {
                    case 'C': 
                    case 'c': {
                        this.step = 0;
                        ++n2;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        this.step = 2;
                        ++n2;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        this.step = 4;
                        ++n2;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        this.step = 5;
                        ++n2;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        this.step = 7;
                        ++n2;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        this.step = 9;
                        ++n2;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.step = 11;
                        ++n2;
                        break;
                    }
                    case 'M': 
                    case 'N': 
                    case 'P': 
                    case 'm': 
                    case 'n': 
                    case 'p': {
                        ++n2;
                        n = 0;
                        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                            n = n * 10 + Character.getNumericValue(string.charAt(n2++));
                        }
                        this.step = n % 12;
                        this.octave = n / 12 - 1;
                    }
                }
            }
            while (n2 < n3 && string.charAt(n2) == 'b') {
                --this.step;
                ++n2;
            }
            while (n2 < n3 && string.charAt(n2) == '#') {
                ++this.step;
                ++n2;
            }
            if (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                this.octave = 0;
                while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                    this.octave = this.octave * 10 + Character.getNumericValue(string.charAt(n2++));
                }
            }
        }
        if (n2 < n3) {
            switch (string.charAt(n2)) {
                case 'w': {
                    this.dur = 256;
                    ++n2;
                    break;
                }
                case 'h': {
                    this.dur = 128;
                    ++n2;
                    break;
                }
                case 'q': {
                    this.dur = 64;
                    ++n2;
                    break;
                }
                case 'e': {
                    this.dur = 32;
                    ++n2;
                    break;
                }
                case 's': {
                    this.dur = 16;
                    ++n2;
                    break;
                }
                case 't': {
                    this.dur = 8;
                    ++n2;
                    break;
                }
                case 'x': {
                    this.dur = 4;
                    ++n2;
                    break;
                }
                case 'o': {
                    this.dur = 2;
                    ++n2;
                    break;
                }
                case 'd': {
                    ++n2;
                    this.dur = 0;
                    while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                        this.dur = this.dur * 10 + Character.getNumericValue(string.charAt(n2++));
                    }
                    break;
                }
            }
        }
        while (n2 < n3 && string.charAt(n2) == '.') {
            this.dur += this.dur / 2;
            ++n2;
        }
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            this.dur /= Character.getNumericValue(string.charAt(n2++));
        }
        if (!bl) {
            if (n2 < n3) {
                switch (string.charAt(n2)) {
                    case 'v': {
                        ++n2;
                        this.vel = 0;
                        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                            this.vel = this.vel * 10 + Character.getNumericValue(string.charAt(n2++));
                        }
                        break;
                    }
                    case 'm': {
                        ++n2;
                        this.vel = 72;
                        while (n2 < n3 && string.charAt(n2) == 'p') {
                            this.vel -= 8;
                            ++n2;
                        }
                        while (n2 < n3 && string.charAt(n2) == 'f') {
                            this.vel += 8;
                            ++n2;
                        }
                        if (this.vel < 1) {
                            this.vel = 1;
                            break;
                        }
                        if (this.vel <= 127) break;
                        this.vel = 127;
                        break;
                    }
                    case 'p': {
                        ++n2;
                        this.vel = 48;
                        while (n2 < n3 && string.charAt(n2) == 'p') {
                            this.vel -= 16;
                            ++n2;
                        }
                        if (this.vel >= 1) break;
                        this.vel = 1;
                        break;
                    }
                    case 'f': {
                        ++n2;
                        this.vel = 96;
                        while (n2 < n3 && string.charAt(n2) == 'f') {
                            this.vel += 16;
                            ++n2;
                        }
                        if (this.vel <= 127) break;
                        this.vel = 127;
                    }
                }
            }
            n = 1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            block45: while (n2 < n3 && n != 0) {
                switch (string.charAt(n2)) {
                    case ',': {
                        bl2 = true;
                        ++n2;
                        continue block45;
                    }
                    case '*': {
                        bl3 = true;
                        bl4 = false;
                        ++n2;
                        continue block45;
                    }
                    case '!': {
                        bl4 = true;
                        bl3 = false;
                        ++n2;
                        continue block45;
                    }
                    case '+': {
                        bl5 = true;
                        ++n2;
                        continue block45;
                    }
                }
                n = 0;
            }
            Note note = new Note();
            note.rest = false;
            note.note = this.octave * 12 + this.step + 12;
            note.duration = this.dur;
            note.velocity = this.vel;
            note.stoccato = bl2;
            note.fermata = bl3;
            note.silent = bl4;
            note.chord = bl5;
            return note;
        }
        Note note = new Note();
        note.rest = true;
        note.note = this.octave * 12 + this.step + 12;
        note.duration = this.dur;
        note.velocity = this.vel;
        note.stoccato = false;
        note.fermata = false;
        note.silent = false;
        note.chord = false;
        return note;
    }

    public Note[] parseNotes(String[] stringArray) {
        Note[] noteArray = new Note[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            noteArray[i] = this.parseNote(stringArray[i]);
        }
        return noteArray;
    }

    public Note[] parseNotes(String string) {
        String[] stringArray = string.trim().split("\\s+");
        return this.parseNotes(stringArray);
    }
}

