/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.BitInputStream;
import com.kreative.openxion.binpack.BitOutputStream;
import com.kreative.openxion.binpack.DFExpression;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFBinaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression left;
    private DFExpression right;

    public DFBinaryExpression(Operation operation, DFExpression dFExpression, DFExpression dFExpression2) {
        this.op = operation;
        this.left = dFExpression;
        this.right = dFExpression2;
    }

    @Override
    public int evaluate() {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate() != 0 || this.right.evaluate() != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate() != 0 != (this.right.evaluate() != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate() != 0 && this.right.evaluate() != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate() != 0 == (this.right.evaluate() != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate() == this.right.evaluate() ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate() != this.right.evaluate() ? 1 : 0;
            }
            case COMPARE: {
                int n = this.left.evaluate();
                int n2 = this.right.evaluate();
                return n < n2 ? -1 : (n > n2 ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate() < this.right.evaluate() ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate() <= this.right.evaluate() ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate() > this.right.evaluate() ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate() >= this.right.evaluate() ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate() | this.right.evaluate();
            }
            case BITWISE_XOR: {
                return this.left.evaluate() ^ this.right.evaluate();
            }
            case BITWISE_AND: {
                return this.left.evaluate() & this.right.evaluate();
            }
            case SHIFT_LEFT: {
                return this.left.evaluate() << this.right.evaluate();
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate() >> this.right.evaluate();
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate() >>> this.right.evaluate();
            }
            case ADD: {
                return this.left.evaluate() + this.right.evaluate();
            }
            case SUBTRACT: {
                return this.left.evaluate() - this.right.evaluate();
            }
            case MULTIPLY: {
                return this.left.evaluate() * this.right.evaluate();
            }
            case DIVIDE: {
                return this.left.evaluate() / this.right.evaluate();
            }
            case MOD: {
                return this.left.evaluate() % this.right.evaluate();
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitInputStream bitInputStream, long l) {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate(map, bitInputStream, l) != 0 || this.right.evaluate(map, bitInputStream, l) != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate(map, bitInputStream, l) != 0 != (this.right.evaluate(map, bitInputStream, l) != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate(map, bitInputStream, l) != 0 && this.right.evaluate(map, bitInputStream, l) != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate(map, bitInputStream, l) != 0 == (this.right.evaluate(map, bitInputStream, l) != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate(map, bitInputStream, l) == this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate(map, bitInputStream, l) != this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case COMPARE: {
                int n = this.left.evaluate(map, bitInputStream, l);
                int n2 = this.right.evaluate(map, bitInputStream, l);
                return n < n2 ? -1 : (n > n2 ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate(map, bitInputStream, l) < this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate(map, bitInputStream, l) <= this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate(map, bitInputStream, l) > this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate(map, bitInputStream, l) >= this.right.evaluate(map, bitInputStream, l) ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate(map, bitInputStream, l) | this.right.evaluate(map, bitInputStream, l);
            }
            case BITWISE_XOR: {
                return this.left.evaluate(map, bitInputStream, l) ^ this.right.evaluate(map, bitInputStream, l);
            }
            case BITWISE_AND: {
                return this.left.evaluate(map, bitInputStream, l) & this.right.evaluate(map, bitInputStream, l);
            }
            case SHIFT_LEFT: {
                return this.left.evaluate(map, bitInputStream, l) << this.right.evaluate(map, bitInputStream, l);
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate(map, bitInputStream, l) >> this.right.evaluate(map, bitInputStream, l);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate(map, bitInputStream, l) >>> this.right.evaluate(map, bitInputStream, l);
            }
            case ADD: {
                return this.left.evaluate(map, bitInputStream, l) + this.right.evaluate(map, bitInputStream, l);
            }
            case SUBTRACT: {
                return this.left.evaluate(map, bitInputStream, l) - this.right.evaluate(map, bitInputStream, l);
            }
            case MULTIPLY: {
                return this.left.evaluate(map, bitInputStream, l) * this.right.evaluate(map, bitInputStream, l);
            }
            case DIVIDE: {
                return this.left.evaluate(map, bitInputStream, l) / this.right.evaluate(map, bitInputStream, l);
            }
            case MOD: {
                return this.left.evaluate(map, bitInputStream, l) % this.right.evaluate(map, bitInputStream, l);
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> map, BitOutputStream bitOutputStream) {
        switch (this.op) {
            case BOOLEAN_OR: {
                return this.left.evaluate(map, bitOutputStream) != 0 || this.right.evaluate(map, bitOutputStream) != 0 ? 1 : 0;
            }
            case BOOLEAN_XOR: {
                return this.left.evaluate(map, bitOutputStream) != 0 != (this.right.evaluate(map, bitOutputStream) != 0) ? 1 : 0;
            }
            case BOOLEAN_AND: {
                return this.left.evaluate(map, bitOutputStream) != 0 && this.right.evaluate(map, bitOutputStream) != 0 ? 1 : 0;
            }
            case BOOLEAN_EQUAL: {
                return this.left.evaluate(map, bitOutputStream) != 0 == (this.right.evaluate(map, bitOutputStream) != 0) ? 1 : 0;
            }
            case EQUAL: {
                return this.left.evaluate(map, bitOutputStream) == this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case NOT_EQUAL: {
                return this.left.evaluate(map, bitOutputStream) != this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case COMPARE: {
                int n = this.left.evaluate(map, bitOutputStream);
                int n2 = this.right.evaluate(map, bitOutputStream);
                return n < n2 ? -1 : (n > n2 ? 1 : 0);
            }
            case LESS_THAN: {
                return this.left.evaluate(map, bitOutputStream) < this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case LESS_OR_EQUAL: {
                return this.left.evaluate(map, bitOutputStream) <= this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case GREATER_THAN: {
                return this.left.evaluate(map, bitOutputStream) > this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case GREATER_OR_EQUAL: {
                return this.left.evaluate(map, bitOutputStream) >= this.right.evaluate(map, bitOutputStream) ? 1 : 0;
            }
            case BITWISE_OR: {
                return this.left.evaluate(map, bitOutputStream) | this.right.evaluate(map, bitOutputStream);
            }
            case BITWISE_XOR: {
                return this.left.evaluate(map, bitOutputStream) ^ this.right.evaluate(map, bitOutputStream);
            }
            case BITWISE_AND: {
                return this.left.evaluate(map, bitOutputStream) & this.right.evaluate(map, bitOutputStream);
            }
            case SHIFT_LEFT: {
                return this.left.evaluate(map, bitOutputStream) << this.right.evaluate(map, bitOutputStream);
            }
            case SHIFT_RIGHT: {
                return this.left.evaluate(map, bitOutputStream) >> this.right.evaluate(map, bitOutputStream);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.left.evaluate(map, bitOutputStream) >>> this.right.evaluate(map, bitOutputStream);
            }
            case ADD: {
                return this.left.evaluate(map, bitOutputStream) + this.right.evaluate(map, bitOutputStream);
            }
            case SUBTRACT: {
                return this.left.evaluate(map, bitOutputStream) - this.right.evaluate(map, bitOutputStream);
            }
            case MULTIPLY: {
                return this.left.evaluate(map, bitOutputStream) * this.right.evaluate(map, bitOutputStream);
            }
            case DIVIDE: {
                return this.left.evaluate(map, bitOutputStream) / this.right.evaluate(map, bitOutputStream);
            }
            case MOD: {
                return this.left.evaluate(map, bitOutputStream) % this.right.evaluate(map, bitOutputStream);
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.left.toString());
        switch (this.op) {
            case BOOLEAN_OR: {
                stringBuffer.append("||");
                break;
            }
            case BOOLEAN_XOR: {
                stringBuffer.append("^^");
                break;
            }
            case BOOLEAN_AND: {
                stringBuffer.append("&&");
                break;
            }
            case EQUAL: {
                stringBuffer.append("==");
                break;
            }
            case NOT_EQUAL: {
                stringBuffer.append("!=");
                break;
            }
            case COMPARE: {
                stringBuffer.append("<=>");
                break;
            }
            case LESS_THAN: {
                stringBuffer.append("<");
                break;
            }
            case LESS_OR_EQUAL: {
                stringBuffer.append("<=");
                break;
            }
            case GREATER_THAN: {
                stringBuffer.append(">");
                break;
            }
            case GREATER_OR_EQUAL: {
                stringBuffer.append(">=");
                break;
            }
            case BITWISE_OR: {
                stringBuffer.append("|");
                break;
            }
            case BITWISE_XOR: {
                stringBuffer.append("^");
                break;
            }
            case BITWISE_AND: {
                stringBuffer.append("&");
                break;
            }
            case SHIFT_LEFT: {
                stringBuffer.append("<<");
                break;
            }
            case SHIFT_RIGHT: {
                stringBuffer.append(">>");
                break;
            }
            case UNSIGNED_SHIFT_RIGHT: {
                stringBuffer.append(">>>");
                break;
            }
            case ADD: {
                stringBuffer.append("+");
                break;
            }
            case SUBTRACT: {
                stringBuffer.append("-");
                break;
            }
            case MULTIPLY: {
                stringBuffer.append("*");
                break;
            }
            case DIVIDE: {
                stringBuffer.append("/");
                break;
            }
            case MOD: {
                stringBuffer.append("%");
                break;
            }
            default: {
                stringBuffer.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        stringBuffer.append(this.right.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        BOOLEAN_OR,
        BOOLEAN_XOR,
        BOOLEAN_AND,
        BOOLEAN_EQUAL,
        EQUAL,
        NOT_EQUAL,
        COMPARE,
        LESS_THAN,
        LESS_OR_EQUAL,
        GREATER_THAN,
        GREATER_OR_EQUAL,
        BITWISE_OR,
        BITWISE_XOR,
        BITWISE_AND,
        SHIFT_LEFT,
        SHIFT_RIGHT,
        UNSIGNED_SHIFT_RIGHT,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD;

    }
}

