/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.binpack;

import com.kreative.openxion.binpack.BitOutputStream;
import com.kreative.openxion.binpack.ColorFormat;
import com.kreative.openxion.binpack.DataField;
import com.kreative.openxion.binpack.DateFormat;
import com.kreative.openxion.binpack.MapStack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWriter {
    private List<DataField> format;

    public DataWriter(List<DataField> list) {
        this.format = list;
    }

    public byte[] pack(List<?> list) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.pack(list, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void pack(List<?> list, File file) throws IOException {
        this.pack(list, (OutputStream)new FileOutputStream(file));
    }

    public void pack(List<?> list, OutputStream outputStream) throws IOException {
        this.pack(list, new BitOutputStream(outputStream));
    }

    public void pack(List<?> list, BitOutputStream bitOutputStream) throws IOException {
        DataWriter.pack(this.format, list, new MapStack<String, Object>(), bitOutputStream);
    }

    public byte[] pack(Map<String, ?> map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.pack(map, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void pack(Map<String, ?> map, File file) throws IOException {
        this.pack(map, (OutputStream)new FileOutputStream(file));
    }

    public void pack(Map<String, ?> map, OutputStream outputStream) throws IOException {
        this.pack(map, new BitOutputStream(outputStream));
    }

    public void pack(Map<String, ?> map, BitOutputStream bitOutputStream) throws IOException {
        DataWriter.pack(this.format, map, new MapStack<String, Object>(), bitOutputStream);
    }

    private static void pack(List<DataField> list, List<?> list2, MapStack<String, Object> mapStack, BitOutputStream bitOutputStream) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<?> iterator = list2.iterator();
        for (DataField dataField : list) {
            Object v;
            if (!dataField.type().returns()) continue;
            Object v2 = v = iterator.hasNext() ? (Object)iterator.next() : null;
            if (dataField.name() == null) continue;
            hashMap.put(dataField.name(), v);
        }
        DataWriter.pack(list, list2, hashMap, mapStack, bitOutputStream);
    }

    private static void pack(List<DataField> list, Map<String, ?> map, MapStack<String, Object> mapStack, BitOutputStream bitOutputStream) throws IOException {
        ArrayList arrayList = new ArrayList();
        for (DataField dataField : list) {
            if (!dataField.type().returns()) continue;
            if (dataField.name() != null && map.containsKey(dataField.name())) {
                arrayList.add(map.get(dataField.name()));
                continue;
            }
            arrayList.add(null);
        }
        DataWriter.pack(list, arrayList, map, mapStack, bitOutputStream);
    }

    private static void pack(List<DataField> list, List<?> list2, Map<String, ?> map, MapStack<String, Object> mapStack, BitOutputStream bitOutputStream) throws IOException {
        mapStack.push(map);
        Iterator<?> iterator = list2.iterator();
        for (DataField dataField : list) {
            if (dataField.type().returns()) {
                Object var8_8 = iterator.hasNext() ? iterator.next() : null;
                DataWriter.packFieldWithCount(dataField, var8_8, mapStack, bitOutputStream);
                continue;
            }
            DataWriter.packFieldWithCount(dataField, null, mapStack, bitOutputStream);
        }
        mapStack.pop();
    }

    private static void packFieldWithCount(DataField dataField, Object object, MapStack<String, Object> mapStack, BitOutputStream bitOutputStream) throws IOException {
        if (dataField.count() == null || dataField.type().usesCustomCount()) {
            DataWriter.packFieldWithoutCount(dataField, object, mapStack, bitOutputStream);
        } else {
            int n = dataField.count().evaluate(mapStack, bitOutputStream);
            if (dataField.type().returns()) {
                Object object2;
                Object object3;
                if (object instanceof Collection) {
                    object3 = (Collection)object;
                } else {
                    object2 = new ArrayList<Object>();
                    ((ArrayList)object2).add(object);
                    object3 = object2;
                }
                object2 = object3.iterator();
                while (n-- > 0) {
                    Object var7_7 = object2.hasNext() ? object2.next() : null;
                    DataWriter.packFieldWithoutCount(dataField, var7_7, mapStack, bitOutputStream);
                }
            } else {
                while (n-- > 0) {
                    DataWriter.packFieldWithoutCount(dataField, null, mapStack, bitOutputStream);
                }
            }
        }
    }

    private static void packFieldWithoutCount(DataField dataField, Object object, MapStack<String, Object> mapStack, BitOutputStream bitOutputStream) throws IOException {
        switch (dataField.type()) {
            case BOOLEAN: {
                boolean bl;
                boolean bl2 = bl = object instanceof Boolean && (Boolean)object != false;
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bl ? BigInteger.ONE : BigInteger.ZERO);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bl ? BigInteger.ONE : BigInteger.ZERO);
                break;
            }
            case ENUM: {
                String string = object == null ? "" : object.toString();
                for (Map.Entry entry : ((Map)dataField.elaboration()).entrySet()) {
                    if (!entry.getValue().toString().equalsIgnoreCase(string)) continue;
                    BigInteger bigInteger = (BigInteger)entry.getKey();
                    if (dataField.littleEndian()) {
                        bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    } else {
                        bitOutputStream.writeInteger(dataField.size(), bigInteger);
                    }
                    return;
                }
                BigInteger bigInteger = object instanceof BigInteger ? (BigInteger)object : (object instanceof BigDecimal ? ((BigDecimal)object).toBigInteger() : (object instanceof Number ? BigInteger.valueOf(((Number)object).longValue()) : (object != null ? new BigInteger(object.toString()) : BigInteger.ZERO)));
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case BITFIELD: {
                Object object2;
                Object object3;
                BitSet bitSet = new BitSet();
                if (object instanceof Collection) {
                    object3 = (Collection)object;
                } else {
                    object2 = new ArrayList<Object>();
                    object2.add(object);
                    object3 = object2;
                }
                object2 = (Map)dataField.elaboration();
                for (int i = 0; i < dataField.size(); ++i) {
                    BigInteger bigInteger = BigInteger.valueOf(i);
                    if (object2.containsKey(bigInteger) && object3.contains(object2.get(bigInteger))) {
                        bitSet.set(i);
                        continue;
                    }
                    if (!object2.containsKey(i) || !object3.contains(object2.get(i))) continue;
                    bitSet.set(i);
                }
                if (dataField.littleEndian()) {
                    bitOutputStream.writeBitsLE(dataField.size(), bitSet);
                    break;
                }
                bitOutputStream.writeBits(dataField.size(), bitSet);
                break;
            }
            case BINT: {
                BigInteger bigInteger;
                BigInteger bigInteger2 = bigInteger = object == null ? BigInteger.ZERO : new BigInteger(object.toString(), 2);
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case OINT: {
                BigInteger bigInteger;
                BigInteger bigInteger3 = bigInteger = object == null ? BigInteger.ZERO : new BigInteger(object.toString(), 8);
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case HINT: {
                BigInteger bigInteger;
                BigInteger bigInteger4 = bigInteger = object == null ? BigInteger.ZERO : new BigInteger(object.toString(), 16);
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case UINT: 
            case SINT: {
                BigInteger bigInteger = object instanceof BigInteger ? (BigInteger)object : (object instanceof BigDecimal ? ((BigDecimal)object).toBigInteger() : (object instanceof Number ? BigInteger.valueOf(((Number)object).longValue()) : (object != null ? new BigInteger(object.toString()) : BigInteger.ZERO)));
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case UFIXED: 
            case SFIXED: {
                BigDecimal bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : (object instanceof BigInteger ? new BigDecimal((BigInteger)object) : (object instanceof Number ? BigDecimal.valueOf(((Number)object).doubleValue()) : (object != null ? new BigDecimal(object.toString()) : BigDecimal.ZERO)));
                bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(2L).pow(dataField.size() / 2), MathContext.DECIMAL128);
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigDecimal.toBigInteger());
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigDecimal.toBigInteger());
                break;
            }
            case FLOAT: {
                Number number = object instanceof Number ? (Number)((Number)object) : (Number)(object != null ? new BigDecimal(object.toString()) : Integer.valueOf(0));
                int[] nArray = (int[])dataField.elaboration();
                if (dataField.littleEndian()) {
                    bitOutputStream.writeFloatLE(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128, number);
                    break;
                }
                bitOutputStream.writeFloat(nArray[0], nArray[1], nArray[2], nArray[3], MathContext.DECIMAL128, number);
                break;
            }
            case COMPLEX: {
                Integer n;
                Number number;
                Object[] objectArray;
                if (object instanceof Number[]) {
                    objectArray = (Number[])object;
                    number = objectArray.length > 0 ? (Number)objectArray[0] : (Number)0;
                    n = objectArray.length > 1 ? (Number)objectArray[1] : (Number)0;
                } else if (object != null) {
                    number = new BigDecimal(object.toString());
                    n = 0;
                } else {
                    number = 0;
                    n = 0;
                }
                objectArray = (int[])dataField.elaboration();
                if (dataField.littleEndian()) {
                    bitOutputStream.writeFloatLE((int)objectArray[0], (int)objectArray[1], (int)objectArray[2], (int)objectArray[3], MathContext.DECIMAL128, number);
                    bitOutputStream.writeFloatLE((int)objectArray[0], (int)objectArray[1], (int)objectArray[2], (int)objectArray[3], MathContext.DECIMAL128, n);
                    break;
                }
                bitOutputStream.writeFloat((int)objectArray[0], (int)objectArray[1], (int)objectArray[2], (int)objectArray[3], MathContext.DECIMAL128, number);
                bitOutputStream.writeFloat((int)objectArray[0], (int)objectArray[1], (int)objectArray[2], (int)objectArray[3], MathContext.DECIMAL128, n);
                break;
            }
            case CHAR: {
                int n;
                if ((dataField.size() & 7) != 0) {
                    throw new IOException("Character values must be of a byte-multiple width");
                }
                int n2 = dataField.size() >> 3;
                byte[] byArray = object == null ? new byte[]{} : object.toString().getBytes(dataField.elaboration().toString());
                byte[] byArray2 = new byte[n2];
                for (n = 0; n < byArray.length && n < byArray2.length; ++n) {
                    byArray2[n] = byArray[n];
                }
                if (dataField.littleEndian()) {
                    n = 0;
                    int n3 = byArray2.length - 1;
                    while (n < byArray2.length / 2) {
                        byte by = byArray2[n];
                        byArray2[n] = byArray2[n3];
                        byArray2[n3] = by;
                        ++n;
                        --n3;
                    }
                }
                bitOutputStream.write(byArray2);
                break;
            }
            case PSTRING: {
                byte[] byArray;
                byte[] byArray3 = byArray = object == null ? new byte[]{} : object.toString().getBytes(dataField.elaboration().toString());
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), BigInteger.valueOf(byArray.length));
                } else {
                    bitOutputStream.writeInteger(dataField.size(), BigInteger.valueOf(byArray.length));
                }
                bitOutputStream.write(byArray);
                break;
            }
            case CSTRING: {
                byte[] byArray = object == null ? new byte[]{} : object.toString().getBytes(dataField.elaboration().toString());
                bitOutputStream.write(byArray);
                bitOutputStream.writeInteger(dataField.size(), BigInteger.ZERO);
                break;
            }
            case DATE: {
                if (object instanceof Calendar) {
                    Calendar calendar = (Calendar)object;
                    DateFormat dateFormat = (DateFormat)dataField.elaboration();
                    if (dataField.littleEndian()) {
                        bitOutputStream.writeIntegerLE(dataField.size(), BigInteger.valueOf(dateFormat.calendarToLong(calendar)));
                        break;
                    }
                    bitOutputStream.writeInteger(dataField.size(), BigInteger.valueOf(dateFormat.calendarToLong(calendar)));
                    break;
                }
                if (object instanceof Date) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime((Date)object);
                    DateFormat dateFormat = (DateFormat)dataField.elaboration();
                    if (dataField.littleEndian()) {
                        bitOutputStream.writeIntegerLE(dataField.size(), BigInteger.valueOf(dateFormat.calendarToLong(gregorianCalendar)));
                        break;
                    }
                    bitOutputStream.writeInteger(dataField.size(), BigInteger.valueOf(dateFormat.calendarToLong(gregorianCalendar)));
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), BigInteger.ZERO);
                break;
            }
            case COLOR: {
                float[] fArray = object instanceof float[] ? (float[])object : new float[4];
                ColorFormat colorFormat = (ColorFormat)dataField.elaboration();
                BigInteger[] bigIntegerArray = colorFormat.toBigIntArray(colorFormat.fromRGBAFloatArray(fArray));
                BigInteger bigInteger = BigInteger.ZERO;
                for (int i = 0; i < colorFormat.channelCount(); ++i) {
                    bigInteger = bigInteger.shiftLeft(colorFormat.channelWidth(i)).or(bigIntegerArray[i]);
                }
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case FILLER: {
                bitOutputStream.writeBits(dataField.size(), new BitSet());
                break;
            }
            case MAGIC: {
                BigInteger bigInteger = (BigInteger)dataField.elaboration();
                if (dataField.littleEndian()) {
                    bitOutputStream.writeIntegerLE(dataField.size(), bigInteger);
                    break;
                }
                bitOutputStream.writeInteger(dataField.size(), bigInteger);
                break;
            }
            case ALIGN: {
                while (!bitOutputStream.atBitBoundary(dataField.size())) {
                    bitOutputStream.writeBit(false);
                }
                break;
            }
            case BINARY: {
                if (dataField.count() != null) {
                    int n;
                    int n4 = dataField.count().evaluate(mapStack, bitOutputStream);
                    byte[] byArray = object instanceof byte[] ? (byte[])object : new byte[]{};
                    for (n = 0; n < byArray.length && n < n4; ++n) {
                        bitOutputStream.writeByte(byArray[n]);
                    }
                    for (n = byArray.length; n < n4; ++n) {
                        bitOutputStream.writeByte(0);
                    }
                    break;
                }
                if (!(object instanceof byte[])) break;
                byte[] byArray = (byte[])object;
                bitOutputStream.write(byArray);
                break;
            }
            case STRUCT: {
                List list = (List)dataField.elaboration();
                if (object instanceof Map) {
                    Map map = (Map)object;
                    DataWriter.pack((List<DataField>)list, map, mapStack, bitOutputStream);
                    break;
                }
                if (object instanceof List) {
                    List list2 = (List)object;
                    DataWriter.pack((List<DataField>)list, list2, mapStack, bitOutputStream);
                    break;
                }
                DataWriter.pack(list, new ArrayList(), new HashMap(), mapStack, bitOutputStream);
                break;
            }
            case OFFSET: {
                if (dataField.count() == null) break;
                int n = dataField.count().evaluate(mapStack, bitOutputStream);
                long l = (long)n << 3;
                if (l < bitOutputStream.bitsWritten()) {
                    throw new IOException("Can't seek backward in a pack operation");
                }
                while (bitOutputStream.bitsWritten() < l) {
                    bitOutputStream.writeBit(false);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type: " + dataField.type().toString());
            }
        }
    }
}

