/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.format;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNInterpreter;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.ast.XNOperator;
import com.kreative.openxion.format.FSExpression;
import com.kreative.openxion.math.MathProcessor;
import com.kreative.openxion.math.XOMComplexMath;
import com.kreative.openxion.math.XOMNumberMath;
import com.kreative.openxion.xom.XOMMorphError;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMBoolean;
import com.kreative.openxion.xom.inst.XOMComplex;
import com.kreative.openxion.xom.inst.XOMInteger;
import com.kreative.openxion.xom.inst.XOMList;
import com.kreative.openxion.xom.inst.XOMNumber;
import com.kreative.openxion.xom.inst.XOMPoint;
import com.kreative.openxion.xom.inst.XOMRectangle;
import com.kreative.openxion.xom.inst.XOMString;
import com.kreative.openxion.xom.type.XOMBooleanType;
import com.kreative.openxion.xom.type.XOMComplexType;
import com.kreative.openxion.xom.type.XOMIntegerType;
import com.kreative.openxion.xom.type.XOMNumberType;
import com.kreative.openxion.xom.type.XOMPointType;
import com.kreative.openxion.xom.type.XOMRectangleType;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSBinaryExpression
implements FSExpression {
    private FSExpression left;
    private XNOperator op;
    private FSExpression right;

    public FSBinaryExpression(FSExpression fSExpression, XNOperator xNOperator, FSExpression fSExpression2) {
        this.left = fSExpression;
        this.op = xNOperator;
        this.right = fSExpression2;
    }

    @Override
    public XOMVariant evaluate(XNContext xNContext, List<? extends XOMVariant> list) {
        MathContext mathContext = xNContext.getMathContext();
        MathProcessor mathProcessor = xNContext.getMathProcessor();
        switch (this.op) {
            case EXPONENT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant2 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant2 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex2 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant2, true);
                    return XOMComplexMath.pow(xOMComplex, xOMComplex2, mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant2 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber2 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant2, true);
                    return XOMNumberMath.pow(xOMNumber, xOMNumber2, mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant2, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber3 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant2, true);
                    return XOMNumberMath.pow(xOMNumber, xOMNumber3, mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant2, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex3 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant2, true);
                    return XOMComplexMath.pow(xOMComplex, xOMComplex3, mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case MULTIPLY: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant3 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant3 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex4 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant3, true);
                    return XOMComplexMath.multiply(xOMComplex, xOMComplex4, mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant3 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber4 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant3, true);
                    return XOMNumberMath.multiply(xOMNumber, xOMNumber4, mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant3, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber5 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant3, true);
                    return XOMNumberMath.multiply(xOMNumber, xOMNumber5, mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant3, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex5 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant3, true);
                    return XOMComplexMath.multiply(xOMComplex, xOMComplex5, mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case DIVIDE: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant4 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant4 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex6 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant4, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex6, mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant4 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber6 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant4, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber6, mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant4, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber7 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant4, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber7, mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant4, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex7 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant4, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex7, mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case QUOT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant5 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant5 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex8 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant5, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex8, mathContext, mathProcessor).trunc();
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant5 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber8 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant5, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber8, mathContext, mathProcessor).trunc();
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant5, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber9 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant5, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber9, mathContext, mathProcessor).trunc();
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant5, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex9 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant5, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex9, mathContext, mathProcessor).trunc();
                }
                throw new XOMMorphError("number");
            }
            case REM: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant6 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant6 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex10 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant6, true);
                    return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex10, XOMComplexMath.divide(xOMComplex, xOMComplex10, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant6 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber10 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant6, true);
                    return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber10, XOMNumberMath.divide(xOMNumber, xOMNumber10, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant6, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber11 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant6, true);
                    return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber11, XOMNumberMath.divide(xOMNumber, xOMNumber11, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant6, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex11 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant6, true);
                    return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex11, XOMComplexMath.divide(xOMComplex, xOMComplex11, mathContext, mathProcessor).trunc(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case DIV: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant7 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant7 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex12 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant7, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex12, mathContext, mathProcessor).floor();
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant7 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber12 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant7, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber12, mathContext, mathProcessor).floor();
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant7, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber13 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant7, true);
                    return XOMNumberMath.divide(xOMNumber, xOMNumber13, mathContext, mathProcessor).floor();
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant7, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex13 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant7, true);
                    return XOMComplexMath.divide(xOMComplex, xOMComplex13, mathContext, mathProcessor).floor();
                }
                throw new XOMMorphError("number");
            }
            case MOD: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant8 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant8 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex14 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant8, true);
                    return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex14, XOMComplexMath.divide(xOMComplex, xOMComplex14, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant8 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber14 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant8, true);
                    return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber14, XOMNumberMath.divide(xOMNumber, xOMNumber14, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant8, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber15 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant8, true);
                    return XOMNumberMath.subtract(xOMNumber, XOMNumberMath.multiply(xOMNumber15, XOMNumberMath.divide(xOMNumber, xOMNumber15, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant8, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex15 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant8, true);
                    return XOMComplexMath.subtract(xOMComplex, XOMComplexMath.multiply(xOMComplex15, XOMComplexMath.divide(xOMComplex, xOMComplex15, mathContext, mathProcessor).floor(), mathContext, mathProcessor), mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case ADD: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant9 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant9 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex16 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant9, true);
                    return XOMComplexMath.add(xOMComplex, xOMComplex16, mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant9 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber16 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant9, true);
                    return XOMNumberMath.add(xOMNumber, xOMNumber16, mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant9, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber17 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant9, true);
                    return XOMNumberMath.add(xOMNumber, xOMNumber17, mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant9, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex17 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant9, true);
                    return XOMComplexMath.add(xOMComplex, xOMComplex17, mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case SUBTRACT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant10 = this.right.evaluate(xNContext, list);
                if (xOMVariant instanceof XOMComplex && xOMVariant10 instanceof XOMComplex) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex18 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant10, true);
                    return XOMComplexMath.subtract(xOMComplex, xOMComplex18, mathContext, mathProcessor);
                }
                if (xOMVariant instanceof XOMNumber && xOMVariant10 instanceof XOMNumber) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber18 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant10, true);
                    return XOMNumberMath.subtract(xOMNumber, xOMNumber18, mathContext, mathProcessor);
                }
                if (XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMNumberType.instance.canMakeInstanceFrom(xNContext, xOMVariant10, true)) {
                    XOMNumber xOMNumber = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMNumber xOMNumber19 = (XOMNumber)XOMNumberType.instance.makeInstanceFrom(xNContext, xOMVariant10, true);
                    return XOMNumberMath.subtract(xOMNumber, xOMNumber19, mathContext, mathProcessor);
                }
                if (XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant, true) && XOMComplexType.instance.canMakeInstanceFrom(xNContext, xOMVariant10, true)) {
                    XOMComplex xOMComplex = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant, true);
                    XOMComplex xOMComplex19 = (XOMComplex)XOMComplexType.instance.makeInstanceFrom(xNContext, xOMVariant10, true);
                    return XOMComplexMath.subtract(xOMComplex, xOMComplex19, mathContext, mathProcessor);
                }
                throw new XOMMorphError("number");
            }
            case SHIFT_LEFT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant11 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger2 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant11, true)).toBigInteger();
                if (bigInteger == null || bigInteger2 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.shiftLeft(bigInteger2.intValue()));
            }
            case SHIFT_RIGHT_SIGNED: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant12 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger3 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant12, true)).toBigInteger();
                if (bigInteger == null || bigInteger3 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.shiftRight(bigInteger3.intValue()));
            }
            case SHIFT_RIGHT_UNSIGNED: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant13 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger4 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant13, true)).toBigInteger();
                if (bigInteger == null || bigInteger4 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.shiftRight(bigInteger4.intValue()));
            }
            case BIT_AND: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant14 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger5 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant14, true)).toBigInteger();
                if (bigInteger == null || bigInteger5 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.and(bigInteger5));
            }
            case BIT_XOR: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant15 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger6 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant15, true)).toBigInteger();
                if (bigInteger == null || bigInteger6 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.xor(bigInteger6));
            }
            case BIT_OR: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant16 = this.right.evaluate(xNContext, list);
                BigInteger bigInteger = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant, true)).toBigInteger();
                BigInteger bigInteger7 = ((XOMInteger)XOMIntegerType.instance.makeInstanceFrom(xNContext, xOMVariant16, true)).toBigInteger();
                if (bigInteger == null || bigInteger7 == null) {
                    return XOMInteger.NaN;
                }
                return new XOMInteger(bigInteger.or(bigInteger7));
            }
            case STR_CONCAT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant17 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext);
                String string2 = xOMVariant17.toTextString(xNContext);
                return new XOMString(string + string2);
            }
            case STR_CONCAT_SPACE: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant18 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext);
                String string3 = xOMVariant18.toTextString(xNContext);
                return new XOMString(string + " " + string3);
            }
            case LIST_APPEND: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant19 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list2 = xOMVariant.toPrimitiveList(xNContext);
                Vector<XOMVariant> vector = new Vector<XOMVariant>();
                vector.add(xOMVariant19);
                return new XOMList(list2, vector);
            }
            case LIST_CONCAT: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant20 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list3 = xOMVariant.toPrimitiveList(xNContext);
                List<? extends XOMVariant> list4 = xOMVariant20.toPrimitiveList(xNContext);
                return new XOMList(list3, list4);
            }
            case LT_NUM: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant21 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant21) < 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case GT_NUM: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant22 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant22) > 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case LE_NUM: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant23 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant23) <= 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case GE_NUM: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant24 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant24) >= 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case CONTAINS: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant25 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string4 = xOMVariant25.toTextString(xNContext).toLowerCase();
                return string.contains(string4) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case STARTS_WITH: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant26 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string5 = xOMVariant26.toTextString(xNContext).toLowerCase();
                return string.startsWith(string5) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case ENDS_WITH: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant27 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string6 = xOMVariant27.toTextString(xNContext).toLowerCase();
                return string.endsWith(string6) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case IN: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant28 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string7 = xOMVariant28.toTextString(xNContext).toLowerCase();
                return string7.contains(string) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case WITHIN: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant29 = this.right.evaluate(xNContext, list);
                XOMRectangle xOMRectangle = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(xNContext, xOMVariant29);
                if (XOMRectangleType.instance.canMakeInstanceFrom(xNContext, xOMVariant)) {
                    XOMRectangle xOMRectangle2 = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(xNContext, xOMVariant);
                    return xOMRectangle.contains(xOMRectangle2) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                if (XOMPointType.instance.canMakeInstanceFrom(xNContext, xOMVariant)) {
                    XOMPoint xOMPoint = (XOMPoint)XOMPointType.instance.makeInstanceFrom(xNContext, xOMVariant);
                    return xOMRectangle.contains(xOMPoint) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                throw new XOMMorphError("point");
            }
            case ELEMENT_OF: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant30 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list5 = xOMVariant30.toPrimitiveList(xNContext);
                for (XOMVariant xOMVariant31 : list5) {
                    try {
                        if (new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant31) != 0) continue;
                        return XOMBoolean.TRUE;
                    }
                    catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    }
                }
                return XOMBoolean.FALSE;
            }
            case PRECISELY_ELEMENT_OF: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant32 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list6 = xOMVariant32.toPrimitiveList(xNContext);
                for (XOMVariant xOMVariant33 : list6) {
                    if (!xOMVariant.equals(xOMVariant33)) continue;
                    return XOMBoolean.TRUE;
                }
                return XOMBoolean.FALSE;
            }
            case NOT_CONTAINS: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant34 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string8 = xOMVariant34.toTextString(xNContext).toLowerCase();
                return !string.contains(string8) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case NOT_STARTS_WITH: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant35 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string9 = xOMVariant35.toTextString(xNContext).toLowerCase();
                return !string.startsWith(string9) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case NOT_ENDS_WITH: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant36 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string10 = xOMVariant36.toTextString(xNContext).toLowerCase();
                return !string.endsWith(string10) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case NOT_IN: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant37 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext).toLowerCase();
                String string11 = xOMVariant37.toTextString(xNContext).toLowerCase();
                return !string11.contains(string) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case NOT_WITHIN: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant38 = this.right.evaluate(xNContext, list);
                XOMRectangle xOMRectangle = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(xNContext, xOMVariant38);
                if (XOMRectangleType.instance.canMakeInstanceFrom(xNContext, xOMVariant)) {
                    XOMRectangle xOMRectangle3 = (XOMRectangle)XOMRectangleType.instance.makeInstanceFrom(xNContext, xOMVariant);
                    return !xOMRectangle.contains(xOMRectangle3) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                if (XOMPointType.instance.canMakeInstanceFrom(xNContext, xOMVariant)) {
                    XOMPoint xOMPoint = (XOMPoint)XOMPointType.instance.makeInstanceFrom(xNContext, xOMVariant);
                    return !xOMRectangle.contains(xOMPoint) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                throw new XOMMorphError("point");
            }
            case NOT_ELEMENT_OF: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant39 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list7 = xOMVariant39.toPrimitiveList(xNContext);
                for (XOMVariant xOMVariant40 : list7) {
                    try {
                        if (new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant40) != 0) continue;
                        return XOMBoolean.FALSE;
                    }
                    catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    }
                }
                return XOMBoolean.TRUE;
            }
            case NOT_PRECISELY_ELEMENT_OF: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant41 = this.right.evaluate(xNContext, list);
                List<? extends XOMVariant> list8 = xOMVariant41.toPrimitiveList(xNContext);
                for (XOMVariant xOMVariant42 : list8) {
                    if (!xOMVariant.equals(xOMVariant42)) continue;
                    return XOMBoolean.FALSE;
                }
                return XOMBoolean.TRUE;
            }
            case EQUAL: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant43 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant43) == 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case STRICT_EQUAL: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant44 = this.right.evaluate(xNContext, list);
                return xOMVariant.equals(xOMVariant44) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case NOT_EQUAL: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant45 = this.right.evaluate(xNContext, list);
                    return new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant45) != 0 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case NOT_STRICT_EQUAL: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant46 = this.right.evaluate(xNContext, list);
                return !xOMVariant.equals(xOMVariant46) ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case CMP_NUM: {
                try {
                    XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                    XOMVariant xOMVariant47 = this.right.evaluate(xNContext, list);
                    int n = new XNInterpreter(xNContext).compareVariants(xOMVariant, xOMVariant47);
                    return n < 0 ? XOMInteger.ONE.negate() : (n > 0 ? XOMInteger.ONE : XOMInteger.ZERO);
                }
                catch (XNInterpreter.NaNComparisonException naNComparisonException) {
                    return XOMBoolean.FALSE;
                }
            }
            case CMP_STR: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant48 = this.right.evaluate(xNContext, list);
                String string = xOMVariant.toTextString(xNContext);
                String string12 = xOMVariant48.toTextString(xNContext);
                int n = string.compareToIgnoreCase(string12);
                return n < 0 ? XOMInteger.ONE.negate() : (n > 0 ? XOMInteger.ONE : XOMInteger.ZERO);
            }
            case AND: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant49 = this.right.evaluate(xNContext, list);
                boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                boolean bl2 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant49)).toBoolean();
                return bl && bl2 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case SHORT_AND: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                if (!bl) {
                    return XOMBoolean.FALSE;
                }
                XOMVariant xOMVariant50 = this.right.evaluate(xNContext, list);
                boolean bl3 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant50)).toBoolean();
                if (!bl3) {
                    return XOMBoolean.FALSE;
                }
                return XOMBoolean.TRUE;
            }
            case OR: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                XOMVariant xOMVariant51 = this.right.evaluate(xNContext, list);
                boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                boolean bl4 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant51)).toBoolean();
                return bl || bl4 ? XOMBoolean.TRUE : XOMBoolean.FALSE;
            }
            case SHORT_OR: {
                XOMVariant xOMVariant = this.left.evaluate(xNContext, list);
                boolean bl = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant)).toBoolean();
                if (bl) {
                    return XOMBoolean.TRUE;
                }
                XOMVariant xOMVariant52 = this.right.evaluate(xNContext, list);
                boolean bl5 = ((XOMBoolean)XOMBooleanType.instance.makeInstanceFrom(xNContext, xOMVariant52)).toBoolean();
                if (bl5) {
                    return XOMBoolean.TRUE;
                }
                return XOMBoolean.FALSE;
            }
        }
        throw new XNScriptError("Can't understand this");
    }
}

