/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.io.XNFilterIOStream;
import com.kreative.openxion.io.XNIOStream;
import java.io.IOException;

public class XNLittleEndianIOStream
extends XNFilterIOStream {
    public XNLittleEndianIOStream(XNIOStream xNIOStream) {
        super(xNIOStream);
    }

    public char readChar() throws IOException {
        return Character.reverseBytes(this.stream.readChar());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(Long.reverseBytes(this.stream.readLong()));
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.stream.readInt()));
    }

    public int readInt() throws IOException {
        return Integer.reverseBytes(this.stream.readInt());
    }

    public long readLong() throws IOException {
        return Long.reverseBytes(this.stream.readLong());
    }

    public short readShort() throws IOException {
        return Short.reverseBytes(this.stream.readShort());
    }

    public String readUTF() throws IOException {
        int n = Short.reverseBytes(this.stream.readShort());
        if (n < 0) {
            n += 65536;
        }
        byte[] byArray = new byte[n];
        this.stream.read(byArray);
        return new String(byArray, "UTF-8");
    }

    public int readUnsignedShort() throws IOException {
        int n = Short.reverseBytes(this.stream.readShort());
        if (n < 0) {
            n += 65536;
        }
        return n;
    }

    public void writeChar(int n) throws IOException {
        this.stream.writeChar(Character.reverseBytes((char)n));
    }

    public void writeChars(String string) throws IOException {
        for (char c : string.toCharArray()) {
            this.stream.writeChar(Character.reverseBytes(c));
        }
    }

    public void writeDouble(double d) throws IOException {
        this.stream.writeLong(Long.reverseBytes(Double.doubleToRawLongBits(d)));
    }

    public void writeFloat(float f) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(Float.floatToRawIntBits(f)));
    }

    public void writeInt(int n) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(n));
    }

    public void writeLong(long l) throws IOException {
        this.stream.writeLong(Long.reverseBytes(l));
    }

    public void writeShort(int n) throws IOException {
        this.stream.writeShort(Short.reverseBytes((short)n));
    }

    public void writeUTF(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        this.stream.writeShort(Short.reverseBytes((short)byArray.length));
        this.stream.write(byArray);
    }
}

