/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.openxion.io;

import com.kreative.openxion.XNContext;
import com.kreative.openxion.XNScriptError;
import com.kreative.openxion.XNSecurityKey;
import com.kreative.openxion.io.TextIOMethod;
import com.kreative.openxion.io.XNFileIOStream;
import com.kreative.openxion.io.XNIOManager;
import com.kreative.openxion.io.XNIOMethod;
import com.kreative.openxion.io.XNIOStreamInfo;
import com.kreative.openxion.io.XNIOStreamInfoMap;
import com.kreative.openxion.xom.XOMVariant;
import com.kreative.openxion.xom.inst.XOMFile;
import com.kreative.openxion.xom.type.XOMFileType;
import java.io.File;
import java.io.IOException;

public class XOMFileIOManager
implements XNIOManager {
    public static final XOMFileIOManager instance = new XOMFileIOManager();
    private XNIOStreamInfoMap sim = new XNIOStreamInfoMap();

    public boolean worksWith(XNContext xNContext, XOMVariant xOMVariant) {
        return XOMFileType.instance.canMakeInstanceFrom(xNContext, xOMVariant);
    }

    public void open(XNContext xNContext, XOMVariant xOMVariant) {
        this.open(xNContext, xOMVariant, TextIOMethod.instance, "text");
    }

    public void open(XNContext xNContext, XOMVariant xOMVariant, XNIOMethod xNIOMethod, String string) {
        boolean bl;
        if (xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Open", "Object", xOMVariant.toLanguageString(), "Method", xNIOMethod.getClass().getSimpleName(), "Type", string)) {
            bl = true;
        } else if (xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Open", "Object", xOMVariant.toLanguageString(), "Method", xNIOMethod.getClass().getSimpleName(), "Type", string)) {
            bl = false;
        } else {
            throw new XNScriptError("Security settings do not allow open file");
        }
        try {
            XNFileIOStream xNFileIOStream;
            XOMFile xOMFile = XOMFileType.instance.makeInstanceFrom(xNContext, xOMVariant);
            File file = xOMFile.toFile().getAbsoluteFile();
            String string2 = file.getAbsolutePath();
            if (this.sim.getFileStreamInfo(xNContext, xOMVariant) != null) {
                throw new XNScriptError("File \"" + string2 + "\" is already open");
            }
            if (bl) {
                try {
                    xNFileIOStream = new XNFileIOStream(file, "rwd");
                }
                catch (IOException iOException) {
                    xNFileIOStream = new XNFileIOStream(file, "r");
                }
            } else {
                xNFileIOStream = new XNFileIOStream(file, "r");
            }
            XNIOStreamInfo xNIOStreamInfo = new XNIOStreamInfo(xNFileIOStream, xNIOMethod);
            this.sim.setFileStreamInfo(xNContext, xOMVariant, xNIOStreamInfo);
            xNIOStreamInfo.open(xNContext, string);
        }
        catch (IOException iOException) {
            throw new XNScriptError(iOException, "Can't create that file");
        }
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, int n) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, n);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, int n, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, n, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, l);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, l, xOMVariant2);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, int n) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, l, n);
    }

    public XOMVariant read(XNContext xNContext, XOMVariant xOMVariant, long l, int n, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_READ, "Operation", "Read", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow read from file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        return xNIOStreamInfo.read(xNContext, l, n, xOMVariant2);
    }

    public void write(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Write", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow write to file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        if (xNIOStreamInfo.justOpened()) {
            xNIOStreamInfo.truncate(xNContext);
        }
        xNIOStreamInfo.write(xNContext, xOMVariant2);
    }

    public void write(XNContext xNContext, XOMVariant xOMVariant, XOMVariant xOMVariant2, long l) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Write", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow write to file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        xNIOStreamInfo.write(xNContext, xOMVariant2, l);
    }

    public void truncate(XNContext xNContext, XOMVariant xOMVariant) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Truncate", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow truncate file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        xNIOStreamInfo.truncate(xNContext);
    }

    public void truncate(XNContext xNContext, XOMVariant xOMVariant, long l) {
        if (!xNContext.allow(XNSecurityKey.FILE_SYSTEM_WRITE, "Operation", "Truncate", "Object", xOMVariant.toLanguageString())) {
            throw new XNScriptError("Security settings do not allow truncate file");
        }
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        xNIOStreamInfo.truncate(xNContext, l);
    }

    public void close(XNContext xNContext, XOMVariant xOMVariant) {
        XNIOStreamInfo xNIOStreamInfo = this.sim.getFileStreamInfo(xNContext, xOMVariant);
        if (xNIOStreamInfo == null) {
            throw new XNScriptError("File not open");
        }
        xNIOStreamInfo.close(xNContext);
        this.sim.removeStreamInfo(xNIOStreamInfo);
    }
}

